/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.search.documents.indexes.implementation.SearchServiceClientImpl;
import com.azure.search.documents.indexes.implementation.models.ErrorResponseException;
import com.azure.search.documents.indexes.implementation.models.ListKnowledgeSourcesResult;
import com.azure.search.documents.indexes.implementation.models.RequestOptions;
import com.azure.search.documents.indexes.models.KnowledgeSource;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class KnowledgeSourcesImpl {
    private final KnowledgeSourcesService service;
    private final SearchServiceClientImpl client;

    KnowledgeSourcesImpl(SearchServiceClientImpl client) {
        this.service = (KnowledgeSourcesService)RestProxy.create(KnowledgeSourcesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KnowledgeSource>> createOrUpdateWithResponseAsync(String sourceName, KnowledgeSource knowledgeSource, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.createOrUpdateWithResponseAsync(sourceName, knowledgeSource, ifMatch, ifNoneMatch, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KnowledgeSource>> createOrUpdateWithResponseAsync(String sourceName, KnowledgeSource knowledgeSource, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        String prefer = "return=representation";
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.createOrUpdate(this.client.getEndpoint(), sourceName, xMsClientRequestId, ifMatch, ifNoneMatch, "return=representation", this.client.getApiVersion(), "application/json; odata.metadata=minimal", knowledgeSource, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KnowledgeSource> createOrUpdateAsync(String sourceName, KnowledgeSource knowledgeSource, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return this.createOrUpdateWithResponseAsync(sourceName, knowledgeSource, ifMatch, ifNoneMatch, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((KnowledgeSource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KnowledgeSource> createOrUpdateAsync(String sourceName, KnowledgeSource knowledgeSource, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        return this.createOrUpdateWithResponseAsync(sourceName, knowledgeSource, ifMatch, ifNoneMatch, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((KnowledgeSource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KnowledgeSource> createOrUpdateWithResponse(String sourceName, KnowledgeSource knowledgeSource, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        String prefer = "return=representation";
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.createOrUpdateSync(this.client.getEndpoint(), sourceName, xMsClientRequestId, ifMatch, ifNoneMatch, "return=representation", this.client.getApiVersion(), "application/json; odata.metadata=minimal", knowledgeSource, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KnowledgeSource createOrUpdate(String sourceName, KnowledgeSource knowledgeSource, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return (KnowledgeSource)this.createOrUpdateWithResponse(sourceName, knowledgeSource, ifMatch, ifNoneMatch, requestOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String sourceName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.deleteWithResponseAsync(sourceName, ifMatch, ifNoneMatch, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String sourceName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.delete(this.client.getEndpoint(), sourceName, xMsClientRequestId, ifMatch, ifNoneMatch, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String sourceName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return this.deleteWithResponseAsync(sourceName, ifMatch, ifNoneMatch, requestOptions).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String sourceName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        return this.deleteWithResponseAsync(sourceName, ifMatch, ifNoneMatch, requestOptions, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String sourceName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.deleteSync(this.client.getEndpoint(), sourceName, xMsClientRequestId, ifMatch, ifNoneMatch, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String sourceName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        this.deleteWithResponse(sourceName, ifMatch, ifNoneMatch, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KnowledgeSource>> getWithResponseAsync(String sourceName, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.getWithResponseAsync(sourceName, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KnowledgeSource>> getWithResponseAsync(String sourceName, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.get(this.client.getEndpoint(), sourceName, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KnowledgeSource> getAsync(String sourceName, RequestOptions requestOptions) {
        return this.getWithResponseAsync(sourceName, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((KnowledgeSource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KnowledgeSource> getAsync(String sourceName, RequestOptions requestOptions, Context context) {
        return this.getWithResponseAsync(sourceName, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((KnowledgeSource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KnowledgeSource> getWithResponse(String sourceName, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.getSync(this.client.getEndpoint(), sourceName, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KnowledgeSource get(String sourceName, RequestOptions requestOptions) {
        return (KnowledgeSource)this.getWithResponse(sourceName, requestOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<KnowledgeSource>> listSinglePageAsync(RequestOptions requestOptions) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListKnowledgeSourcesResult)res.getValue()).getKnowledgeSources(), null, null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<KnowledgeSource>> listSinglePageAsync(RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.list(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListKnowledgeSourcesResult)res.getValue()).getKnowledgeSources(), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<KnowledgeSource> listAsync(RequestOptions requestOptions) {
        return new PagedFlux(() -> this.listSinglePageAsync(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<KnowledgeSource> listAsync(RequestOptions requestOptions, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(requestOptions, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<KnowledgeSource> listSinglePage(RequestOptions requestOptions) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        Response<ListKnowledgeSourcesResult> res = this.service.listSync(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListKnowledgeSourcesResult)res.getValue()).getKnowledgeSources(), null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<KnowledgeSource> listSinglePage(RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        Response<ListKnowledgeSourcesResult> res = this.service.listSync(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListKnowledgeSourcesResult)res.getValue()).getKnowledgeSources(), null, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KnowledgeSource> list(RequestOptions requestOptions) {
        return new PagedIterable(() -> this.listSinglePage(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KnowledgeSource> list(RequestOptions requestOptions, Context context) {
        return new PagedIterable(() -> this.listSinglePage(requestOptions, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KnowledgeSource>> createWithResponseAsync(KnowledgeSource knowledgeSource, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.createWithResponseAsync(knowledgeSource, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KnowledgeSource>> createWithResponseAsync(KnowledgeSource knowledgeSource, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.create(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", knowledgeSource, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KnowledgeSource> createAsync(KnowledgeSource knowledgeSource, RequestOptions requestOptions) {
        return this.createWithResponseAsync(knowledgeSource, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((KnowledgeSource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KnowledgeSource> createAsync(KnowledgeSource knowledgeSource, RequestOptions requestOptions, Context context) {
        return this.createWithResponseAsync(knowledgeSource, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((KnowledgeSource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KnowledgeSource> createWithResponse(KnowledgeSource knowledgeSource, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.createSync(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", knowledgeSource, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KnowledgeSource create(KnowledgeSource knowledgeSource, RequestOptions requestOptions) {
        return (KnowledgeSource)this.createWithResponse(knowledgeSource, requestOptions, Context.NONE).getValue();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="SearchServiceClientKnowledgeSources")
    public static interface KnowledgeSourcesService {
        @Put(value="/knowledgesources('{sourceName}')")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<KnowledgeSource>> createOrUpdate(@HostParam(value="endpoint") String var1, @PathParam(value="sourceName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @HeaderParam(value="Prefer") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") KnowledgeSource var9, Context var10);

        @Put(value="/knowledgesources('{sourceName}')")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<KnowledgeSource> createOrUpdateSync(@HostParam(value="endpoint") String var1, @PathParam(value="sourceName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @HeaderParam(value="Prefer") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") KnowledgeSource var9, Context var10);

        @Delete(value="/knowledgesources('{sourceName}')")
        @ExpectedResponses(value={204, 404})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> delete(@HostParam(value="endpoint") String var1, @PathParam(value="sourceName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Delete(value="/knowledgesources('{sourceName}')")
        @ExpectedResponses(value={204, 404})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<Void> deleteSync(@HostParam(value="endpoint") String var1, @PathParam(value="sourceName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/knowledgesources('{sourceName}')")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<KnowledgeSource>> get(@HostParam(value="endpoint") String var1, @PathParam(value="sourceName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/knowledgesources('{sourceName}')")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<KnowledgeSource> getSync(@HostParam(value="endpoint") String var1, @PathParam(value="sourceName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/knowledgesources")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<ListKnowledgeSourcesResult>> list(@HostParam(value="endpoint") String var1, @HeaderParam(value="x-ms-client-request-id") UUID var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/knowledgesources")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<ListKnowledgeSourcesResult> listSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="x-ms-client-request-id") UUID var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/knowledgesources")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<KnowledgeSource>> create(@HostParam(value="endpoint") String var1, @HeaderParam(value="x-ms-client-request-id") UUID var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") KnowledgeSource var5, Context var6);

        @Post(value="/knowledgesources")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<KnowledgeSource> createSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="x-ms-client-request-id") UUID var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") KnowledgeSource var5, Context var6);
    }
}

