/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.KnowledgeSource;
import java.io.IOException;
import java.util.List;

public final class ListKnowledgeSourcesResult
implements JsonSerializable<ListKnowledgeSourcesResult> {
    private final List<KnowledgeSource> knowledgeSources;

    public ListKnowledgeSourcesResult(List<KnowledgeSource> knowledgeSources) {
        this.knowledgeSources = knowledgeSources;
    }

    public List<KnowledgeSource> getKnowledgeSources() {
        return this.knowledgeSources;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.knowledgeSources, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ListKnowledgeSourcesResult fromJson(JsonReader jsonReader) throws IOException {
        return (ListKnowledgeSourcesResult)jsonReader.readObject(reader -> {
            boolean knowledgeSourcesFound = false;
            List knowledgeSources = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    knowledgeSources = reader.readArray(reader1 -> KnowledgeSource.fromJson(reader1));
                    knowledgeSourcesFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (knowledgeSourcesFound) {
                return new ListKnowledgeSourcesResult(knowledgeSources);
            }
            throw new IllegalStateException("Missing required property: value");
        });
    }
}

