/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.SplitSkillEncoderModelName;
import java.io.IOException;
import java.util.List;

public final class AzureOpenAITokenizerParameters
implements JsonSerializable<AzureOpenAITokenizerParameters> {
    private SplitSkillEncoderModelName encoderModelName;
    private List<String> allowedSpecialTokens;

    public SplitSkillEncoderModelName getEncoderModelName() {
        return this.encoderModelName;
    }

    public AzureOpenAITokenizerParameters setEncoderModelName(SplitSkillEncoderModelName encoderModelName) {
        this.encoderModelName = encoderModelName;
        return this;
    }

    public List<String> getAllowedSpecialTokens() {
        return this.allowedSpecialTokens;
    }

    public AzureOpenAITokenizerParameters setAllowedSpecialTokens(List<String> allowedSpecialTokens) {
        this.allowedSpecialTokens = allowedSpecialTokens;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("encoderModelName", this.encoderModelName == null ? null : this.encoderModelName.toString());
        jsonWriter.writeArrayField("allowedSpecialTokens", this.allowedSpecialTokens, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static AzureOpenAITokenizerParameters fromJson(JsonReader jsonReader) throws IOException {
        return (AzureOpenAITokenizerParameters)jsonReader.readObject(reader -> {
            AzureOpenAITokenizerParameters deserializedAzureOpenAITokenizerParameters = new AzureOpenAITokenizerParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("encoderModelName".equals(fieldName)) {
                    deserializedAzureOpenAITokenizerParameters.encoderModelName = SplitSkillEncoderModelName.fromString(reader.getString());
                    continue;
                }
                if ("allowedSpecialTokens".equals(fieldName)) {
                    List allowedSpecialTokens;
                    deserializedAzureOpenAITokenizerParameters.allowedSpecialTokens = allowedSpecialTokens = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureOpenAITokenizerParameters;
        });
    }
}

