/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.CharFilterName;
import com.azure.search.documents.indexes.models.LexicalNormalizer;
import com.azure.search.documents.indexes.models.TokenFilterName;
import java.io.IOException;
import java.util.List;

public final class CustomNormalizer
extends LexicalNormalizer {
    private String odataType = "#Microsoft.Azure.Search.CustomNormalizer";
    private List<TokenFilterName> tokenFilters;
    private List<CharFilterName> charFilters;

    public CustomNormalizer(String name) {
        super(name);
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public List<TokenFilterName> getTokenFilters() {
        return this.tokenFilters;
    }

    public CustomNormalizer setTokenFilters(List<TokenFilterName> tokenFilters) {
        this.tokenFilters = tokenFilters;
        return this;
    }

    public List<CharFilterName> getCharFilters() {
        return this.charFilters;
    }

    public CustomNormalizer setCharFilters(List<CharFilterName> charFilters) {
        this.charFilters = charFilters;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeArrayField("tokenFilters", this.tokenFilters, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("charFilters", this.charFilters, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static CustomNormalizer fromJson(JsonReader jsonReader) throws IOException {
        return (CustomNormalizer)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = "#Microsoft.Azure.Search.CustomNormalizer";
            List tokenFilters = null;
            List charFilters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                if ("tokenFilters".equals(fieldName)) {
                    tokenFilters = reader.readArray(reader1 -> TokenFilterName.fromString(reader1.getString()));
                    continue;
                }
                if ("charFilters".equals(fieldName)) {
                    charFilters = reader.readArray(reader1 -> CharFilterName.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                CustomNormalizer deserializedCustomNormalizer = new CustomNormalizer(name);
                deserializedCustomNormalizer.odataType = odataType;
                deserializedCustomNormalizer.tokenFilters = tokenFilters;
                deserializedCustomNormalizer.charFilters = charFilters;
                return deserializedCustomNormalizer;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

