/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.AzureOpenAIVectorizerParameters;
import com.azure.search.documents.indexes.models.KnowledgeAgentModel;
import com.azure.search.documents.indexes.models.KnowledgeAgentModelKind;
import java.io.IOException;

public final class KnowledgeAgentAzureOpenAIModel
extends KnowledgeAgentModel {
    private KnowledgeAgentModelKind kind = KnowledgeAgentModelKind.AZURE_OPEN_AI;
    private final AzureOpenAIVectorizerParameters azureOpenAIParameters;

    public KnowledgeAgentAzureOpenAIModel(AzureOpenAIVectorizerParameters azureOpenAIParameters) {
        this.azureOpenAIParameters = azureOpenAIParameters;
    }

    @Override
    public KnowledgeAgentModelKind getKind() {
        return this.kind;
    }

    public AzureOpenAIVectorizerParameters getAzureOpenAIParameters() {
        return this.azureOpenAIParameters;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("azureOpenAIParameters", (JsonSerializable)this.azureOpenAIParameters);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    public static KnowledgeAgentAzureOpenAIModel fromJson(JsonReader jsonReader) throws IOException {
        return (KnowledgeAgentAzureOpenAIModel)jsonReader.readObject(reader -> {
            boolean azureOpenAIParametersFound = false;
            AzureOpenAIVectorizerParameters azureOpenAIParameters = null;
            KnowledgeAgentModelKind kind = KnowledgeAgentModelKind.AZURE_OPEN_AI;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("azureOpenAIParameters".equals(fieldName)) {
                    azureOpenAIParameters = AzureOpenAIVectorizerParameters.fromJson(reader);
                    azureOpenAIParametersFound = true;
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    kind = KnowledgeAgentModelKind.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (azureOpenAIParametersFound) {
                KnowledgeAgentAzureOpenAIModel deserializedKnowledgeAgentAzureOpenAIModel = new KnowledgeAgentAzureOpenAIModel(azureOpenAIParameters);
                deserializedKnowledgeAgentAzureOpenAIModel.kind = kind;
                return deserializedKnowledgeAgentAzureOpenAIModel;
            }
            throw new IllegalStateException("Missing required property: azureOpenAIParameters");
        });
    }
}

