/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.AzureBlobKnowledgeSource;
import com.azure.search.documents.indexes.models.KnowledgeSourceKind;
import com.azure.search.documents.indexes.models.SearchIndexKnowledgeSource;
import com.azure.search.documents.indexes.models.SearchResourceEncryptionKey;
import java.io.IOException;

public class KnowledgeSource
implements JsonSerializable<KnowledgeSource> {
    private KnowledgeSourceKind kind = KnowledgeSourceKind.fromString("KnowledgeSource");
    private final String name;
    private String description;
    private String eTag;
    private SearchResourceEncryptionKey encryptionKey;

    public KnowledgeSource(String name) {
        this.name = name;
    }

    public KnowledgeSourceKind getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public KnowledgeSource setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public KnowledgeSource setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public SearchResourceEncryptionKey getEncryptionKey() {
        return this.encryptionKey;
    }

    public KnowledgeSource setEncryptionKey(SearchResourceEncryptionKey encryptionKey) {
        this.encryptionKey = encryptionKey;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("@odata.etag", this.eTag);
        jsonWriter.writeJsonField("encryptionKey", (JsonSerializable)this.encryptionKey);
        return jsonWriter.writeEndObject();
    }

    public static KnowledgeSource fromJson(JsonReader jsonReader) throws IOException {
        return (KnowledgeSource)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                KnowledgeSource knowledgeSource;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("searchIndex".equals(discriminatorValue)) {
                    knowledgeSource = SearchIndexKnowledgeSource.fromJson(readerToUse.reset());
                    return knowledgeSource;
                }
                if ("azureBlob".equals(discriminatorValue)) {
                    knowledgeSource = AzureBlobKnowledgeSource.fromJson(readerToUse.reset());
                    return knowledgeSource;
                }
                knowledgeSource = KnowledgeSource.fromJsonKnownDiscriminator(readerToUse.reset());
                return knowledgeSource;
            }
        });
    }

    static KnowledgeSource fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (KnowledgeSource)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            KnowledgeSourceKind kind = null;
            String description = null;
            String eTag = null;
            SearchResourceEncryptionKey encryptionKey = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    kind = KnowledgeSourceKind.fromString(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("@odata.etag".equals(fieldName)) {
                    eTag = reader.getString();
                    continue;
                }
                if ("encryptionKey".equals(fieldName)) {
                    encryptionKey = SearchResourceEncryptionKey.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                KnowledgeSource deserializedKnowledgeSource = new KnowledgeSource(name);
                deserializedKnowledgeSource.kind = kind;
                deserializedKnowledgeSource.description = description;
                deserializedKnowledgeSource.eTag = eTag;
                deserializedKnowledgeSource.encryptionKey = encryptionKey;
                return deserializedKnowledgeSource;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

