/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class SearchIndexKnowledgeSourceParameters
implements JsonSerializable<SearchIndexKnowledgeSourceParameters> {
    private final String searchIndexName;
    private String sourceDataSelect;

    public SearchIndexKnowledgeSourceParameters(String searchIndexName) {
        this.searchIndexName = searchIndexName;
    }

    public String getSearchIndexName() {
        return this.searchIndexName;
    }

    public String getSourceDataSelect() {
        return this.sourceDataSelect;
    }

    public SearchIndexKnowledgeSourceParameters setSourceDataSelect(String sourceDataSelect) {
        this.sourceDataSelect = sourceDataSelect;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("searchIndexName", this.searchIndexName);
        jsonWriter.writeStringField("sourceDataSelect", this.sourceDataSelect);
        return jsonWriter.writeEndObject();
    }

    public static SearchIndexKnowledgeSourceParameters fromJson(JsonReader jsonReader) throws IOException {
        return (SearchIndexKnowledgeSourceParameters)jsonReader.readObject(reader -> {
            boolean searchIndexNameFound = false;
            String searchIndexName = null;
            String sourceDataSelect = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("searchIndexName".equals(fieldName)) {
                    searchIndexName = reader.getString();
                    searchIndexNameFound = true;
                    continue;
                }
                if ("sourceDataSelect".equals(fieldName)) {
                    sourceDataSelect = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (searchIndexNameFound) {
                SearchIndexKnowledgeSourceParameters deserializedSearchIndexKnowledgeSourceParameters = new SearchIndexKnowledgeSourceParameters(searchIndexName);
                deserializedSearchIndexKnowledgeSourceParameters.sourceDataSelect = sourceDataSelect;
                return deserializedSearchIndexKnowledgeSourceParameters;
            }
            throw new IllegalStateException("Missing required property: searchIndexName");
        });
    }
}

