/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.ChatCompletionSkill;
import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import com.azure.search.documents.indexes.models.OutputFieldMappingEntry;
import com.azure.search.documents.indexes.models.SearchIndexerDataIdentity;
import com.azure.search.documents.indexes.models.SearchIndexerSkill;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WebApiSkill
extends SearchIndexerSkill {
    private String odataType = "#Microsoft.Skills.Custom.WebApiSkill";
    private final String uri;
    private Map<String, String> httpHeaders;
    private String httpMethod;
    private Duration timeout;
    private Integer batchSize;
    private Integer degreeOfParallelism;
    private String authResourceId;
    private SearchIndexerDataIdentity authIdentity;

    public WebApiSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs, String uri) {
        super(inputs, outputs);
        this.uri = uri;
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public String getUri() {
        return this.uri;
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public WebApiSkill setHttpHeaders(Map<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
        return this;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public WebApiSkill setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public WebApiSkill setTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public WebApiSkill setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public Integer getDegreeOfParallelism() {
        return this.degreeOfParallelism;
    }

    public WebApiSkill setDegreeOfParallelism(Integer degreeOfParallelism) {
        this.degreeOfParallelism = degreeOfParallelism;
        return this;
    }

    public String getAuthResourceId() {
        return this.authResourceId;
    }

    public WebApiSkill setAuthResourceId(String authResourceId) {
        this.authResourceId = authResourceId;
        return this;
    }

    public SearchIndexerDataIdentity getAuthIdentity() {
        return this.authIdentity;
    }

    public WebApiSkill setAuthIdentity(SearchIndexerDataIdentity authIdentity) {
        this.authIdentity = authIdentity;
        return this;
    }

    @Override
    public WebApiSkill setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public WebApiSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public WebApiSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("inputs", this.getInputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outputs", this.getOutputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("context", this.getContext());
        jsonWriter.writeStringField("uri", this.uri);
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeMapField("httpHeaders", this.httpHeaders, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("httpMethod", this.httpMethod);
        jsonWriter.writeStringField("timeout", CoreUtils.durationToStringWithDays((Duration)this.timeout));
        jsonWriter.writeNumberField("batchSize", (Number)this.batchSize);
        jsonWriter.writeNumberField("degreeOfParallelism", (Number)this.degreeOfParallelism);
        jsonWriter.writeStringField("authResourceId", this.authResourceId);
        jsonWriter.writeJsonField("authIdentity", (JsonSerializable)this.authIdentity);
        return jsonWriter.writeEndObject();
    }

    public static WebApiSkill fromJson(JsonReader jsonReader) throws IOException {
        return (WebApiSkill)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                WebApiSkill webApiSkill;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("@odata.type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("#Microsoft.Skills.Custom.ChatCompletionSkill".equals(discriminatorValue)) {
                    webApiSkill = ChatCompletionSkill.fromJson(readerToUse.reset());
                    return webApiSkill;
                }
                webApiSkill = WebApiSkill.fromJsonKnownDiscriminator(readerToUse.reset());
                return webApiSkill;
            }
        });
    }

    static WebApiSkill fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (WebApiSkill)jsonReader.readObject(reader -> {
            boolean inputsFound = false;
            List inputs = null;
            boolean outputsFound = false;
            List outputs = null;
            String name = null;
            String description = null;
            String context = null;
            boolean uriFound = false;
            String uri = null;
            String odataType = "#Microsoft.Skills.Custom.WebApiSkill";
            Map httpHeaders = null;
            String httpMethod = null;
            Duration timeout = null;
            Integer batchSize = null;
            Integer degreeOfParallelism = null;
            String authResourceId = null;
            SearchIndexerDataIdentity authIdentity = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    inputsFound = true;
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    outputs = reader.readArray(reader1 -> OutputFieldMappingEntry.fromJson(reader1));
                    outputsFound = true;
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("context".equals(fieldName)) {
                    context = reader.getString();
                    continue;
                }
                if ("uri".equals(fieldName)) {
                    uri = reader.getString();
                    uriFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                if ("httpHeaders".equals(fieldName)) {
                    httpHeaders = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("httpMethod".equals(fieldName)) {
                    httpMethod = reader.getString();
                    continue;
                }
                if ("timeout".equals(fieldName)) {
                    timeout = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("batchSize".equals(fieldName)) {
                    batchSize = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("degreeOfParallelism".equals(fieldName)) {
                    degreeOfParallelism = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("authResourceId".equals(fieldName)) {
                    authResourceId = reader.getString();
                    continue;
                }
                if ("authIdentity".equals(fieldName)) {
                    authIdentity = SearchIndexerDataIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (inputsFound && outputsFound && uriFound) {
                WebApiSkill deserializedWebApiSkill = new WebApiSkill(inputs, outputs, uri);
                deserializedWebApiSkill.setName(name);
                deserializedWebApiSkill.setDescription(description);
                deserializedWebApiSkill.setContext(context);
                deserializedWebApiSkill.odataType = odataType;
                deserializedWebApiSkill.httpHeaders = httpHeaders;
                deserializedWebApiSkill.httpMethod = httpMethod;
                deserializedWebApiSkill.timeout = timeout;
                deserializedWebApiSkill.batchSize = batchSize;
                deserializedWebApiSkill.degreeOfParallelism = degreeOfParallelism;
                deserializedWebApiSkill.authResourceId = authResourceId;
                deserializedWebApiSkill.authIdentity = authIdentity;
                return deserializedWebApiSkill;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!inputsFound) {
                missingProperties.add("inputs");
            }
            if (!outputsFound) {
                missingProperties.add("outputs");
            }
            if (!uriFound) {
                missingProperties.add("uri");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

