/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.models.QueryResultDocumentInnerHit;
import com.azure.search.documents.models.SemanticDebugInfo;
import com.azure.search.documents.models.VectorsDebugInfo;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class DocumentDebugInfo
implements JsonSerializable<DocumentDebugInfo> {
    private SemanticDebugInfo semantic;
    private VectorsDebugInfo vectors;
    private Map<String, List<QueryResultDocumentInnerHit>> innerHits;

    public SemanticDebugInfo getSemantic() {
        return this.semantic;
    }

    public VectorsDebugInfo getVectors() {
        return this.vectors;
    }

    public Map<String, List<QueryResultDocumentInnerHit>> getInnerHits() {
        return this.innerHits;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static DocumentDebugInfo fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentDebugInfo)jsonReader.readObject(reader -> {
            DocumentDebugInfo deserializedDocumentDebugInfo = new DocumentDebugInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("semantic".equals(fieldName)) {
                    deserializedDocumentDebugInfo.semantic = SemanticDebugInfo.fromJson(reader);
                    continue;
                }
                if ("vectors".equals(fieldName)) {
                    deserializedDocumentDebugInfo.vectors = VectorsDebugInfo.fromJson(reader);
                    continue;
                }
                if ("innerHits".equals(fieldName)) {
                    Map innerHits;
                    deserializedDocumentDebugInfo.innerHits = innerHits = reader.readMap(reader1 -> reader1.readArray(reader2 -> QueryResultDocumentInnerHit.fromJson(reader2)));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDocumentDebugInfo;
        });
    }
}

