/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.models.VectorQuery;
import com.azure.search.documents.models.VectorQueryKind;
import com.azure.search.documents.models.VectorThreshold;
import java.io.IOException;

public final class VectorizableImageUrlQuery
extends VectorQuery {
    private VectorQueryKind kind = VectorQueryKind.IMAGE_URL;
    private String url;

    @Override
    public VectorQueryKind getKind() {
        return this.kind;
    }

    public String getUrl() {
        return this.url;
    }

    public VectorizableImageUrlQuery setUrl(String url) {
        this.url = url;
        return this;
    }

    @Override
    public VectorizableImageUrlQuery setKNearestNeighborsCount(Integer kNearestNeighborsCount) {
        super.setKNearestNeighborsCount(kNearestNeighborsCount);
        return this;
    }

    @Override
    public VectorizableImageUrlQuery setFields(String ... fields) {
        super.setFields(fields);
        return this;
    }

    @Override
    public VectorizableImageUrlQuery setExhaustive(Boolean exhaustive) {
        super.setExhaustive(exhaustive);
        return this;
    }

    @Override
    public VectorizableImageUrlQuery setOversampling(Double oversampling) {
        super.setOversampling(oversampling);
        return this;
    }

    @Override
    public VectorizableImageUrlQuery setWeight(Float weight) {
        super.setWeight(weight);
        return this;
    }

    @Override
    public VectorizableImageUrlQuery setThreshold(VectorThreshold threshold) {
        super.setThreshold(threshold);
        return this;
    }

    @Override
    public VectorizableImageUrlQuery setFilterOverride(String filterOverride) {
        super.setFilterOverride(filterOverride);
        return this;
    }

    @Override
    public VectorizableImageUrlQuery setPerDocumentVectorLimit(Integer perDocumentVectorLimit) {
        super.setPerDocumentVectorLimit(perDocumentVectorLimit);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("k", (Number)this.getKNearestNeighborsCount());
        jsonWriter.writeStringField("fields", this.getFields());
        jsonWriter.writeBooleanField("exhaustive", this.isExhaustive());
        jsonWriter.writeNumberField("oversampling", (Number)this.getOversampling());
        jsonWriter.writeNumberField("weight", (Number)this.getWeight());
        jsonWriter.writeJsonField("threshold", (JsonSerializable)this.getThreshold());
        jsonWriter.writeStringField("filterOverride", this.getFilterOverride());
        jsonWriter.writeNumberField("perDocumentVectorLimit", (Number)this.getPerDocumentVectorLimit());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeStringField("url", this.url);
        return jsonWriter.writeEndObject();
    }

    public static VectorizableImageUrlQuery fromJson(JsonReader jsonReader) throws IOException {
        return (VectorizableImageUrlQuery)jsonReader.readObject(reader -> {
            VectorizableImageUrlQuery deserializedVectorizableImageUrlQuery = new VectorizableImageUrlQuery();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("k".equals(fieldName)) {
                    deserializedVectorizableImageUrlQuery.setKNearestNeighborsCount((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("fields".equals(fieldName)) {
                    deserializedVectorizableImageUrlQuery.setFields(reader.getString());
                    continue;
                }
                if ("exhaustive".equals(fieldName)) {
                    deserializedVectorizableImageUrlQuery.setExhaustive((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("oversampling".equals(fieldName)) {
                    deserializedVectorizableImageUrlQuery.setOversampling((Double)reader.getNullable(JsonReader::getDouble));
                    continue;
                }
                if ("weight".equals(fieldName)) {
                    deserializedVectorizableImageUrlQuery.setWeight((Float)reader.getNullable(JsonReader::getFloat));
                    continue;
                }
                if ("threshold".equals(fieldName)) {
                    deserializedVectorizableImageUrlQuery.setThreshold(VectorThreshold.fromJson(reader));
                    continue;
                }
                if ("filterOverride".equals(fieldName)) {
                    deserializedVectorizableImageUrlQuery.setFilterOverride(reader.getString());
                    continue;
                }
                if ("perDocumentVectorLimit".equals(fieldName)) {
                    deserializedVectorizableImageUrlQuery.setPerDocumentVectorLimit((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedVectorizableImageUrlQuery.kind = VectorQueryKind.fromString(reader.getString());
                    continue;
                }
                if ("url".equals(fieldName)) {
                    deserializedVectorizableImageUrlQuery.url = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVectorizableImageUrlQuery;
        });
    }
}

