/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.models.QueryDebugMode;
import com.azure.search.documents.models.QueryType;
import com.azure.search.documents.models.ScoringStatistics;
import com.azure.search.documents.models.SearchMode;
import com.azure.search.documents.models.SemanticErrorMode;
import com.azure.search.documents.models.VectorFilterMode;
import com.azure.search.documents.models.VectorQuery;
import java.io.IOException;
import java.util.List;

public final class SearchRequest
implements JsonSerializable<SearchRequest> {
    private Boolean includeTotalResultCount;
    private List<String> facets;
    private String filter;
    private String highlightFields;
    private String highlightPostTag;
    private String highlightPreTag;
    private Double minimumCoverage;
    private String orderBy;
    private QueryType queryType;
    private ScoringStatistics scoringStatistics;
    private String sessionId;
    private List<String> scoringParameters;
    private String scoringProfile;
    private QueryDebugMode debug;
    private String searchText;
    private String searchFields;
    private SearchMode searchMode;
    private String select;
    private Integer skip;
    private Integer top;
    private String semanticConfiguration;
    private SemanticErrorMode semanticErrorHandling;
    private Integer semanticMaxWaitInMilliseconds;
    private String semanticQuery;
    private String answers;
    private String captions;
    private List<VectorQuery> vectorQueries;
    private VectorFilterMode vectorFilterMode;

    public Boolean isIncludeTotalResultCount() {
        return this.includeTotalResultCount;
    }

    public SearchRequest setIncludeTotalResultCount(Boolean includeTotalResultCount) {
        this.includeTotalResultCount = includeTotalResultCount;
        return this;
    }

    public List<String> getFacets() {
        return this.facets;
    }

    public SearchRequest setFacets(List<String> facets) {
        this.facets = facets;
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public SearchRequest setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public String getHighlightFields() {
        return this.highlightFields;
    }

    public SearchRequest setHighlightFields(String highlightFields) {
        this.highlightFields = highlightFields;
        return this;
    }

    public String getHighlightPostTag() {
        return this.highlightPostTag;
    }

    public SearchRequest setHighlightPostTag(String highlightPostTag) {
        this.highlightPostTag = highlightPostTag;
        return this;
    }

    public String getHighlightPreTag() {
        return this.highlightPreTag;
    }

    public SearchRequest setHighlightPreTag(String highlightPreTag) {
        this.highlightPreTag = highlightPreTag;
        return this;
    }

    public Double getMinimumCoverage() {
        return this.minimumCoverage;
    }

    public SearchRequest setMinimumCoverage(Double minimumCoverage) {
        this.minimumCoverage = minimumCoverage;
        return this;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public SearchRequest setOrderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    public SearchRequest setQueryType(QueryType queryType) {
        this.queryType = queryType;
        return this;
    }

    public ScoringStatistics getScoringStatistics() {
        return this.scoringStatistics;
    }

    public SearchRequest setScoringStatistics(ScoringStatistics scoringStatistics) {
        this.scoringStatistics = scoringStatistics;
        return this;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public SearchRequest setSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public List<String> getScoringParameters() {
        return this.scoringParameters;
    }

    public SearchRequest setScoringParameters(List<String> scoringParameters) {
        this.scoringParameters = scoringParameters;
        return this;
    }

    public String getScoringProfile() {
        return this.scoringProfile;
    }

    public SearchRequest setScoringProfile(String scoringProfile) {
        this.scoringProfile = scoringProfile;
        return this;
    }

    public QueryDebugMode getDebug() {
        return this.debug;
    }

    public SearchRequest setDebug(QueryDebugMode debug) {
        this.debug = debug;
        return this;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public SearchRequest setSearchText(String searchText) {
        this.searchText = searchText;
        return this;
    }

    public String getSearchFields() {
        return this.searchFields;
    }

    public SearchRequest setSearchFields(String searchFields) {
        this.searchFields = searchFields;
        return this;
    }

    public SearchMode getSearchMode() {
        return this.searchMode;
    }

    public SearchRequest setSearchMode(SearchMode searchMode) {
        this.searchMode = searchMode;
        return this;
    }

    public String getSelect() {
        return this.select;
    }

    public SearchRequest setSelect(String select) {
        this.select = select;
        return this;
    }

    public Integer getSkip() {
        return this.skip;
    }

    public SearchRequest setSkip(Integer skip) {
        this.skip = skip;
        return this;
    }

    public Integer getTop() {
        return this.top;
    }

    public SearchRequest setTop(Integer top) {
        this.top = top;
        return this;
    }

    public String getSemanticConfiguration() {
        return this.semanticConfiguration;
    }

    public SearchRequest setSemanticConfiguration(String semanticConfiguration) {
        this.semanticConfiguration = semanticConfiguration;
        return this;
    }

    public SemanticErrorMode getSemanticErrorHandling() {
        return this.semanticErrorHandling;
    }

    public SearchRequest setSemanticErrorHandling(SemanticErrorMode semanticErrorHandling) {
        this.semanticErrorHandling = semanticErrorHandling;
        return this;
    }

    public Integer getSemanticMaxWaitInMilliseconds() {
        return this.semanticMaxWaitInMilliseconds;
    }

    public SearchRequest setSemanticMaxWaitInMilliseconds(Integer semanticMaxWaitInMilliseconds) {
        this.semanticMaxWaitInMilliseconds = semanticMaxWaitInMilliseconds;
        return this;
    }

    public String getSemanticQuery() {
        return this.semanticQuery;
    }

    public SearchRequest setSemanticQuery(String semanticQuery) {
        this.semanticQuery = semanticQuery;
        return this;
    }

    public String getAnswers() {
        return this.answers;
    }

    public SearchRequest setAnswers(String answers) {
        this.answers = answers;
        return this;
    }

    public String getCaptions() {
        return this.captions;
    }

    public SearchRequest setCaptions(String captions) {
        this.captions = captions;
        return this;
    }

    public List<VectorQuery> getVectorQueries() {
        return this.vectorQueries;
    }

    public SearchRequest setVectorQueries(List<VectorQuery> vectorQueries) {
        this.vectorQueries = vectorQueries;
        return this;
    }

    public VectorFilterMode getVectorFilterMode() {
        return this.vectorFilterMode;
    }

    public SearchRequest setVectorFilterMode(VectorFilterMode vectorFilterMode) {
        this.vectorFilterMode = vectorFilterMode;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("count", this.includeTotalResultCount);
        jsonWriter.writeArrayField("facets", this.facets, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("filter", this.filter);
        jsonWriter.writeStringField("highlight", this.highlightFields);
        jsonWriter.writeStringField("highlightPostTag", this.highlightPostTag);
        jsonWriter.writeStringField("highlightPreTag", this.highlightPreTag);
        jsonWriter.writeNumberField("minimumCoverage", (Number)this.minimumCoverage);
        jsonWriter.writeStringField("orderby", this.orderBy);
        jsonWriter.writeStringField("queryType", this.queryType == null ? null : this.queryType.toString());
        jsonWriter.writeStringField("scoringStatistics", this.scoringStatistics == null ? null : this.scoringStatistics.toString());
        jsonWriter.writeStringField("sessionId", this.sessionId);
        jsonWriter.writeArrayField("scoringParameters", this.scoringParameters, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("scoringProfile", this.scoringProfile);
        jsonWriter.writeStringField("debug", this.debug == null ? null : this.debug.toString());
        jsonWriter.writeStringField("search", this.searchText);
        jsonWriter.writeStringField("searchFields", this.searchFields);
        jsonWriter.writeStringField("searchMode", this.searchMode == null ? null : this.searchMode.toString());
        jsonWriter.writeStringField("select", this.select);
        jsonWriter.writeNumberField("skip", (Number)this.skip);
        jsonWriter.writeNumberField("top", (Number)this.top);
        jsonWriter.writeStringField("semanticConfiguration", this.semanticConfiguration);
        jsonWriter.writeStringField("semanticErrorHandling", this.semanticErrorHandling == null ? null : this.semanticErrorHandling.toString());
        jsonWriter.writeNumberField("semanticMaxWaitInMilliseconds", (Number)this.semanticMaxWaitInMilliseconds);
        jsonWriter.writeStringField("semanticQuery", this.semanticQuery);
        jsonWriter.writeStringField("answers", this.answers);
        jsonWriter.writeStringField("captions", this.captions);
        jsonWriter.writeArrayField("vectorQueries", this.vectorQueries, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("vectorFilterMode", this.vectorFilterMode == null ? null : this.vectorFilterMode.toString());
        return jsonWriter.writeEndObject();
    }

    public static SearchRequest fromJson(JsonReader jsonReader) throws IOException {
        return (SearchRequest)jsonReader.readObject(reader -> {
            SearchRequest deserializedSearchRequest = new SearchRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("count".equals(fieldName)) {
                    deserializedSearchRequest.includeTotalResultCount = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("facets".equals(fieldName)) {
                    List facets;
                    deserializedSearchRequest.facets = facets = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("filter".equals(fieldName)) {
                    deserializedSearchRequest.filter = reader.getString();
                    continue;
                }
                if ("highlight".equals(fieldName)) {
                    deserializedSearchRequest.highlightFields = reader.getString();
                    continue;
                }
                if ("highlightPostTag".equals(fieldName)) {
                    deserializedSearchRequest.highlightPostTag = reader.getString();
                    continue;
                }
                if ("highlightPreTag".equals(fieldName)) {
                    deserializedSearchRequest.highlightPreTag = reader.getString();
                    continue;
                }
                if ("minimumCoverage".equals(fieldName)) {
                    deserializedSearchRequest.minimumCoverage = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("orderby".equals(fieldName)) {
                    deserializedSearchRequest.orderBy = reader.getString();
                    continue;
                }
                if ("queryType".equals(fieldName)) {
                    deserializedSearchRequest.queryType = QueryType.fromString(reader.getString());
                    continue;
                }
                if ("scoringStatistics".equals(fieldName)) {
                    deserializedSearchRequest.scoringStatistics = ScoringStatistics.fromString(reader.getString());
                    continue;
                }
                if ("sessionId".equals(fieldName)) {
                    deserializedSearchRequest.sessionId = reader.getString();
                    continue;
                }
                if ("scoringParameters".equals(fieldName)) {
                    List scoringParameters;
                    deserializedSearchRequest.scoringParameters = scoringParameters = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("scoringProfile".equals(fieldName)) {
                    deserializedSearchRequest.scoringProfile = reader.getString();
                    continue;
                }
                if ("debug".equals(fieldName)) {
                    deserializedSearchRequest.debug = QueryDebugMode.fromString(reader.getString());
                    continue;
                }
                if ("search".equals(fieldName)) {
                    deserializedSearchRequest.searchText = reader.getString();
                    continue;
                }
                if ("searchFields".equals(fieldName)) {
                    deserializedSearchRequest.searchFields = reader.getString();
                    continue;
                }
                if ("searchMode".equals(fieldName)) {
                    deserializedSearchRequest.searchMode = SearchMode.fromString(reader.getString());
                    continue;
                }
                if ("select".equals(fieldName)) {
                    deserializedSearchRequest.select = reader.getString();
                    continue;
                }
                if ("skip".equals(fieldName)) {
                    deserializedSearchRequest.skip = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("top".equals(fieldName)) {
                    deserializedSearchRequest.top = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("semanticConfiguration".equals(fieldName)) {
                    deserializedSearchRequest.semanticConfiguration = reader.getString();
                    continue;
                }
                if ("semanticErrorHandling".equals(fieldName)) {
                    deserializedSearchRequest.semanticErrorHandling = SemanticErrorMode.fromString(reader.getString());
                    continue;
                }
                if ("semanticMaxWaitInMilliseconds".equals(fieldName)) {
                    deserializedSearchRequest.semanticMaxWaitInMilliseconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("semanticQuery".equals(fieldName)) {
                    deserializedSearchRequest.semanticQuery = reader.getString();
                    continue;
                }
                if ("answers".equals(fieldName)) {
                    deserializedSearchRequest.answers = reader.getString();
                    continue;
                }
                if ("captions".equals(fieldName)) {
                    deserializedSearchRequest.captions = reader.getString();
                    continue;
                }
                if ("vectorQueries".equals(fieldName)) {
                    List vectorQueries;
                    deserializedSearchRequest.vectorQueries = vectorQueries = reader.readArray(reader1 -> VectorQuery.fromJson(reader1));
                    continue;
                }
                if ("vectorFilterMode".equals(fieldName)) {
                    deserializedSearchRequest.vectorFilterMode = VectorFilterMode.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSearchRequest;
        });
    }
}

