/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.search.documents.indexes.implementation.SearchServiceClientImpl;
import com.azure.search.documents.indexes.implementation.models.ErrorResponseException;
import com.azure.search.documents.indexes.implementation.models.ListSkillsetsResult;
import com.azure.search.documents.indexes.implementation.models.RequestOptions;
import com.azure.search.documents.indexes.models.SearchIndexerSkillset;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class SkillsetsImpl {
    private final SkillsetsService service;
    private final SearchServiceClientImpl client;

    SkillsetsImpl(SearchServiceClientImpl client) {
        this.service = (SkillsetsService)RestProxy.create(SkillsetsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexerSkillset>> createOrUpdateWithResponseAsync(String skillsetName, SearchIndexerSkillset skillset, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.createOrUpdateWithResponseAsync(skillsetName, skillset, ifMatch, ifNoneMatch, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexerSkillset>> createOrUpdateWithResponseAsync(String skillsetName, SearchIndexerSkillset skillset, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        String prefer = "return=representation";
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.createOrUpdate(this.client.getEndpoint(), skillsetName, xMsClientRequestId, ifMatch, ifNoneMatch, "return=representation", this.client.getApiVersion(), "application/json; odata.metadata=minimal", skillset, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndexerSkillset> createOrUpdateAsync(String skillsetName, SearchIndexerSkillset skillset, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return this.createOrUpdateWithResponseAsync(skillsetName, skillset, ifMatch, ifNoneMatch, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((SearchIndexerSkillset)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndexerSkillset> createOrUpdateAsync(String skillsetName, SearchIndexerSkillset skillset, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        return this.createOrUpdateWithResponseAsync(skillsetName, skillset, ifMatch, ifNoneMatch, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((SearchIndexerSkillset)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexerSkillset> createOrUpdateWithResponse(String skillsetName, SearchIndexerSkillset skillset, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        String prefer = "return=representation";
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.createOrUpdateSync(this.client.getEndpoint(), skillsetName, xMsClientRequestId, ifMatch, ifNoneMatch, "return=representation", this.client.getApiVersion(), "application/json; odata.metadata=minimal", skillset, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexerSkillset createOrUpdate(String skillsetName, SearchIndexerSkillset skillset, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return (SearchIndexerSkillset)this.createOrUpdateWithResponse(skillsetName, skillset, ifMatch, ifNoneMatch, requestOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String skillsetName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.deleteWithResponseAsync(skillsetName, ifMatch, ifNoneMatch, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String skillsetName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.delete(this.client.getEndpoint(), skillsetName, xMsClientRequestId, ifMatch, ifNoneMatch, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String skillsetName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return this.deleteWithResponseAsync(skillsetName, ifMatch, ifNoneMatch, requestOptions).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String skillsetName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        return this.deleteWithResponseAsync(skillsetName, ifMatch, ifNoneMatch, requestOptions, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String skillsetName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.deleteSync(this.client.getEndpoint(), skillsetName, xMsClientRequestId, ifMatch, ifNoneMatch, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String skillsetName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        this.deleteWithResponse(skillsetName, ifMatch, ifNoneMatch, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexerSkillset>> getWithResponseAsync(String skillsetName, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.getWithResponseAsync(skillsetName, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexerSkillset>> getWithResponseAsync(String skillsetName, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.get(this.client.getEndpoint(), skillsetName, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndexerSkillset> getAsync(String skillsetName, RequestOptions requestOptions) {
        return this.getWithResponseAsync(skillsetName, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((SearchIndexerSkillset)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndexerSkillset> getAsync(String skillsetName, RequestOptions requestOptions, Context context) {
        return this.getWithResponseAsync(skillsetName, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((SearchIndexerSkillset)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexerSkillset> getWithResponse(String skillsetName, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.getSync(this.client.getEndpoint(), skillsetName, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexerSkillset get(String skillsetName, RequestOptions requestOptions) {
        return (SearchIndexerSkillset)this.getWithResponse(skillsetName, requestOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ListSkillsetsResult>> listWithResponseAsync(String select, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.listWithResponseAsync(select, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ListSkillsetsResult>> listWithResponseAsync(String select, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.list(this.client.getEndpoint(), select, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ListSkillsetsResult> listAsync(String select, RequestOptions requestOptions) {
        return this.listWithResponseAsync(select, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((ListSkillsetsResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ListSkillsetsResult> listAsync(String select, RequestOptions requestOptions, Context context) {
        return this.listWithResponseAsync(select, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((ListSkillsetsResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ListSkillsetsResult> listWithResponse(String select, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.listSync(this.client.getEndpoint(), select, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ListSkillsetsResult list(String select, RequestOptions requestOptions) {
        return (ListSkillsetsResult)this.listWithResponse(select, requestOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexerSkillset>> createWithResponseAsync(SearchIndexerSkillset skillset, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.createWithResponseAsync(skillset, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexerSkillset>> createWithResponseAsync(SearchIndexerSkillset skillset, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.create(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", skillset, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndexerSkillset> createAsync(SearchIndexerSkillset skillset, RequestOptions requestOptions) {
        return this.createWithResponseAsync(skillset, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((SearchIndexerSkillset)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndexerSkillset> createAsync(SearchIndexerSkillset skillset, RequestOptions requestOptions, Context context) {
        return this.createWithResponseAsync(skillset, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((SearchIndexerSkillset)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexerSkillset> createWithResponse(SearchIndexerSkillset skillset, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.createSync(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", skillset, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexerSkillset create(SearchIndexerSkillset skillset, RequestOptions requestOptions) {
        return (SearchIndexerSkillset)this.createWithResponse(skillset, requestOptions, Context.NONE).getValue();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="SearchServiceClientSkillsets")
    public static interface SkillsetsService {
        @Put(value="/skillsets('{skillsetName}')")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<SearchIndexerSkillset>> createOrUpdate(@HostParam(value="endpoint") String var1, @PathParam(value="skillsetName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @HeaderParam(value="Prefer") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") SearchIndexerSkillset var9, Context var10);

        @Put(value="/skillsets('{skillsetName}')")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<SearchIndexerSkillset> createOrUpdateSync(@HostParam(value="endpoint") String var1, @PathParam(value="skillsetName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @HeaderParam(value="Prefer") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") SearchIndexerSkillset var9, Context var10);

        @Delete(value="/skillsets('{skillsetName}')")
        @ExpectedResponses(value={204, 404})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> delete(@HostParam(value="endpoint") String var1, @PathParam(value="skillsetName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Delete(value="/skillsets('{skillsetName}')")
        @ExpectedResponses(value={204, 404})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<Void> deleteSync(@HostParam(value="endpoint") String var1, @PathParam(value="skillsetName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/skillsets('{skillsetName}')")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<SearchIndexerSkillset>> get(@HostParam(value="endpoint") String var1, @PathParam(value="skillsetName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/skillsets('{skillsetName}')")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<SearchIndexerSkillset> getSync(@HostParam(value="endpoint") String var1, @PathParam(value="skillsetName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/skillsets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<ListSkillsetsResult>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="$select") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/skillsets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<ListSkillsetsResult> listSync(@HostParam(value="endpoint") String var1, @QueryParam(value="$select") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/skillsets")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<SearchIndexerSkillset>> create(@HostParam(value="endpoint") String var1, @HeaderParam(value="x-ms-client-request-id") UUID var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") SearchIndexerSkillset var5, Context var6);

        @Post(value="/skillsets")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<SearchIndexerSkillset> createSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="x-ms-client-request-id") UUID var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") SearchIndexerSkillset var5, Context var6);
    }
}

