/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.LexicalTokenizer;
import java.io.IOException;

public final class KeywordTokenizerV1
extends LexicalTokenizer {
    private String odataType = "#Microsoft.Azure.Search.KeywordTokenizer";
    private Integer bufferSize;

    public KeywordTokenizerV1(String name) {
        super(name);
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public Integer getBufferSize() {
        return this.bufferSize;
    }

    public KeywordTokenizerV1 setBufferSize(Integer bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeNumberField("bufferSize", (Number)this.bufferSize);
        return jsonWriter.writeEndObject();
    }

    public static KeywordTokenizerV1 fromJson(JsonReader jsonReader) throws IOException {
        return (KeywordTokenizerV1)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = "#Microsoft.Azure.Search.KeywordTokenizer";
            Integer bufferSize = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                if ("bufferSize".equals(fieldName)) {
                    bufferSize = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                KeywordTokenizerV1 deserializedKeywordTokenizerV1 = new KeywordTokenizerV1(name);
                deserializedKeywordTokenizerV1.odataType = odataType;
                deserializedKeywordTokenizerV1.bufferSize = bufferSize;
                return deserializedKeywordTokenizerV1;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

