/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.search.documents.indexes.models.CharFilterName;
import com.azure.search.documents.indexes.models.LexicalAnalyzerName;
import com.azure.search.documents.indexes.models.LexicalNormalizerName;
import com.azure.search.documents.indexes.models.LexicalTokenizerName;
import com.azure.search.documents.indexes.models.TokenFilterName;
import java.util.Arrays;
import java.util.List;

public final class AnalyzeTextOptions {
    private final String text;
    private final LexicalAnalyzerName analyzerName;
    private final LexicalTokenizerName tokenizerName;
    private List<TokenFilterName> tokenFilters;
    private List<CharFilterName> charFilters;
    private LexicalNormalizerName normalizerName;

    public AnalyzeTextOptions(String text, LexicalAnalyzerName analyzerName) {
        this.text = text;
        this.analyzerName = analyzerName;
        this.tokenizerName = null;
    }

    public AnalyzeTextOptions(String text, LexicalTokenizerName tokenizerName) {
        this.text = text;
        this.tokenizerName = tokenizerName;
        this.analyzerName = null;
    }

    public String getText() {
        return this.text;
    }

    public LexicalAnalyzerName getAnalyzerName() {
        return this.analyzerName;
    }

    public LexicalTokenizerName getTokenizerName() {
        return this.tokenizerName;
    }

    public List<TokenFilterName> getTokenFilters() {
        return this.tokenFilters;
    }

    public AnalyzeTextOptions setTokenFilters(TokenFilterName ... tokenFilters) {
        this.tokenFilters = tokenFilters == null ? null : Arrays.asList(tokenFilters);
        return this;
    }

    public List<CharFilterName> getCharFilters() {
        return this.charFilters;
    }

    public AnalyzeTextOptions setCharFilters(CharFilterName ... charFilters) {
        this.charFilters = charFilters == null ? null : Arrays.asList(charFilters);
        return this;
    }

    public LexicalNormalizerName getNormalizerName() {
        return this.normalizerName;
    }

    public AnalyzeTextOptions setNormalizerName(LexicalNormalizerName normalizerName) {
        this.normalizerName = normalizerName;
        return this;
    }
}

