/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.SearchIndexerKnowledgeStoreProjection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class SearchIndexerKnowledgeStore
implements JsonSerializable<SearchIndexerKnowledgeStore> {
    private final String storageConnectionString;
    private final List<SearchIndexerKnowledgeStoreProjection> projections;

    public SearchIndexerKnowledgeStore(String storageConnectionString, List<SearchIndexerKnowledgeStoreProjection> projections) {
        this.storageConnectionString = storageConnectionString;
        this.projections = projections;
    }

    public String getStorageConnectionString() {
        return this.storageConnectionString;
    }

    public List<SearchIndexerKnowledgeStoreProjection> getProjections() {
        return this.projections;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageConnectionString", this.storageConnectionString);
        jsonWriter.writeArrayField("projections", this.projections, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SearchIndexerKnowledgeStore fromJson(JsonReader jsonReader) throws IOException {
        return (SearchIndexerKnowledgeStore)jsonReader.readObject(reader -> {
            boolean storageConnectionStringFound = false;
            String storageConnectionString = null;
            boolean projectionsFound = false;
            List projections = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageConnectionString".equals(fieldName)) {
                    storageConnectionString = reader.getString();
                    storageConnectionStringFound = true;
                    continue;
                }
                if ("projections".equals(fieldName)) {
                    projections = reader.readArray(reader1 -> SearchIndexerKnowledgeStoreProjection.fromJson(reader1));
                    projectionsFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (storageConnectionStringFound && projectionsFound) {
                return new SearchIndexerKnowledgeStore(storageConnectionString, projections);
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!storageConnectionStringFound) {
                missingProperties.add("storageConnectionString");
            }
            if (!projectionsFound) {
                missingProperties.add("projections");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

