/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.implementation.models.EntityRecognitionSkillV1;
import com.azure.search.documents.indexes.implementation.models.EntityRecognitionSkillV3;
import com.azure.search.documents.indexes.implementation.models.SentimentSkillV1;
import com.azure.search.documents.indexes.implementation.models.SentimentSkillV3;
import com.azure.search.documents.indexes.models.AzureOpenAIEmbeddingSkill;
import com.azure.search.documents.indexes.models.ConditionalSkill;
import com.azure.search.documents.indexes.models.CustomEntityLookupSkill;
import com.azure.search.documents.indexes.models.DocumentExtractionSkill;
import com.azure.search.documents.indexes.models.DocumentIntelligenceLayoutSkill;
import com.azure.search.documents.indexes.models.EntityLinkingSkill;
import com.azure.search.documents.indexes.models.ImageAnalysisSkill;
import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import com.azure.search.documents.indexes.models.KeyPhraseExtractionSkill;
import com.azure.search.documents.indexes.models.LanguageDetectionSkill;
import com.azure.search.documents.indexes.models.MergeSkill;
import com.azure.search.documents.indexes.models.OcrSkill;
import com.azure.search.documents.indexes.models.OutputFieldMappingEntry;
import com.azure.search.documents.indexes.models.PiiDetectionSkill;
import com.azure.search.documents.indexes.models.ShaperSkill;
import com.azure.search.documents.indexes.models.SplitSkill;
import com.azure.search.documents.indexes.models.TextTranslationSkill;
import com.azure.search.documents.indexes.models.WebApiSkill;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SearchIndexerSkill
implements JsonSerializable<SearchIndexerSkill> {
    private String odataType = "SearchIndexerSkill";
    private String name;
    private String description;
    private String context;
    private final List<InputFieldMappingEntry> inputs;
    private final List<OutputFieldMappingEntry> outputs;

    public SearchIndexerSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs) {
        this.inputs = inputs;
        this.outputs = outputs;
    }

    public String getOdataType() {
        return this.odataType;
    }

    public String getName() {
        return this.name;
    }

    public SearchIndexerSkill setName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public SearchIndexerSkill setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getContext() {
        return this.context;
    }

    public SearchIndexerSkill setContext(String context) {
        this.context = context;
        return this;
    }

    public List<InputFieldMappingEntry> getInputs() {
        return this.inputs;
    }

    public List<OutputFieldMappingEntry> getOutputs() {
        return this.outputs;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("inputs", this.inputs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outputs", this.outputs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("context", this.context);
        return jsonWriter.writeEndObject();
    }

    public static SearchIndexerSkill fromJson(JsonReader jsonReader) throws IOException {
        return (SearchIndexerSkill)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                SearchIndexerSkill searchIndexerSkill;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("@odata.type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("#Microsoft.Skills.Util.ConditionalSkill".equals(discriminatorValue)) {
                    searchIndexerSkill = ConditionalSkill.fromJson(readerToUse.reset());
                    return searchIndexerSkill;
                }
                if ("#Microsoft.Skills.Text.KeyPhraseExtractionSkill".equals(discriminatorValue)) {
                    searchIndexerSkill = KeyPhraseExtractionSkill.fromJson(readerToUse.reset());
                    return searchIndexerSkill;
                }
                if ("#Microsoft.Skills.Vision.OcrSkill".equals(discriminatorValue)) {
                    searchIndexerSkill = OcrSkill.fromJson(readerToUse.reset());
                    return searchIndexerSkill;
                }
                if ("#Microsoft.Skills.Vision.ImageAnalysisSkill".equals(discriminatorValue)) {
                    searchIndexerSkill = ImageAnalysisSkill.fromJson(readerToUse.reset());
                    return searchIndexerSkill;
                }
                if ("#Microsoft.Skills.Text.LanguageDetectionSkill".equals(discriminatorValue)) {
                    searchIndexerSkill = LanguageDetectionSkill.fromJson(readerToUse.reset());
                    return searchIndexerSkill;
                }
                if ("#Microsoft.Skills.Util.ShaperSkill".equals(discriminatorValue)) {
                    searchIndexerSkill = ShaperSkill.fromJson(readerToUse.reset());
                    return searchIndexerSkill;
                }
                if ("#Microsoft.Skills.Text.MergeSkill".equals(discriminatorValue)) {
                    searchIndexerSkill = MergeSkill.fromJson(readerToUse.reset());
                    return searchIndexerSkill;
                }
                if ("#Microsoft.Skills.Text.V3.SentimentSkill".equals(discriminatorValue)) {
                    searchIndexerSkill = SentimentSkillV3.fromJson(readerToUse.reset());
                    return searchIndexerSkill;
                }
                if ("#Microsoft.Skills.Text.V3.EntityLinkingSkill".equals(discriminatorValue)) {
                    searchIndexerSkill = EntityLinkingSkill.fromJson(readerToUse.reset());
                    return searchIndexerSkill;
                }
                if ("#Microsoft.Skills.Text.V3.EntityRecognitionSkill".equals(discriminatorValue)) {
                    searchIndexerSkill = EntityRecognitionSkillV3.fromJson(readerToUse.reset());
                    return searchIndexerSkill;
                }
                if ("#Microsoft.Skills.Text.SplitSkill".equals(discriminatorValue)) {
                    searchIndexerSkill = SplitSkill.fromJson(readerToUse.reset());
                    return searchIndexerSkill;
                }
                if ("#Microsoft.Skills.Text.CustomEntityLookupSkill".equals(discriminatorValue)) {
                    searchIndexerSkill = CustomEntityLookupSkill.fromJson(readerToUse.reset());
                    return searchIndexerSkill;
                }
                if ("#Microsoft.Skills.Text.TranslationSkill".equals(discriminatorValue)) {
                    searchIndexerSkill = TextTranslationSkill.fromJson(readerToUse.reset());
                    return searchIndexerSkill;
                }
                if ("#Microsoft.Skills.Util.DocumentExtractionSkill".equals(discriminatorValue)) {
                    searchIndexerSkill = DocumentExtractionSkill.fromJson(readerToUse.reset());
                    return searchIndexerSkill;
                }
                if ("#Microsoft.Skills.Util.DocumentIntelligenceLayoutSkill".equals(discriminatorValue)) {
                    searchIndexerSkill = DocumentIntelligenceLayoutSkill.fromJson(readerToUse.reset());
                    return searchIndexerSkill;
                }
                if ("#Microsoft.Skills.Custom.WebApiSkill".equals(discriminatorValue)) {
                    searchIndexerSkill = WebApiSkill.fromJson(readerToUse.reset());
                    return searchIndexerSkill;
                }
                if ("#Microsoft.Skills.Text.AzureOpenAIEmbeddingSkill".equals(discriminatorValue)) {
                    searchIndexerSkill = AzureOpenAIEmbeddingSkill.fromJson(readerToUse.reset());
                    return searchIndexerSkill;
                }
                if ("#Microsoft.Skills.Text.PIIDetectionSkill".equals(discriminatorValue)) {
                    searchIndexerSkill = PiiDetectionSkill.fromJson(readerToUse.reset());
                    return searchIndexerSkill;
                }
                if ("#Microsoft.Skills.Text.EntityRecognitionSkill".equals(discriminatorValue)) {
                    searchIndexerSkill = EntityRecognitionSkillV1.fromJson(readerToUse.reset());
                    return searchIndexerSkill;
                }
                if ("#Microsoft.Skills.Text.SentimentSkill".equals(discriminatorValue)) {
                    searchIndexerSkill = SentimentSkillV1.fromJson(readerToUse.reset());
                    return searchIndexerSkill;
                }
                searchIndexerSkill = SearchIndexerSkill.fromJsonKnownDiscriminator(readerToUse.reset());
                return searchIndexerSkill;
            }
        });
    }

    static SearchIndexerSkill fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (SearchIndexerSkill)jsonReader.readObject(reader -> {
            boolean inputsFound = false;
            List inputs = null;
            boolean outputsFound = false;
            List outputs = null;
            String odataType = null;
            String name = null;
            String description = null;
            String context = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    inputsFound = true;
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    outputs = reader.readArray(reader1 -> OutputFieldMappingEntry.fromJson(reader1));
                    outputsFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("context".equals(fieldName)) {
                    context = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (inputsFound && outputsFound) {
                SearchIndexerSkill deserializedSearchIndexerSkill = new SearchIndexerSkill(inputs, outputs);
                deserializedSearchIndexerSkill.odataType = odataType;
                deserializedSearchIndexerSkill.name = name;
                deserializedSearchIndexerSkill.description = description;
                deserializedSearchIndexerSkill.context = context;
                return deserializedSearchIndexerSkill;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!inputsFound) {
                missingProperties.add("inputs");
            }
            if (!outputsFound) {
                missingProperties.add("outputs");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

