/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.BinaryQuantizationCompression;
import com.azure.search.documents.indexes.models.RescoringOptions;
import com.azure.search.documents.indexes.models.ScalarQuantizationCompression;
import com.azure.search.documents.indexes.models.VectorSearchCompressionKind;
import java.io.IOException;

public class VectorSearchCompression
implements JsonSerializable<VectorSearchCompression> {
    private VectorSearchCompressionKind kind = VectorSearchCompressionKind.fromString("VectorSearchCompression");
    private final String compressionName;
    private RescoringOptions rescoringOptions;
    private Integer truncationDimension;
    private Boolean rerankWithOriginalVectors;
    private Double defaultOversampling;

    public VectorSearchCompression(String compressionName) {
        this.compressionName = compressionName;
    }

    public VectorSearchCompressionKind getKind() {
        return this.kind;
    }

    public String getCompressionName() {
        return this.compressionName;
    }

    public RescoringOptions getRescoringOptions() {
        return this.rescoringOptions;
    }

    public VectorSearchCompression setRescoringOptions(RescoringOptions rescoringOptions) {
        this.rescoringOptions = rescoringOptions;
        return this;
    }

    public Integer getTruncationDimension() {
        return this.truncationDimension;
    }

    public VectorSearchCompression setTruncationDimension(Integer truncationDimension) {
        this.truncationDimension = truncationDimension;
        return this;
    }

    public Boolean isRerankWithOriginalVectors() {
        return this.rerankWithOriginalVectors;
    }

    public VectorSearchCompression setRerankWithOriginalVectors(Boolean rerankWithOriginalVectors) {
        this.rerankWithOriginalVectors = rerankWithOriginalVectors;
        return this;
    }

    public Double getDefaultOversampling() {
        return this.defaultOversampling;
    }

    public VectorSearchCompression setDefaultOversampling(Double defaultOversampling) {
        this.defaultOversampling = defaultOversampling;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.compressionName);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("rescoringOptions", (JsonSerializable)this.rescoringOptions);
        jsonWriter.writeNumberField("truncationDimension", (Number)this.truncationDimension);
        jsonWriter.writeBooleanField("rerankWithOriginalVectors", this.rerankWithOriginalVectors);
        jsonWriter.writeNumberField("defaultOversampling", (Number)this.defaultOversampling);
        return jsonWriter.writeEndObject();
    }

    public static VectorSearchCompression fromJson(JsonReader jsonReader) throws IOException {
        return (VectorSearchCompression)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                VectorSearchCompression vectorSearchCompression;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("scalarQuantization".equals(discriminatorValue)) {
                    vectorSearchCompression = ScalarQuantizationCompression.fromJson(readerToUse.reset());
                    return vectorSearchCompression;
                }
                if ("binaryQuantization".equals(discriminatorValue)) {
                    vectorSearchCompression = BinaryQuantizationCompression.fromJson(readerToUse.reset());
                    return vectorSearchCompression;
                }
                vectorSearchCompression = VectorSearchCompression.fromJsonKnownDiscriminator(readerToUse.reset());
                return vectorSearchCompression;
            }
        });
    }

    static VectorSearchCompression fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (VectorSearchCompression)jsonReader.readObject(reader -> {
            boolean compressionNameFound = false;
            String compressionName = null;
            VectorSearchCompressionKind kind = null;
            RescoringOptions rescoringOptions = null;
            Integer truncationDimension = null;
            Boolean rerankWithOriginalVectors = null;
            Double defaultOversampling = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    compressionName = reader.getString();
                    compressionNameFound = true;
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    kind = VectorSearchCompressionKind.fromString(reader.getString());
                    continue;
                }
                if ("rescoringOptions".equals(fieldName)) {
                    rescoringOptions = RescoringOptions.fromJson(reader);
                    continue;
                }
                if ("truncationDimension".equals(fieldName)) {
                    truncationDimension = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("rerankWithOriginalVectors".equals(fieldName)) {
                    rerankWithOriginalVectors = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("defaultOversampling".equals(fieldName)) {
                    defaultOversampling = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            if (compressionNameFound) {
                VectorSearchCompression deserializedVectorSearchCompression = new VectorSearchCompression(compressionName);
                deserializedVectorSearchCompression.kind = kind;
                deserializedVectorSearchCompression.rescoringOptions = rescoringOptions;
                deserializedVectorSearchCompression.truncationDimension = truncationDimension;
                deserializedVectorSearchCompression.rerankWithOriginalVectors = rerankWithOriginalVectors;
                deserializedVectorSearchCompression.defaultOversampling = defaultOversampling;
                return deserializedVectorSearchCompression;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

