/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.administration.KeyVaultSettingsClientBuilder;
import com.azure.security.keyvault.administration.implementation.KeyVaultAdministrationUtils;
import com.azure.security.keyvault.administration.implementation.KeyVaultErrorCodeStrings;
import com.azure.security.keyvault.administration.implementation.KeyVaultSettingsClientImpl;
import com.azure.security.keyvault.administration.implementation.models.Setting;
import com.azure.security.keyvault.administration.implementation.models.SettingsListResult;
import com.azure.security.keyvault.administration.models.KeyVaultGetSettingsResult;
import com.azure.security.keyvault.administration.models.KeyVaultSetting;
import com.azure.security.keyvault.administration.models.KeyVaultSettingType;
import java.util.ArrayList;
import java.util.Objects;
import reactor.core.publisher.Mono;

@ServiceClient(builder=KeyVaultSettingsClientBuilder.class, isAsync=true, serviceInterfaces={KeyVaultSettingsClientImpl.KeyVaultSettingsClientService.class})
public final class KeyVaultSettingsAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultSettingsAsyncClient.class);
    private final String vaultUrl;
    private final KeyVaultSettingsClientImpl implClient;

    KeyVaultSettingsAsyncClient(String vaultUrl, KeyVaultSettingsClientImpl implClient) {
        this.vaultUrl = vaultUrl;
        this.implClient = implClient;
    }

    HttpPipeline getHttpPipeline() {
        return this.implClient.getHttpPipeline();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultSetting> updateSetting(KeyVaultSetting setting) {
        Objects.requireNonNull(setting, String.format(KeyVaultErrorCodeStrings.getErrorString("parameter_required"), "'setting'"));
        try {
            String settingValue = null;
            if (setting.getType() == KeyVaultSettingType.BOOLEAN) {
                settingValue = Boolean.toString(setting.asBoolean());
            }
            return this.implClient.updateSettingAsync(this.vaultUrl, setting.getName(), settingValue).doOnRequest(ignored -> LOGGER.verbose("Updating account setting - {}", new Object[]{setting.getName()})).doOnSuccess(response -> LOGGER.verbose("Updated account setting - {}", new Object[]{setting.getName()})).doOnError(error -> LOGGER.warning("Failed updating account setting - {}", new Object[]{setting.getName(), error})).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(KeyVaultSettingsAsyncClient::transformToKeyVaultSetting);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultSetting>> updateSettingWithResponse(KeyVaultSetting setting) {
        Objects.requireNonNull(setting, String.format(KeyVaultErrorCodeStrings.getErrorString("parameter_required"), "'setting'"));
        try {
            String settingValue = null;
            if (setting.getType() == KeyVaultSettingType.BOOLEAN) {
                settingValue = Boolean.toString(setting.asBoolean());
            }
            return this.implClient.updateSettingWithResponseAsync(this.vaultUrl, setting.getName(), settingValue).doOnRequest(ignored -> LOGGER.verbose("Updating account setting - {}", new Object[]{setting.getName()})).doOnSuccess(response -> LOGGER.verbose("Updated account setting - {}", new Object[]{setting.getName()})).doOnError(error -> LOGGER.warning("Failed updating account setting - {}", new Object[]{setting.getName(), error})).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(response -> new SimpleResponse(response, (Object)KeyVaultSettingsAsyncClient.transformToKeyVaultSetting((Setting)response.getValue())));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultSetting> getSetting(String name) {
        try {
            return this.implClient.getSettingAsync(this.vaultUrl, name).doOnRequest(ignored -> LOGGER.verbose("Retrieving account setting - {}", new Object[]{name})).doOnSuccess(response -> LOGGER.verbose("Retrieved account setting - {}", new Object[]{name})).doOnError(error -> LOGGER.warning("Failed retrieving account setting - {}", new Object[]{name, error})).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(KeyVaultSettingsAsyncClient::transformToKeyVaultSetting);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultSetting>> getSettingWithResponse(String name) {
        try {
            return this.implClient.getSettingWithResponseAsync(this.vaultUrl, name).doOnRequest(ignored -> LOGGER.verbose("Retrieving account setting - {}", new Object[]{name})).doOnSuccess(response -> LOGGER.verbose("Retrieved account setting - {}", new Object[]{name})).doOnError(error -> LOGGER.warning("Failed retrieving account setting - {}", new Object[]{name, error})).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(response -> new SimpleResponse(response, (Object)KeyVaultSettingsAsyncClient.transformToKeyVaultSetting((Setting)response.getValue())));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultGetSettingsResult> getSettings() {
        try {
            return this.implClient.getSettingsAsync(this.vaultUrl).doOnRequest(ignored -> LOGGER.verbose("Listing account settings")).doOnSuccess(response -> LOGGER.verbose("Listed account settings successfully")).doOnError(error -> LOGGER.warning("Failed retrieving account settings", new Object[]{error})).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(settingsListResult -> {
                ArrayList<KeyVaultSetting> keyVaultSettings = new ArrayList<KeyVaultSetting>();
                settingsListResult.getSettings().forEach(setting -> keyVaultSettings.add(KeyVaultSettingsAsyncClient.transformToKeyVaultSetting(setting)));
                return new KeyVaultGetSettingsResult(keyVaultSettings);
            });
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultGetSettingsResult>> getSettingsWithResponse() {
        try {
            return this.implClient.getSettingsWithResponseAsync(this.vaultUrl).doOnRequest(ignored -> LOGGER.verbose("Listing account settings")).doOnSuccess(response -> LOGGER.verbose("Listed account settings successfully")).doOnError(error -> LOGGER.warning("Failed retrieving account settings", new Object[]{error})).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(response -> {
                ArrayList<KeyVaultSetting> keyVaultSettings = new ArrayList<KeyVaultSetting>();
                ((SettingsListResult)response.getValue()).getSettings().forEach(setting -> keyVaultSettings.add(KeyVaultSettingsAsyncClient.transformToKeyVaultSetting(setting)));
                return new SimpleResponse(response, (Object)new KeyVaultGetSettingsResult(keyVaultSettings));
            });
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    static KeyVaultSetting transformToKeyVaultSetting(Setting setting) {
        if (KeyVaultSettingType.BOOLEAN.toString().equalsIgnoreCase(setting.getType().toString())) {
            return new KeyVaultSetting(setting.getName(), Boolean.parseBoolean(setting.getValue()));
        }
        throw new IllegalArgumentException(String.format("Could not deserialize setting with name '%s'. Type '%s' is not supported.", new Object[]{setting.getName(), setting.getType()}));
    }
}

