/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.administration.implementation.models.Permission;
import com.azure.security.keyvault.administration.models.KeyVaultRoleDefinitionType;
import com.azure.security.keyvault.administration.models.KeyVaultRoleScope;
import com.azure.security.keyvault.administration.models.KeyVaultRoleType;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class RoleDefinition
implements JsonSerializable<RoleDefinition> {
    private String id;
    private String name;
    private KeyVaultRoleDefinitionType type;
    private String roleName;
    private String description;
    private KeyVaultRoleType roleType;
    private List<Permission> permissions;
    private List<KeyVaultRoleScope> assignableScopes;

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public KeyVaultRoleDefinitionType getType() {
        return this.type;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public RoleDefinition setRoleName(String roleName) {
        this.roleName = roleName;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public RoleDefinition setDescription(String description) {
        this.description = description;
        return this;
    }

    public KeyVaultRoleType getRoleType() {
        return this.roleType;
    }

    public RoleDefinition setRoleType(KeyVaultRoleType roleType) {
        this.roleType = roleType;
        return this;
    }

    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public RoleDefinition setPermissions(List<Permission> permissions) {
        this.permissions = permissions;
        return this;
    }

    public List<KeyVaultRoleScope> getAssignableScopes() {
        return this.assignableScopes;
    }

    public RoleDefinition setAssignableScopes(List<KeyVaultRoleScope> assignableScopes) {
        this.assignableScopes = assignableScopes;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.roleName != null || this.description != null || this.roleType != null || this.permissions != null || this.assignableScopes != null) {
            jsonWriter.writeStartObject("properties");
            jsonWriter.writeStringField("roleName", this.roleName);
            jsonWriter.writeStringField("description", this.description);
            jsonWriter.writeStringField("type", Objects.toString((Object)this.roleType, null));
            jsonWriter.writeArrayField("permissions", this.permissions, (writer, element) -> writer.writeJson((JsonSerializable)element));
            jsonWriter.writeArrayField("assignableScopes", this.assignableScopes, (writer, element) -> writer.writeString(Objects.toString(element, null)));
            jsonWriter.writeEndObject();
        }
        return jsonWriter.writeEndObject();
    }

    public static RoleDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (RoleDefinition)jsonReader.readObject(reader -> {
            RoleDefinition deserializedRoleDefinition = new RoleDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRoleDefinition.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRoleDefinition.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRoleDefinition.type = KeyVaultRoleDefinitionType.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("roleName".equals(fieldName)) {
                            deserializedRoleDefinition.roleName = reader.getString();
                            continue;
                        }
                        if ("description".equals(fieldName)) {
                            deserializedRoleDefinition.description = reader.getString();
                            continue;
                        }
                        if ("type".equals(fieldName)) {
                            deserializedRoleDefinition.roleType = KeyVaultRoleType.fromString(reader.getString());
                            continue;
                        }
                        if ("permissions".equals(fieldName)) {
                            List permissions;
                            deserializedRoleDefinition.permissions = permissions = reader.readArray(reader1 -> Permission.fromJson(reader1));
                            continue;
                        }
                        if ("assignableScopes".equals(fieldName)) {
                            List assignableScopes;
                            deserializedRoleDefinition.assignableScopes = assignableScopes = reader.readArray(reader1 -> KeyVaultRoleScope.fromString(reader1.getString()));
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoleDefinition;
        });
    }
}

