/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.administration.implementation.models.Permission;
import com.azure.security.keyvault.administration.models.KeyVaultRoleScope;
import com.azure.security.keyvault.administration.models.KeyVaultRoleType;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public final class RoleDefinitionProperties
implements JsonSerializable<RoleDefinitionProperties> {
    private String roleName;
    private String description;
    private KeyVaultRoleType roleType;
    private List<Permission> permissions;
    private List<KeyVaultRoleScope> assignableScopes;

    public String getRoleName() {
        return this.roleName;
    }

    public RoleDefinitionProperties setRoleName(String roleName) {
        this.roleName = roleName;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public RoleDefinitionProperties setDescription(String description) {
        this.description = description;
        return this;
    }

    public KeyVaultRoleType getRoleType() {
        return this.roleType;
    }

    public RoleDefinitionProperties setRoleType(KeyVaultRoleType roleType) {
        this.roleType = roleType;
        return this;
    }

    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public RoleDefinitionProperties setPermissions(List<Permission> permissions) {
        this.permissions = permissions;
        return this;
    }

    public List<KeyVaultRoleScope> getAssignableScopes() {
        return this.assignableScopes;
    }

    public RoleDefinitionProperties setAssignableScopes(List<KeyVaultRoleScope> assignableScopes) {
        this.assignableScopes = assignableScopes;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("roleName", this.roleName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("type", Objects.toString((Object)this.roleType, null));
        jsonWriter.writeArrayField("permissions", this.permissions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("assignableScopes", this.assignableScopes, (writer, element) -> writer.writeString(Objects.toString(element, null)));
        return jsonWriter.writeEndObject();
    }

    public static RoleDefinitionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RoleDefinitionProperties)jsonReader.readObject(reader -> {
            RoleDefinitionProperties deserializedRoleDefinitionProperties = new RoleDefinitionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("roleName".equals(fieldName)) {
                    deserializedRoleDefinitionProperties.roleName = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedRoleDefinitionProperties.description = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRoleDefinitionProperties.roleType = KeyVaultRoleType.fromString(reader.getString());
                    continue;
                }
                if ("permissions".equals(fieldName)) {
                    List permissions;
                    deserializedRoleDefinitionProperties.permissions = permissions = reader.readArray(reader1 -> Permission.fromJson(reader1));
                    continue;
                }
                if ("assignableScopes".equals(fieldName)) {
                    List assignableScopes;
                    deserializedRoleDefinitionProperties.assignableScopes = assignableScopes = reader.readArray(reader1 -> KeyVaultRoleScope.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoleDefinitionProperties;
        });
    }
}

