/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public final class RoleAssignmentProperties
implements JsonSerializable<RoleAssignmentProperties> {
    private final String roleDefinitionId;
    private final String principalId;

    public RoleAssignmentProperties(String roleDefinitionId, String principalId) {
        this.roleDefinitionId = roleDefinitionId;
        this.principalId = principalId;
    }

    public String getRoleDefinitionId() {
        return this.roleDefinitionId;
    }

    public String getPrincipalId() {
        return this.principalId;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("roleDefinitionId", this.roleDefinitionId);
        jsonWriter.writeStringField("principalId", this.principalId);
        return jsonWriter.writeEndObject();
    }

    public static RoleAssignmentProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RoleAssignmentProperties)jsonReader.readObject(reader -> {
            boolean roleDefinitionIdFound = false;
            String roleDefinitionId = null;
            boolean principalIdFound = false;
            String principalId = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("roleDefinitionId".equals(fieldName)) {
                    roleDefinitionId = reader.getString();
                    roleDefinitionIdFound = true;
                    continue;
                }
                if ("principalId".equals(fieldName)) {
                    principalId = reader.getString();
                    principalIdFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (roleDefinitionIdFound && principalIdFound) {
                return new RoleAssignmentProperties(roleDefinitionId, principalId);
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!roleDefinitionIdFound) {
                missingProperties.add("roleDefinitionId");
            }
            if (!principalIdFound) {
                missingProperties.add("principalId");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

