/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.certificates.CertificateAsyncClient;
import com.azure.security.keyvault.certificates.CertificateClient;
import com.azure.security.keyvault.certificates.CertificateServiceVersion;
import com.azure.security.keyvault.certificates.KeyVaultErrorCodeStrings;
import com.azure.security.keyvault.certificates.implementation.KeyVaultCredentialPolicy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={CertificateClient.class, CertificateAsyncClient.class})
public final class CertificateClientBuilder {
    private final ClientLogger logger = new ClientLogger(CertificateClientBuilder.class);
    private static final String AZURE_KEY_VAULT_CERTIFICATES_PROPERTIES = "azure-key-vault-certificates.properties";
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private final List<HttpPipelinePolicy> policies;
    private final Map<String, String> properties;
    private TokenCredential credential;
    private HttpPipeline pipeline;
    private URL vaultUrl;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions;
    private final RetryPolicy retryPolicy = new RetryPolicy();
    private Configuration configuration;
    private CertificateServiceVersion version;

    public CertificateClientBuilder() {
        this.httpLogOptions = new HttpLogOptions();
        this.policies = new ArrayList<HttpPipelinePolicy>();
        this.properties = CoreUtils.getProperties((String)AZURE_KEY_VAULT_CERTIFICATES_PROPERTIES);
    }

    public CertificateClient buildClient() {
        return new CertificateClient(this.buildAsyncClient());
    }

    public CertificateAsyncClient buildAsyncClient() {
        CertificateServiceVersion serviceVersion;
        Configuration buildConfiguration = this.configuration != null ? this.configuration : Configuration.getGlobalConfiguration().clone();
        URL buildEndpoint = this.getBuildEndpoint(buildConfiguration);
        if (buildEndpoint == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(KeyVaultErrorCodeStrings.getErrorString("vault_endpoint_required")));
        }
        CertificateServiceVersion certificateServiceVersion = serviceVersion = this.version != null ? this.version : CertificateServiceVersion.getLatest();
        if (this.pipeline != null) {
            return new CertificateAsyncClient(this.vaultUrl, this.pipeline, serviceVersion);
        }
        if (this.credential == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(KeyVaultErrorCodeStrings.getErrorString("credentials_required")));
        }
        ArrayList<Object> policies = new ArrayList<Object>();
        String clientName = this.properties.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = this.properties.getOrDefault(SDK_VERSION, "UnknownVersion");
        policies.add(new UserAgentPolicy(this.httpLogOptions.getApplicationId(), clientName, clientVersion, buildConfiguration));
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(this.retryPolicy);
        policies.add(new KeyVaultCredentialPolicy(this.credential));
        policies.addAll(this.policies);
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(this.httpLogOptions));
        HttpPipeline pipeline = new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).build();
        return new CertificateAsyncClient(this.vaultUrl, pipeline, serviceVersion);
    }

    public CertificateClientBuilder vaultUrl(String vaultUrl) {
        try {
            this.vaultUrl = new URL(vaultUrl);
        }
        catch (MalformedURLException e) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The Azure Key Vault endpoint url is malformed."));
        }
        return this;
    }

    public CertificateClientBuilder credential(TokenCredential credential) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.credential = credential;
        return this;
    }

    public CertificateClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    public CertificateClientBuilder addPolicy(HttpPipelinePolicy policy) {
        Objects.requireNonNull(policy, "'policy' cannot be null.");
        this.policies.add(policy);
        return this;
    }

    public CertificateClientBuilder httpClient(HttpClient client) {
        Objects.requireNonNull(client, "'client' cannot be null.");
        this.httpClient = client;
        return this;
    }

    public CertificateClientBuilder pipeline(HttpPipeline pipeline) {
        Objects.requireNonNull(pipeline, "'pipeline' cannot be null.");
        this.pipeline = pipeline;
        return this;
    }

    public CertificateClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public CertificateClientBuilder serviceVersion(CertificateServiceVersion version) {
        this.version = version;
        return this;
    }

    private URL getBuildEndpoint(Configuration configuration) {
        if (this.vaultUrl != null) {
            return this.vaultUrl;
        }
        String configEndpoint = configuration.get("AZURE_KEYVAULT_ENDPOINT");
        if (CoreUtils.isNullOrEmpty((CharSequence)configEndpoint)) {
            return null;
        }
        try {
            return new URL(configEndpoint);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }
}

