/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates;

import com.azure.security.keyvault.certificates.Action;
import com.azure.security.keyvault.certificates.Trigger;
import com.azure.security.keyvault.certificates.models.LifetimeAction;
import com.fasterxml.jackson.annotation.JsonProperty;

class LifetimeActionRequest {
    @JsonProperty(value="trigger")
    private Trigger trigger;
    @JsonProperty(value="action")
    private Action action;

    LifetimeActionRequest(LifetimeAction lifeTimeAction) {
        this.action = new Action().setActionType(lifeTimeAction.getAction());
        this.trigger = new Trigger().daysBeforeExpiry(lifeTimeAction.getDaysBeforeExpiry()).lifetimePercentage(lifeTimeAction.getLifetimePercentage());
    }

    Trigger trigger() {
        return this.trigger;
    }

    LifetimeActionRequest withTrigger(Trigger trigger) {
        this.trigger = trigger;
        return this;
    }

    Action action() {
        return this.action;
    }

    LifetimeActionRequest action(Action action) {
        this.action = action;
        return this;
    }
}

