/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates;

import com.azure.security.keyvault.certificates.SubjectAlternativeNamesRequest;
import com.azure.security.keyvault.certificates.models.CertificateKeyUsage;
import com.azure.security.keyvault.certificates.models.CertificatePolicy;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

class X509CertificateProperties {
    @JsonProperty(value="subject")
    private String subject;
    @JsonProperty(value="ekus")
    private List<String> ekus;
    @JsonProperty(value="sans")
    private SubjectAlternativeNamesRequest subjectAlternativeNamesRequest;
    @JsonProperty(value="key_usage")
    private List<CertificateKeyUsage> keyUsage;
    @JsonProperty(value="validity_months")
    private Integer validityInMonths;

    X509CertificateProperties(CertificatePolicy certificatePolicy) {
        this.subject = certificatePolicy.getSubject();
        this.ekus = certificatePolicy.getEnhancedKeyUsage();
        this.keyUsage = certificatePolicy.getKeyUsage();
        this.subjectAlternativeNamesRequest = new SubjectAlternativeNamesRequest(certificatePolicy.getSubjectAlternativeNames());
        this.validityInMonths = certificatePolicy.getValidityInMonths();
    }

    String subject() {
        return this.subject;
    }

    X509CertificateProperties subject(String subject) {
        this.subject = subject;
        return this;
    }

    List<String> ekus() {
        return this.ekus;
    }

    X509CertificateProperties ekus(List<String> ekus) {
        this.ekus = ekus;
        return this;
    }

    SubjectAlternativeNamesRequest subjectAlternativeNames() {
        return this.subjectAlternativeNamesRequest;
    }

    X509CertificateProperties subjectAlternativeNames(SubjectAlternativeNamesRequest subjectAlternativeNamesRequest) {
        this.subjectAlternativeNamesRequest = subjectAlternativeNamesRequest;
        return this;
    }

    List<CertificateKeyUsage> keyUsage() {
        return this.keyUsage;
    }

    X509CertificateProperties keyUsage(List<CertificateKeyUsage> keyUsage) {
        this.keyUsage = keyUsage;
        return this;
    }

    Integer validityInMonths() {
        return this.validityInMonths;
    }

    X509CertificateProperties validityInMonths(Integer validityInMonths) {
        this.validityInMonths = validityInMonths;
        return this;
    }
}

