// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator

package com.azure.security.keyvault.certificates.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;

import java.util.Collection;


/**
 * Defines values for CertificateKeyCurveName.
 */
public final class CertificateKeyCurveName extends ExpandableStringEnum<CertificateKeyCurveName> {

    /**
     * Static value P-256 for CertificateKeyCurveName.
     */
    public static final CertificateKeyCurveName P_256 = fromString("P-256");

    /**
     * Static value P-384 for CertificateKeyCurveName.
     */
    public static final CertificateKeyCurveName P_384 = fromString("P-384");

    /**
     * Static value P-521 for CertificateKeyCurveName.
     */
    public static final CertificateKeyCurveName P_521 = fromString("P-521");

    /**
     * Static value P-256K for KeyCurve.
     */
    public static final CertificateKeyCurveName P_256K = fromString("P-256K");

    /**
     * Creates or finds a CertificateKeyCurveName from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding KeyCurve.
     */
    @JsonCreator
    public static CertificateKeyCurveName fromString(String name) {
        return fromString(name, CertificateKeyCurveName.class);
    }

    /**
     * @return known CertificateKeyCurveName values.
     */
    public static Collection<CertificateKeyCurveName> values() {
        return values(CertificateKeyCurveName.class);
    }
}
