/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import com.azure.security.keyvault.certificates.CertificateBackup;
import com.azure.security.keyvault.certificates.CertificateClientBuilder;
import com.azure.security.keyvault.certificates.CertificateImportParameters;
import com.azure.security.keyvault.certificates.CertificateIssuerSetParameters;
import com.azure.security.keyvault.certificates.CertificateIssuerUpdateParameters;
import com.azure.security.keyvault.certificates.CertificateMergeParameters;
import com.azure.security.keyvault.certificates.CertificateOperationUpdateParameter;
import com.azure.security.keyvault.certificates.CertificatePolicyRequest;
import com.azure.security.keyvault.certificates.CertificateRequestAttributes;
import com.azure.security.keyvault.certificates.CertificateRequestParameters;
import com.azure.security.keyvault.certificates.CertificateRestoreParameters;
import com.azure.security.keyvault.certificates.CertificateService;
import com.azure.security.keyvault.certificates.CertificateServiceVersion;
import com.azure.security.keyvault.certificates.CertificateUpdateParameters;
import com.azure.security.keyvault.certificates.Contacts;
import com.azure.security.keyvault.certificates.IssuerCredentials;
import com.azure.security.keyvault.certificates.KeyVaultErrorCodeStrings;
import com.azure.security.keyvault.certificates.OrganizationDetails;
import com.azure.security.keyvault.certificates.models.CertificateContact;
import com.azure.security.keyvault.certificates.models.CertificateContentType;
import com.azure.security.keyvault.certificates.models.CertificateIssuer;
import com.azure.security.keyvault.certificates.models.CertificateOperation;
import com.azure.security.keyvault.certificates.models.CertificatePolicy;
import com.azure.security.keyvault.certificates.models.CertificateProperties;
import com.azure.security.keyvault.certificates.models.DeletedCertificate;
import com.azure.security.keyvault.certificates.models.ImportCertificateOptions;
import com.azure.security.keyvault.certificates.models.IssuerProperties;
import com.azure.security.keyvault.certificates.models.KeyVaultCertificate;
import com.azure.security.keyvault.certificates.models.KeyVaultCertificateWithPolicy;
import com.azure.security.keyvault.certificates.models.MergeCertificateOptions;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import reactor.core.publisher.Mono;

@ServiceClient(builder=CertificateClientBuilder.class, isAsync=true, serviceInterfaces={CertificateService.class})
public final class CertificateAsyncClient {
    private final String apiVersion;
    static final String ACCEPT_LANGUAGE = "en-US";
    static final int DEFAULT_MAX_PAGE_RESULTS = 25;
    static final String CONTENT_TYPE_HEADER_VALUE = "application/json";
    private static final String KEYVAULT_TRACING_NAMESPACE_VALUE = "Microsoft.KeyVault";
    private static final Duration DEFAULT_POLLING_INTERVAL = Duration.ofSeconds(1L);
    private final String vaultUrl;
    private final CertificateService service;
    private final ClientLogger logger = new ClientLogger(CertificateAsyncClient.class);
    private final HttpPipeline pipeline;

    CertificateAsyncClient(URL vaultUrl, HttpPipeline pipeline, CertificateServiceVersion version) {
        Objects.requireNonNull(vaultUrl, KeyVaultErrorCodeStrings.getErrorString("vault_endpoint_required"));
        this.vaultUrl = vaultUrl.toString();
        this.service = (CertificateService)RestProxy.create(CertificateService.class, (HttpPipeline)pipeline);
        this.pipeline = pipeline;
        this.apiVersion = version.getVersion();
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    HttpPipeline getHttpPipeline() {
        return this.pipeline;
    }

    Duration getDefaultPollingInterval() {
        return DEFAULT_POLLING_INTERVAL;
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<CertificateOperation, KeyVaultCertificateWithPolicy> beginCreateCertificate(String certificateName, CertificatePolicy policy, Boolean isEnabled, Map<String, String> tags) {
        return new PollerFlux(this.getDefaultPollingInterval(), this.activationOperation(certificateName, policy, isEnabled, tags), this.createPollOperation(certificateName), this.cancelOperation(certificateName), this.fetchResultOperation(certificateName));
    }

    private BiFunction<PollingContext<CertificateOperation>, PollResponse<CertificateOperation>, Mono<CertificateOperation>> cancelOperation(String certificateName) {
        return (pollingContext, firstResponse) -> FluxUtil.withContext(context -> this.cancelCertificateOperationWithResponse(certificateName, (Context)context)).flatMap(FluxUtil::toMono);
    }

    private Function<PollingContext<CertificateOperation>, Mono<CertificateOperation>> activationOperation(String certificateName, CertificatePolicy policy, boolean enabled, Map<String, String> tags) {
        return pollingContext -> FluxUtil.withContext(context -> this.createCertificateWithResponse(certificateName, policy, enabled, tags, (Context)context)).flatMap(certificateOperationResponse -> Mono.just((Object)((CertificateOperation)certificateOperationResponse.getValue())));
    }

    private Function<PollingContext<CertificateOperation>, Mono<KeyVaultCertificateWithPolicy>> fetchResultOperation(String certificateName) {
        return pollingContext -> FluxUtil.withContext(context -> this.getCertificateWithResponse(certificateName, "", (Context)context)).flatMap(certificateResponse -> Mono.just((Object)((KeyVaultCertificateWithPolicy)certificateResponse.getValue())));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<CertificateOperation, KeyVaultCertificateWithPolicy> beginCreateCertificate(String certificateName, CertificatePolicy policy) {
        return this.beginCreateCertificate(certificateName, policy, true, null);
    }

    private Function<PollingContext<CertificateOperation>, Mono<PollResponse<CertificateOperation>>> createPollOperation(String certificateName) {
        return pollingContext -> {
            try {
                return FluxUtil.withContext(context -> this.service.getCertificateOperation(this.vaultUrl, certificateName, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE))).flatMap(this::processCertificateOperationResponse);
            }
            catch (HttpResponseException e) {
                this.logger.logExceptionAsError((RuntimeException)((Object)e));
                return Mono.just((Object)new PollResponse(LongRunningOperationStatus.FAILED, null));
            }
        };
    }

    private Mono<PollResponse<CertificateOperation>> processCertificateOperationResponse(Response<CertificateOperation> certificateOperationResponse) {
        LongRunningOperationStatus status = null;
        switch (((CertificateOperation)certificateOperationResponse.getValue()).getStatus()) {
            case "inProgress": {
                status = LongRunningOperationStatus.IN_PROGRESS;
                break;
            }
            case "completed": {
                status = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                break;
            }
            case "failed": {
                status = LongRunningOperationStatus.FAILED;
                break;
            }
            default: {
                status = LongRunningOperationStatus.fromString((String)((CertificateOperation)certificateOperationResponse.getValue()).getStatus(), (boolean)true);
            }
        }
        return Mono.just((Object)new PollResponse(status, (Object)((CertificateOperation)certificateOperationResponse.getValue())));
    }

    Mono<Response<CertificateOperation>> createCertificateWithResponse(String certificateName, CertificatePolicy certificatePolicy, boolean enabled, Map<String, String> tags, Context context) {
        CertificateRequestParameters certificateRequestParameters = new CertificateRequestParameters().certificatePolicy(new CertificatePolicyRequest(certificatePolicy)).certificateAttributes(new CertificateRequestAttributes().enabled(enabled)).tags(tags);
        return this.service.createCertificate(this.vaultUrl, certificateName, this.apiVersion, ACCEPT_LANGUAGE, certificateRequestParameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<CertificateOperation, KeyVaultCertificateWithPolicy> getCertificateOperation(String certificateName) {
        return new PollerFlux(this.getDefaultPollingInterval(), pollingContext -> Mono.empty(), this.createPollOperation(certificateName), this.cancelOperation(certificateName), this.fetchResultOperation(certificateName));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultCertificateWithPolicy> getCertificate(String certificateName) {
        try {
            return FluxUtil.withContext(context -> this.getCertificateWithResponse(certificateName, "", (Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultCertificateWithPolicy>> getCertificateWithResponse(String certificateName) {
        try {
            return FluxUtil.withContext(context -> this.getCertificateWithResponse(certificateName, "", (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<KeyVaultCertificateWithPolicy>> getCertificateWithResponse(String certificateName, String version, Context context) {
        context = context == null ? Context.NONE : context;
        return this.service.getCertificateWithPolicy(this.vaultUrl, certificateName, version, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Retrieving certificate - {}", new Object[]{certificateName})).doOnSuccess(response -> this.logger.verbose("Retrieved the certificate - {}", new Object[]{((KeyVaultCertificateWithPolicy)response.getValue()).getProperties().getName()})).doOnError(error -> this.logger.warning("Failed to Retrieve the certificate - {}", new Object[]{certificateName, error}));
    }

    Mono<Response<KeyVaultCertificate>> getCertificateVersionWithResponse(String certificateName, String version, Context context) {
        context = context == null ? Context.NONE : context;
        return this.service.getCertificate(this.vaultUrl, certificateName, version, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> this.logger.verbose("Retrieving certificate - {}", new Object[]{certificateName})).doOnSuccess(response -> this.logger.verbose("Retrieved the certificate - {}", new Object[]{((KeyVaultCertificate)response.getValue()).getProperties().getName()})).doOnError(error -> this.logger.warning("Failed to Retrieve the certificate - {}", new Object[]{certificateName, error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultCertificate>> getCertificateVersionWithResponse(String certificateName, String version) {
        try {
            return FluxUtil.withContext(context -> this.getCertificateVersionWithResponse(certificateName, version == null ? "" : version, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultCertificate> getCertificateVersion(String certificateName, String version) {
        try {
            return FluxUtil.withContext(context -> this.getCertificateVersionWithResponse(certificateName, version == null ? "" : version, (Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultCertificate> updateCertificateProperties(CertificateProperties properties) {
        try {
            return FluxUtil.withContext(context -> this.updateCertificatePropertiesWithResponse(properties, (Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultCertificate>> updateCertificatePropertiesWithResponse(CertificateProperties properties) {
        try {
            return FluxUtil.withContext(context -> this.updateCertificatePropertiesWithResponse(properties, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<KeyVaultCertificate>> updateCertificatePropertiesWithResponse(CertificateProperties properties, Context context) {
        context = context == null ? Context.NONE : context;
        Objects.requireNonNull(properties, "properties' cannot be null.");
        CertificateUpdateParameters parameters = new CertificateUpdateParameters().tags(properties.getTags()).certificateAttributes(new CertificateRequestAttributes(properties));
        return this.service.updateCertificate(this.vaultUrl, properties.getName(), properties.getVersion(), this.apiVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Updating certificate - {}", new Object[]{properties.getName()})).doOnSuccess(response -> this.logger.verbose("Updated the certificate - {}", new Object[]{properties.getName()})).doOnError(error -> this.logger.warning("Failed to update the certificate - {}", new Object[]{properties.getName(), error}));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DeletedCertificate, Void> beginDeleteCertificate(String certificateName) {
        return new PollerFlux(this.getDefaultPollingInterval(), this.activationOperation(certificateName), this.createDeletePollOperation(certificateName), (context, firstResponse) -> Mono.empty(), context -> Mono.empty());
    }

    private Function<PollingContext<DeletedCertificate>, Mono<DeletedCertificate>> activationOperation(String certificateName) {
        return pollingContext -> FluxUtil.withContext(context -> this.deleteCertificateWithResponse(certificateName, (Context)context)).flatMap(deletedCertificateResponse -> Mono.just((Object)((DeletedCertificate)deletedCertificateResponse.getValue())));
    }

    private Function<PollingContext<DeletedCertificate>, Mono<PollResponse<DeletedCertificate>>> createDeletePollOperation(String keyName) {
        return pollingContext -> FluxUtil.withContext(context -> this.service.getDeletedCertificatePoller(this.vaultUrl, keyName, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE))).flatMap(deletedCertificateResponse -> {
            if (deletedCertificateResponse.getStatusCode() == 404) {
                return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((DeletedCertificate)pollingContext.getLatestResponse().getValue()))));
            }
            if (deletedCertificateResponse.getStatusCode() == 403) {
                return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedCertificate)pollingContext.getLatestResponse().getValue()))));
            }
            return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedCertificate)deletedCertificateResponse.getValue()))));
        }).onErrorReturn((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedCertificate)pollingContext.getLatestResponse().getValue())));
    }

    Mono<Response<DeletedCertificate>> deleteCertificateWithResponse(String certificateName, Context context) {
        return this.service.deleteCertificate(this.vaultUrl, certificateName, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Deleting certificate - {}", new Object[]{certificateName})).doOnSuccess(response -> this.logger.verbose("Deleted the certificate - {}", new Object[]{((DeletedCertificate)response.getValue()).getProperties().getName()})).doOnError(error -> this.logger.warning("Failed to delete the certificate - {}", new Object[]{certificateName, error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeletedCertificate> getDeletedCertificate(String certificateName) {
        try {
            return FluxUtil.withContext(context -> this.getDeletedCertificateWithResponse(certificateName, (Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeletedCertificate>> getDeletedCertificateWithResponse(String certificateName) {
        try {
            return FluxUtil.withContext(context -> this.getDeletedCertificateWithResponse(certificateName, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<DeletedCertificate>> getDeletedCertificateWithResponse(String certificateName, Context context) {
        context = context == null ? Context.NONE : context;
        return this.service.getDeletedCertificate(this.vaultUrl, certificateName, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Retrieving deleted certificate - {}", new Object[]{certificateName})).doOnSuccess(response -> this.logger.verbose("Retrieved the deleted certificate - {}", new Object[]{((DeletedCertificate)response.getValue()).getProperties().getName()})).doOnError(error -> this.logger.warning("Failed to Retrieve the deleted certificate - {}", new Object[]{certificateName, error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> purgeDeletedCertificate(String certificateName) {
        try {
            return this.purgeDeletedCertificateWithResponse(certificateName).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> purgeDeletedCertificateWithResponse(String certificateName) {
        try {
            return FluxUtil.withContext(context -> this.purgeDeletedCertificateWithResponse(certificateName, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> purgeDeletedCertificateWithResponse(String certificateName, Context context) {
        context = context == null ? Context.NONE : context;
        return this.service.purgeDeletedcertificate(this.vaultUrl, certificateName, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Purging certificate - {}", new Object[]{certificateName})).doOnSuccess(response -> this.logger.verbose("Purged the certificate - {}", new Object[]{response.getStatusCode()})).doOnError(error -> this.logger.warning("Failed to purge the certificate - {}", new Object[]{certificateName, error}));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<KeyVaultCertificateWithPolicy, Void> beginRecoverDeletedCertificate(String certificateName) {
        return new PollerFlux(this.getDefaultPollingInterval(), this.recoverActivationOperation(certificateName), this.createRecoverPollOperation(certificateName), (context, firstResponse) -> Mono.empty(), context -> Mono.empty());
    }

    private Function<PollingContext<KeyVaultCertificateWithPolicy>, Mono<KeyVaultCertificateWithPolicy>> recoverActivationOperation(String certificateName) {
        return pollingContext -> FluxUtil.withContext(context -> this.recoverDeletedCertificateWithResponse(certificateName, (Context)context)).flatMap(certificateResponse -> Mono.just((Object)((KeyVaultCertificateWithPolicy)certificateResponse.getValue())));
    }

    private Function<PollingContext<KeyVaultCertificateWithPolicy>, Mono<PollResponse<KeyVaultCertificateWithPolicy>>> createRecoverPollOperation(String keyName) {
        return pollingContext -> FluxUtil.withContext(context -> this.service.getCertificatePoller(this.vaultUrl, keyName, "", this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE))).flatMap(certificateResponse -> {
            if (certificateResponse.getStatusCode() == 404) {
                return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((KeyVaultCertificateWithPolicy)pollingContext.getLatestResponse().getValue()))));
            }
            if (certificateResponse.getStatusCode() == 403) {
                return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultCertificateWithPolicy)pollingContext.getLatestResponse().getValue()))));
            }
            return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultCertificateWithPolicy)certificateResponse.getValue()))));
        }).onErrorReturn((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultCertificateWithPolicy)pollingContext.getLatestResponse().getValue())));
    }

    Mono<Response<KeyVaultCertificateWithPolicy>> recoverDeletedCertificateWithResponse(String certificateName, Context context) {
        return this.service.recoverDeletedCertificate(this.vaultUrl, certificateName, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Recovering deleted certificate - {}", new Object[]{certificateName})).doOnSuccess(response -> this.logger.verbose("Recovered the deleted certificate - {}", new Object[]{((KeyVaultCertificateWithPolicy)response.getValue()).getProperties().getName()})).doOnError(error -> this.logger.warning("Failed to recover the deleted certificate - {}", new Object[]{certificateName, error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<byte[]> backupCertificate(String certificateName) {
        try {
            return FluxUtil.withContext(context -> this.backupCertificateWithResponse(certificateName, (Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<byte[]>> backupCertificateWithResponse(String certificateName) {
        try {
            return FluxUtil.withContext(context -> this.backupCertificateWithResponse(certificateName, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<byte[]>> backupCertificateWithResponse(String certificateName, Context context) {
        context = context == null ? Context.NONE : context;
        return this.service.backupCertificate(this.vaultUrl, certificateName, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Backing up certificate - {}", new Object[]{certificateName})).doOnSuccess(response -> this.logger.verbose("Backed up the certificate - {}", new Object[]{response.getStatusCode()})).doOnError(error -> this.logger.warning("Failed to back up the certificate - {}", new Object[]{certificateName, error})).flatMap(certificateBackupResponse -> Mono.just((Object)new SimpleResponse(certificateBackupResponse.getRequest(), certificateBackupResponse.getStatusCode(), certificateBackupResponse.getHeaders(), (Object)((CertificateBackup)certificateBackupResponse.getValue()).getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultCertificateWithPolicy> restoreCertificateBackup(byte[] backup) {
        try {
            return FluxUtil.withContext(context -> this.restoreCertificateBackupWithResponse(backup, (Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultCertificateWithPolicy>> restoreCertificateBackupWithResponse(byte[] backup) {
        try {
            return FluxUtil.withContext(context -> this.restoreCertificateBackupWithResponse(backup, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<KeyVaultCertificateWithPolicy>> restoreCertificateBackupWithResponse(byte[] backup, Context context) {
        context = context == null ? Context.NONE : context;
        CertificateRestoreParameters parameters = new CertificateRestoreParameters().certificateBundleBackup(backup);
        return this.service.restoreCertificate(this.vaultUrl, this.apiVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Restoring the certificate")).doOnSuccess(response -> this.logger.verbose("Restored the certificate - {}", new Object[]{((KeyVaultCertificateWithPolicy)response.getValue()).getProperties().getName()})).doOnError(error -> this.logger.warning("Failed to restore the certificate - {}", new Object[]{error}));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CertificateProperties> listPropertiesOfCertificates(boolean includePending) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listCertificatesFirstPage(includePending, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listCertificatesNextPage((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CertificateProperties> listPropertiesOfCertificates() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listCertificatesFirstPage(false, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listCertificatesNextPage((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<CertificateProperties> listPropertiesOfCertificates(boolean includePending, Context context) {
        return new PagedFlux(() -> this.listCertificatesFirstPage(includePending, context), continuationToken -> this.listCertificatesNextPage((String)continuationToken, context));
    }

    private Mono<PagedResponse<CertificateProperties>> listCertificatesNextPage(String continuationToken, Context context) {
        try {
            return this.service.getCertificates(this.vaultUrl, continuationToken, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing next certificates page - Page {} ", new Object[]{continuationToken})).doOnSuccess(response -> this.logger.verbose("Listed next certificates page - Page {} ", new Object[]{continuationToken})).doOnError(error -> this.logger.warning("Failed to list next certificates page - Page {} ", new Object[]{continuationToken, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<PagedResponse<CertificateProperties>> listCertificatesFirstPage(boolean includePending, Context context) {
        try {
            return this.service.getCertificates(this.vaultUrl, 25, includePending, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing certificates")).doOnSuccess(response -> this.logger.verbose("Listed certificates")).doOnError(error -> this.logger.warning("Failed to list certificates", new Object[]{error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeletedCertificate> listDeletedCertificates() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listDeletedCertificatesFirstPage(false, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listDeletedCertificatesNextPage((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeletedCertificate> listDeletedCertificates(boolean includePending) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listDeletedCertificatesFirstPage(includePending, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listDeletedCertificatesNextPage((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<DeletedCertificate> listDeletedCertificates(Boolean includePending, Context context) {
        return new PagedFlux(() -> this.listDeletedCertificatesFirstPage(includePending, context), continuationToken -> this.listDeletedCertificatesNextPage((String)continuationToken, context));
    }

    private Mono<PagedResponse<DeletedCertificate>> listDeletedCertificatesNextPage(String continuationToken, Context context) {
        try {
            return this.service.getDeletedCertificates(this.vaultUrl, continuationToken, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing next deleted certificates page - Page {} ", new Object[]{continuationToken})).doOnSuccess(response -> this.logger.verbose("Listed next deleted certificates page - Page {} ", new Object[]{continuationToken})).doOnError(error -> this.logger.warning("Failed to list next deleted certificates page - Page {} ", new Object[]{continuationToken, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<PagedResponse<DeletedCertificate>> listDeletedCertificatesFirstPage(boolean includePending, Context context) {
        try {
            return this.service.getDeletedCertificates(this.vaultUrl, 25, includePending, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing deleted certificates")).doOnSuccess(response -> this.logger.verbose("Listed deleted certificates")).doOnError(error -> this.logger.warning("Failed to list deleted certificates", new Object[]{error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CertificateProperties> listPropertiesOfCertificateVersions(String certificateName) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listCertificateVersionsFirstPage(certificateName, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listCertificateVersionsNextPage((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<CertificateProperties> listPropertiesOfCertificateVersions(String certificateName, Context context) {
        return new PagedFlux(() -> this.listCertificateVersionsFirstPage(certificateName, context), continuationToken -> this.listCertificateVersionsNextPage((String)continuationToken, context));
    }

    private Mono<PagedResponse<CertificateProperties>> listCertificateVersionsFirstPage(String certificateName, Context context) {
        try {
            return this.service.getCertificateVersions(this.vaultUrl, certificateName, 25, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing certificate versions - {}", new Object[]{certificateName})).doOnSuccess(response -> this.logger.verbose("Listed certificate versions - {}", new Object[]{certificateName})).doOnError(error -> this.logger.warning("Failed to list certificate versions - {}", new Object[]{certificateName, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<PagedResponse<CertificateProperties>> listCertificateVersionsNextPage(String continuationToken, Context context) {
        try {
            return this.service.getCertificates(this.vaultUrl, continuationToken, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing next certificate versions page - Page {} ", new Object[]{continuationToken})).doOnSuccess(response -> this.logger.verbose("Listed next certificate versions page - Page {} ", new Object[]{continuationToken})).doOnError(error -> this.logger.warning("Failed to list next certificate versions page - Page {} ", new Object[]{continuationToken, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultCertificate> mergeCertificate(MergeCertificateOptions mergeCertificateOptions) {
        try {
            return FluxUtil.withContext(context -> this.mergeCertificateWithResponse(mergeCertificateOptions, (Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultCertificateWithPolicy>> mergeCertificateWithResponse(MergeCertificateOptions mergeCertificateOptions) {
        try {
            return FluxUtil.withContext(context -> this.mergeCertificateWithResponse(mergeCertificateOptions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<KeyVaultCertificateWithPolicy>> mergeCertificateWithResponse(MergeCertificateOptions mergeCertificateOptions, Context context) {
        context = context == null ? Context.NONE : context;
        Objects.requireNonNull(mergeCertificateOptions, "'mergeCertificateOptions' cannot be null.");
        CertificateMergeParameters mergeParameters = new CertificateMergeParameters().x509Certificates(mergeCertificateOptions.getX509Certificates()).tags(mergeCertificateOptions.getTags()).certificateAttributes(new CertificateRequestAttributes().enabled(mergeCertificateOptions.isEnabled()));
        return this.service.mergeCertificate(this.vaultUrl, mergeCertificateOptions.getName(), this.apiVersion, ACCEPT_LANGUAGE, mergeParameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Merging certificate - {}", new Object[]{mergeCertificateOptions.getName()})).doOnSuccess(response -> this.logger.verbose("Merged certificate  - {}", new Object[]{((KeyVaultCertificateWithPolicy)response.getValue()).getProperties().getName()})).doOnError(error -> this.logger.warning("Failed to merge certificate - {}", new Object[]{mergeCertificateOptions.getName(), error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificatePolicy> getCertificatePolicy(String certificateName) {
        try {
            return FluxUtil.withContext(context -> this.getCertificatePolicyWithResponse(certificateName, (Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificatePolicy>> getCertificatePolicyWithResponse(String certificateName) {
        try {
            return FluxUtil.withContext(context -> this.getCertificatePolicyWithResponse(certificateName, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<CertificatePolicy>> getCertificatePolicyWithResponse(String certificateName, Context context) {
        context = context == null ? Context.NONE : context;
        return this.service.getCertificatePolicy(this.vaultUrl, this.apiVersion, ACCEPT_LANGUAGE, certificateName, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Retrieving certificate policy - {}", new Object[]{certificateName})).doOnSuccess(response -> this.logger.verbose("Retrieved certificate policy - {}", new Object[]{certificateName})).doOnError(error -> this.logger.warning("Failed to retrieve certificate policy - {}", new Object[]{certificateName, error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificatePolicy> updateCertificatePolicy(String certificateName, CertificatePolicy policy) {
        try {
            return FluxUtil.withContext(context -> this.updateCertificatePolicyWithResponse(certificateName, policy, (Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificatePolicy>> updateCertificatePolicyWithResponse(String certificateName, CertificatePolicy policy) {
        try {
            return FluxUtil.withContext(context -> this.updateCertificatePolicyWithResponse(certificateName, policy, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<CertificatePolicy>> updateCertificatePolicyWithResponse(String certificateName, CertificatePolicy policy, Context context) {
        context = context == null ? Context.NONE : context;
        CertificatePolicyRequest policyRequest = new CertificatePolicyRequest(policy);
        return this.service.updateCertificatePolicy(this.vaultUrl, this.apiVersion, ACCEPT_LANGUAGE, certificateName, policyRequest, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Updating certificate policy - {}", new Object[]{certificateName})).doOnSuccess(response -> this.logger.verbose("Updated the certificate policy - {}", new Object[]{((CertificatePolicy)response.getValue()).getUpdatedOn()})).doOnError(error -> this.logger.warning("Failed to update the certificate policy - {}", new Object[]{certificateName, error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateIssuer> createIssuer(CertificateIssuer issuer) {
        try {
            return FluxUtil.withContext(context -> this.createIssuerWithResponse(issuer, (Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateIssuer>> createIssuerWithResponse(CertificateIssuer issuer) {
        try {
            return FluxUtil.withContext(context -> this.createIssuerWithResponse(issuer, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<CertificateIssuer>> createIssuerWithResponse(CertificateIssuer issuer, Context context) {
        context = context == null ? Context.NONE : context;
        CertificateIssuerSetParameters parameters = new CertificateIssuerSetParameters().provider(issuer.getProvider()).credentials(new IssuerCredentials().accountId(issuer.getAccountId()).password(issuer.getPassword())).organizationDetails(new OrganizationDetails().adminDetails(issuer.getAdministratorContacts())).credentials(new IssuerCredentials().password(issuer.getPassword()).accountId(issuer.getAccountId()));
        return this.service.setCertificateIssuer(this.vaultUrl, this.apiVersion, ACCEPT_LANGUAGE, issuer.getName(), parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Creating certificate issuer - {}", new Object[]{issuer.getName()})).doOnSuccess(response -> this.logger.verbose("Created the certificate issuer - {}", new Object[]{((CertificateIssuer)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to create the certificate issuer - {}", new Object[]{issuer.getName(), error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateIssuer>> getIssuerWithResponse(String issuerName) {
        try {
            return FluxUtil.withContext(context -> this.getIssuerWithResponse(issuerName, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateIssuer> getIssuer(String issuerName) {
        try {
            return FluxUtil.withContext(context -> this.getIssuerWithResponse(issuerName, (Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<CertificateIssuer>> getIssuerWithResponse(String issuerName, Context context) {
        context = context == null ? Context.NONE : context;
        return this.service.getCertificateIssuer(this.vaultUrl, this.apiVersion, ACCEPT_LANGUAGE, issuerName, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Retrieving certificate issuer - {}", new Object[]{issuerName})).doOnSuccess(response -> this.logger.verbose("Retrieved the certificate issuer - {}", new Object[]{((CertificateIssuer)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to retreive the certificate issuer - {}", new Object[]{issuerName, error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateIssuer>> deleteIssuerWithResponse(String issuerName) {
        try {
            return FluxUtil.withContext(context -> this.deleteIssuerWithResponse(issuerName, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateIssuer> deleteIssuer(String issuerName) {
        try {
            return FluxUtil.withContext(context -> this.deleteIssuerWithResponse(issuerName, (Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<CertificateIssuer>> deleteIssuerWithResponse(String issuerName, Context context) {
        context = context == null ? Context.NONE : context;
        return this.service.deleteCertificateIssuer(this.vaultUrl, issuerName, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Deleting certificate issuer - {}", new Object[]{issuerName})).doOnSuccess(response -> this.logger.verbose("Deleted the certificate issuer - {}", new Object[]{((CertificateIssuer)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to delete the certificate issuer - {}", new Object[]{issuerName, error}));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<IssuerProperties> listPropertiesOfIssuers() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listPropertiesOfIssuersFirstPage((Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listPropertiesOfIssuersNextPage((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<IssuerProperties> listPropertiesOfIssuers(Context context) {
        return new PagedFlux(() -> this.listPropertiesOfIssuersFirstPage(context), continuationToken -> this.listPropertiesOfIssuersNextPage((String)continuationToken, context));
    }

    private Mono<PagedResponse<IssuerProperties>> listPropertiesOfIssuersFirstPage(Context context) {
        try {
            return this.service.getCertificateIssuers(this.vaultUrl, 25, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing certificate issuers - {}")).doOnSuccess(response -> this.logger.verbose("Listed certificate issuers - {}")).doOnError(error -> this.logger.warning("Failed to list certificate issuers - {}", new Object[]{error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<PagedResponse<IssuerProperties>> listPropertiesOfIssuersNextPage(String continuationToken, Context context) {
        try {
            return this.service.getCertificateIssuers(this.vaultUrl, continuationToken, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing next certificate issuers page - Page {} ", new Object[]{continuationToken})).doOnSuccess(response -> this.logger.verbose("Listed next certificate issuers page - Page {} ", new Object[]{continuationToken})).doOnError(error -> this.logger.warning("Failed to list next certificate issuers page - Page {} ", new Object[]{continuationToken, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateIssuer> updateIssuer(CertificateIssuer issuer) {
        try {
            return FluxUtil.withContext(context -> this.updateIssuerWithResponse(issuer, (Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateIssuer>> updateIssuerWithResponse(CertificateIssuer issuer) {
        try {
            return FluxUtil.withContext(context -> this.updateIssuerWithResponse(issuer, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<CertificateIssuer>> updateIssuerWithResponse(CertificateIssuer issuer, Context context) {
        context = context == null ? Context.NONE : context;
        CertificateIssuerUpdateParameters updateParameters = new CertificateIssuerUpdateParameters().provider(issuer.getProvider()).organizationDetails(new OrganizationDetails().adminDetails(issuer.getAdministratorContacts())).credentials(new IssuerCredentials().password(issuer.getPassword()).accountId(issuer.getAccountId()));
        return this.service.updateCertificateIssuer(this.vaultUrl, issuer.getName(), this.apiVersion, ACCEPT_LANGUAGE, updateParameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Updating certificate issuer - {}", new Object[]{issuer.getName()})).doOnSuccess(response -> this.logger.verbose("Updated up the certificate issuer - {}", new Object[]{((CertificateIssuer)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to updated the certificate issuer - {}", new Object[]{issuer.getName(), error}));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CertificateContact> setContacts(List<CertificateContact> contacts) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.setCertificateContactsWithResponse(contacts, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<CertificateContact> setContacts(List<CertificateContact> contacts, Context context) {
        return new PagedFlux(() -> this.setCertificateContactsWithResponse(contacts, context));
    }

    private Mono<PagedResponse<CertificateContact>> setCertificateContactsWithResponse(List<CertificateContact> contacts, Context context) {
        Contacts contactsParams = new Contacts().contactList(contacts);
        return this.service.setCertificateContacts(this.vaultUrl, this.apiVersion, ACCEPT_LANGUAGE, contactsParams, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing certificate contacts - {}")).doOnSuccess(response -> this.logger.verbose("Listed certificate contacts - {}")).doOnError(error -> this.logger.warning("Failed to list certificate contacts - {}", new Object[]{error}));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CertificateContact> listContacts() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listCertificateContactsFirstPage((Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<CertificateContact> listContacts(Context context) {
        return new PagedFlux(() -> this.listCertificateContactsFirstPage(context));
    }

    private Mono<PagedResponse<CertificateContact>> listCertificateContactsFirstPage(Context context) {
        try {
            return this.service.getCertificateContacts(this.vaultUrl, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing certificate contacts - {}")).doOnSuccess(response -> this.logger.verbose("Listed certificate contacts - {}")).doOnError(error -> this.logger.warning("Failed to list certificate contacts - {}", new Object[]{error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CertificateContact> deleteContacts() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.deleteCertificateContactsWithResponse((Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<CertificateContact> deleteContacts(Context context) {
        return new PagedFlux(() -> this.deleteCertificateContactsWithResponse(context));
    }

    private Mono<PagedResponse<CertificateContact>> deleteCertificateContactsWithResponse(Context context) {
        return this.service.deleteCertificateContacts(this.vaultUrl, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Deleting certificate contacts - {}")).doOnSuccess(response -> this.logger.verbose("Deleted certificate contacts - {}")).doOnError(error -> this.logger.warning("Failed to delete certificate contacts - {}", new Object[]{error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateOperation> deleteCertificateOperation(String certificateName) {
        try {
            return FluxUtil.withContext(context -> this.deleteCertificateOperationWithResponse(certificateName, (Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateOperation>> deleteCertificateOperationWithResponse(String certificateName) {
        try {
            return FluxUtil.withContext(context -> this.deleteCertificateOperationWithResponse(certificateName, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<CertificateOperation>> deleteCertificateOperationWithResponse(String certificateName, Context context) {
        return this.service.deletetCertificateOperation(this.vaultUrl, certificateName, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Deleting certificate operation - {}", new Object[]{certificateName})).doOnSuccess(response -> this.logger.verbose("Deleted the certificate operation - {}", new Object[]{response.getStatusCode()})).doOnError(error -> this.logger.warning("Failed to delete the certificate operation - {}", new Object[]{certificateName, error}));
    }

    Mono<Response<CertificateOperation>> cancelCertificateOperationWithResponse(String certificateName, Context context) {
        context = context == null ? Context.NONE : context;
        CertificateOperationUpdateParameter parameter = new CertificateOperationUpdateParameter().cancellationRequested(true);
        return this.service.updateCertificateOperation(this.vaultUrl, certificateName, this.apiVersion, ACCEPT_LANGUAGE, parameter, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Cancelling certificate operation - {}", new Object[]{certificateName})).doOnSuccess(response -> this.logger.verbose("Cancelled the certificate operation - {}", new Object[]{((CertificateOperation)response.getValue()).getStatus()})).doOnError(error -> this.logger.warning("Failed to cancel the certificate operation - {}", new Object[]{certificateName, error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateOperation> cancelCertificateOperation(String certificateName) {
        try {
            return FluxUtil.withContext(context -> this.cancelCertificateOperationWithResponse(certificateName, (Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateOperation>> cancelCertificateOperationWithResponse(String certificateName) {
        try {
            return FluxUtil.withContext(context -> this.cancelCertificateOperationWithResponse(certificateName, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultCertificateWithPolicy> importCertificate(ImportCertificateOptions importCertificateOptions) {
        try {
            return FluxUtil.withContext(context -> this.importCertificateWithResponse(importCertificateOptions, (Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultCertificateWithPolicy>> importCertificateWithResponse(ImportCertificateOptions importCertificateOptions) {
        try {
            return FluxUtil.withContext(context -> this.importCertificateWithResponse(importCertificateOptions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<KeyVaultCertificateWithPolicy>> importCertificateWithResponse(ImportCertificateOptions importCertificateOptions, Context context) {
        context = context == null ? Context.NONE : context;
        CertificateImportParameters parameters = new CertificateImportParameters().base64EncodedCertificate(this.transformCertificateForImport(importCertificateOptions)).certificateAttributes(new CertificateRequestAttributes(importCertificateOptions)).password(importCertificateOptions.getPassword()).tags(importCertificateOptions.getTags());
        if (importCertificateOptions.getPolicy() != null) {
            parameters.certificatePolicy(new CertificatePolicyRequest(importCertificateOptions.getPolicy()));
        }
        return this.service.importCertificate(this.vaultUrl, importCertificateOptions.getName(), this.apiVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE));
    }

    private String transformCertificateForImport(ImportCertificateOptions options) {
        CertificateContentType contentType;
        CertificatePolicy policy = options.getPolicy();
        if (policy != null && (contentType = policy.getContentType()) != null && contentType.equals((Object)CertificateContentType.PEM)) {
            return new String(options.getCertificate(), StandardCharsets.US_ASCII);
        }
        return Base64.getEncoder().encodeToString(options.getCertificate());
    }
}

