/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates;

import com.azure.security.keyvault.certificates.models.CertificateKeyCurveName;
import com.azure.security.keyvault.certificates.models.CertificateKeyType;
import com.azure.security.keyvault.certificates.models.CertificatePolicy;
import com.fasterxml.jackson.annotation.JsonProperty;

class KeyProperties {
    @JsonProperty(value="exportable")
    private Boolean exportable;
    @JsonProperty(value="kty")
    private CertificateKeyType keyType;
    @JsonProperty(value="key_size")
    private Integer keySize;
    @JsonProperty(value="reuse_key")
    private Boolean reuseKey;
    @JsonProperty(value="crv")
    private CertificateKeyCurveName curve;

    KeyProperties(CertificatePolicy certificatePolicy) {
        this.curve = certificatePolicy.getKeyCurveName();
        this.exportable = certificatePolicy.isExportable();
        this.keySize = certificatePolicy.getKeySize();
        this.keyType = certificatePolicy.getKeyType();
        this.reuseKey = certificatePolicy.isKeyReusable();
    }

    Boolean exportable() {
        return this.exportable;
    }

    KeyProperties exportable(Boolean exportable) {
        this.exportable = exportable;
        return this;
    }

    CertificateKeyType keyType() {
        return this.keyType;
    }

    KeyProperties keyType(CertificateKeyType keyType) {
        this.keyType = keyType;
        return this;
    }

    Integer keySize() {
        return this.keySize;
    }

    KeyProperties keySize(Integer keySize) {
        this.keySize = keySize;
        return this;
    }

    Boolean reuseKey() {
        return this.reuseKey;
    }

    KeyProperties reuseKey(Boolean reuseKey) {
        this.reuseKey = reuseKey;
        return this;
    }

    CertificateKeyCurveName curve() {
        return this.curve;
    }

    KeyProperties curve(CertificateKeyCurveName curve) {
        this.curve = curve;
        return this;
    }
}

