/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.models;

import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.security.keyvault.certificates.models.CertificateProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;

public class KeyVaultCertificate {
    @JsonProperty(value="cer")
    byte[] cer;
    @JsonProperty(value="kid", access=JsonProperty.Access.WRITE_ONLY)
    String keyId;
    @JsonProperty(value="sid", access=JsonProperty.Access.WRITE_ONLY)
    String secretId;
    CertificateProperties properties;

    KeyVaultCertificate(String name) {
        this.properties = new CertificateProperties(name);
    }

    KeyVaultCertificate() {
        this.properties = new CertificateProperties();
    }

    public CertificateProperties getProperties() {
        return this.properties;
    }

    public KeyVaultCertificate setProperties(CertificateProperties properties) {
        Objects.requireNonNull(properties, "The certificate properties cannot be null");
        properties.name = this.properties.name;
        this.properties = properties;
        return this;
    }

    public String getId() {
        return this.properties.getId();
    }

    public String getName() {
        return this.properties.getName();
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public byte[] getCer() {
        return CoreUtils.clone((byte[])this.cer);
    }

    @JsonProperty(value="attributes")
    void unpackBaseAttributes(Map<String, Object> attributes) {
        this.properties.unpackBaseAttributes(attributes);
    }

    @JsonProperty(value="id")
    void unpackId(String id) {
        this.properties.unpackId(id);
    }

    @JsonProperty(value="tags")
    void unpackTags(Map<String, String> tags) {
        this.properties.tags = tags;
    }

    @JsonProperty(value="x5t")
    void unpackX5t(Base64Url base64Url) {
        this.properties.x509Thumbprint = base64Url;
    }
}

