// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator

package com.azure.security.keyvault.certificates;

import com.azure.security.keyvault.certificates.models.AdministratorContact;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/**
 * Details of the organization of the certificate issuer.
 */
class OrganizationDetails {
    /**
     * Id of the organization.
     */
    @JsonProperty(value = "id")
    private String id;

    /**
     * Details of the organization administrator.
     */
    @JsonProperty(value = "admin_details")
    private List<AdministratorContact> adminDetails;

    /**
     * Get the id value.
     *
     * @return the id value
     */
    String id() {
        return this.id;
    }

    /**
     * Set the id value.
     *
     * @param id the id value to set
     * @return the OrganizationDetails object itself.
     */
    OrganizationDetails id(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the adminDetails value.
     *
     * @return the adminDetails value
     */
    List<AdministratorContact> adminDetails() {
        return this.adminDetails;
    }

    /**
     * Set the adminDetails value.
     *
     * @param adminDetails the adminDetails value to set
     * @return the OrganizationDetails object itself.
     */
    OrganizationDetails adminDetails(List<AdministratorContact> adminDetails) {
        this.adminDetails = adminDetails;
        return this;
    }
}
