/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnValueWireType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.security.keyvault.certificates.implementation.CertificateBackup;
import com.azure.security.keyvault.certificates.implementation.CertificateImportParameters;
import com.azure.security.keyvault.certificates.implementation.CertificateIssuerSetParameters;
import com.azure.security.keyvault.certificates.implementation.CertificateIssuerUpdateParameters;
import com.azure.security.keyvault.certificates.implementation.CertificateMergeParameters;
import com.azure.security.keyvault.certificates.implementation.CertificateOperationUpdateParameter;
import com.azure.security.keyvault.certificates.implementation.CertificatePolicyRequest;
import com.azure.security.keyvault.certificates.implementation.CertificatePropertiesPage;
import com.azure.security.keyvault.certificates.implementation.CertificateRequestParameters;
import com.azure.security.keyvault.certificates.implementation.CertificateRestoreParameters;
import com.azure.security.keyvault.certificates.implementation.CertificateUpdateParameters;
import com.azure.security.keyvault.certificates.implementation.ContactPage;
import com.azure.security.keyvault.certificates.implementation.Contacts;
import com.azure.security.keyvault.certificates.implementation.DeletedCertificatePage;
import com.azure.security.keyvault.certificates.implementation.IssuerPropertiesPage;
import com.azure.security.keyvault.certificates.models.CertificateContact;
import com.azure.security.keyvault.certificates.models.CertificateIssuer;
import com.azure.security.keyvault.certificates.models.CertificateOperation;
import com.azure.security.keyvault.certificates.models.CertificatePolicy;
import com.azure.security.keyvault.certificates.models.CertificateProperties;
import com.azure.security.keyvault.certificates.models.DeletedCertificate;
import com.azure.security.keyvault.certificates.models.IssuerProperties;
import com.azure.security.keyvault.certificates.models.KeyVaultCertificate;
import com.azure.security.keyvault.certificates.models.KeyVaultCertificateWithPolicy;
import reactor.core.publisher.Mono;

@Host(value="{url}")
@ServiceInterface(name="KeyVault")
public interface CertificateService {
    @Post(value="certificates/{certificate-name}/create")
    @ExpectedResponses(value={202})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<CertificateOperation>> createCertificate(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @BodyParam(value="application/json") CertificateRequestParameters var5, @HeaderParam(value="Content-Type") String var6, Context var7);

    @Get(value="certificates/{certificate-name}/pending")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<CertificateOperation>> getCertificateOperation(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Patch(value="certificates/{certificate-name}/pending")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<CertificateOperation>> updateCertificateOperation(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @BodyParam(value="application/json") CertificateOperationUpdateParameter var5, @HeaderParam(value="Content-Type") String var6, Context var7);

    @Delete(value="certificates/{certificate-name}/pending")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<CertificateOperation>> deletetCertificateOperation(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Get(value="certificates/{certificate-name}/{certificate-version}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(code={403}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<KeyVaultCertificate>> getCertificate(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @PathParam(value="certificate-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

    @Get(value="certificates/{certificate-name}/{certificate-version}")
    @ExpectedResponses(value={200, 404, 403})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    public Mono<Response<KeyVaultCertificateWithPolicy>> getCertificatePoller(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @PathParam(value="certificate-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

    @Get(value="certificates/{certificate-name}/{certificate-version}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(code={403}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<KeyVaultCertificateWithPolicy>> getCertificateWithPolicy(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @PathParam(value="certificate-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

    @Get(value="certificates")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    @ReturnValueWireType(value=CertificatePropertiesPage.class)
    public Mono<PagedResponse<CertificateProperties>> getCertificates(@HostParam(value="url") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="includePending") Boolean var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

    @Get(value="{nextUrl}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    @ReturnValueWireType(value=CertificatePropertiesPage.class)
    public Mono<PagedResponse<CertificateProperties>> getCertificates(@HostParam(value="url") String var1, @PathParam(value="nextUrl", encoded=true) String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Content-Type") String var4, Context var5);

    @Delete(value="certificates/{certificate-name}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<DeletedCertificate>> deleteCertificate(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Patch(value="certificates/{certificate-name}/{certificate-version}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={500}, value=HttpResponseException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<KeyVaultCertificate>> updateCertificate(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @PathParam(value="certificate-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @BodyParam(value="application/json") CertificateUpdateParameters var6, @HeaderParam(value="Content-Type") String var7, Context var8);

    @Get(value="deletedcertificates/{certificate-name}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<DeletedCertificate>> getDeletedCertificate(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Get(value="deletedcertificates/{certificate-name}")
    @ExpectedResponses(value={200, 403, 404})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    public Mono<Response<DeletedCertificate>> getDeletedCertificatePoller(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Delete(value="deletedcertificates/{certificate-name}")
    @ExpectedResponses(value={204})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<Void>> purgeDeletedcertificate(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Post(value="deletedcertificates/{certificate-name}/recover")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<KeyVaultCertificateWithPolicy>> recoverDeletedCertificate(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Post(value="certificates/{certificate-name}/backup")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<CertificateBackup>> backupCertificate(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Post(value="certificates/restore")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<KeyVaultCertificateWithPolicy>> restoreCertificate(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept-language") String var3, @BodyParam(value="application/json") CertificateRestoreParameters var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Get(value="deletedcertificates")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    @ReturnValueWireType(value=DeletedCertificatePage.class)
    public Mono<PagedResponse<DeletedCertificate>> getDeletedCertificates(@HostParam(value="url") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="includePending") Boolean var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

    @Get(value="{nextUrl}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    @ReturnValueWireType(value=DeletedCertificatePage.class)
    public Mono<PagedResponse<DeletedCertificate>> getDeletedCertificates(@HostParam(value="url") String var1, @PathParam(value="nextUrl", encoded=true) String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Content-Type") String var4, Context var5);

    @Put(value="certificates/contacts")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    @ReturnValueWireType(value=ContactPage.class)
    public Mono<PagedResponse<CertificateContact>> setCertificateContacts(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept-language") String var3, @BodyParam(value="application/json") Contacts var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Get(value="certificates/contacts")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    @ReturnValueWireType(value=ContactPage.class)
    public Mono<PagedResponse<CertificateContact>> getCertificateContacts(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Content-Type") String var4, Context var5);

    @Delete(value="certificates/contacts")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    @ReturnValueWireType(value=ContactPage.class)
    public Mono<PagedResponse<CertificateContact>> deleteCertificateContacts(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Content-Type") String var4, Context var5);

    @Put(value="certificates/issuers/{issuer-name}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    public Mono<Response<CertificateIssuer>> setCertificateIssuer(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept-language") String var3, @PathParam(value="issuer-name") String var4, @BodyParam(value="application/json") CertificateIssuerSetParameters var5, @HeaderParam(value="Content-Type") String var6, Context var7);

    @Get(value="certificates/issuers/{issuer-name}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    public Mono<Response<CertificateIssuer>> getCertificateIssuer(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept-language") String var3, @PathParam(value="issuer-name") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Delete(value="certificates/issuers/{issuer-name}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<CertificateIssuer>> deleteCertificateIssuer(@HostParam(value="url") String var1, @PathParam(value="issuer-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Patch(value="certificates/issuers/{issuer-name}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={500}, value=HttpResponseException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<CertificateIssuer>> updateCertificateIssuer(@HostParam(value="url") String var1, @PathParam(value="issuer-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @BodyParam(value="application/json") CertificateIssuerUpdateParameters var5, @HeaderParam(value="Content-Type") String var6, Context var7);

    @Get(value="certificates/Issuers")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    @ReturnValueWireType(value=IssuerPropertiesPage.class)
    public Mono<PagedResponse<IssuerProperties>> getCertificateIssuers(@HostParam(value="url") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Get(value="{nextUrl}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    @ReturnValueWireType(value=IssuerPropertiesPage.class)
    public Mono<PagedResponse<IssuerProperties>> getCertificateIssuers(@HostParam(value="url") String var1, @PathParam(value="nextUrl", encoded=true) String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Content-Type") String var4, Context var5);

    @Get(value="certificates/{certificate-name}/versions")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    @ReturnValueWireType(value=CertificatePropertiesPage.class)
    public Mono<PagedResponse<CertificateProperties>> getCertificateVersions(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="maxresults") Integer var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

    @Post(value="certificates/{certificate-name}/import")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    public Mono<Response<KeyVaultCertificateWithPolicy>> importCertificate(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @BodyParam(value="application/json") CertificateImportParameters var5, @HeaderParam(value="Content-Type") String var6, Context var7);

    @Post(value="certificates/{certificate-name}/pending/merge")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    public Mono<Response<KeyVaultCertificateWithPolicy>> mergeCertificate(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @BodyParam(value="application/json") CertificateMergeParameters var5, @HeaderParam(value="Content-Type") String var6, Context var7);

    @Get(value="certificates/{certificate-name}/policy")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<CertificatePolicy>> getCertificatePolicy(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept-language") String var3, @PathParam(value="certificate-name") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Patch(value="certificates/{certificate-name}/policy")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<CertificatePolicy>> updateCertificatePolicy(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept-language") String var3, @PathParam(value="certificate-name") String var4, @BodyParam(value="application/json") CertificatePolicyRequest var5, @HeaderParam(value="Content-Type") String var6, Context var7);
}

