/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.certificates.models.CertificateOperationError;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public final class CertificateOperation {
    private final ClientLogger logger = new ClientLogger(CertificateOperation.class);
    private String vaultUrl;
    private String name;
    @JsonProperty(value="id", access=JsonProperty.Access.WRITE_ONLY)
    private String id;
    private String issuerName;
    private String certificateType;
    private boolean certificateTransparency;
    @JsonProperty(value="csr")
    private byte[] csr;
    @JsonProperty(value="cancellation_requested")
    private Boolean cancellationRequested;
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="status_details")
    private String statusDetails;
    @JsonProperty(value="error")
    private CertificateOperationError error;
    @JsonProperty(value="target")
    private String target;
    @JsonProperty(value="request_id")
    private String requestId;

    public String getId() {
        return this.id;
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    public String getCertificateType() {
        return this.certificateType;
    }

    public boolean isCertificateTransparent() {
        return this.certificateTransparency;
    }

    public byte[] getCsr() {
        return CoreUtils.clone((byte[])this.csr);
    }

    public Boolean getCancellationRequested() {
        return this.cancellationRequested;
    }

    public String getStatus() {
        return this.status;
    }

    public String getStatusDetails() {
        return this.statusDetails;
    }

    public CertificateOperationError getError() {
        return this.error;
    }

    public String getTarget() {
        return this.target;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    public String getName() {
        return this.name;
    }

    @JsonProperty(value="issuer")
    private void unpackIssuerParameters(Map<String, Object> issuerParameters) {
        this.issuerName = (String)issuerParameters.get("name");
        this.certificateType = (String)issuerParameters.get("cty");
        this.certificateTransparency = issuerParameters.get("cert_transparency") != null ? (Boolean)issuerParameters.get("cert_transparency") : false;
    }

    @JsonProperty(value="id")
    void unpackId(String id) {
        if (id != null && id.length() > 0) {
            this.id = id;
            try {
                URL url = new URL(id);
                String[] tokens = url.getPath().split("/");
                this.vaultUrl = tokens.length >= 2 ? tokens[1] : null;
                this.name = tokens.length >= 3 ? tokens[2] : null;
            }
            catch (MalformedURLException e) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The Azure Key Vault endpoint url is malformed.", e));
            }
        }
    }
}

