/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation;

import com.azure.security.keyvault.certificates.implementation.SubjectAlternativeNamesRequest;
import com.azure.security.keyvault.certificates.models.CertificateKeyUsage;
import com.azure.security.keyvault.certificates.models.CertificatePolicy;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class X509CertificateProperties {
    @JsonProperty(value="subject")
    private String subject;
    @JsonProperty(value="ekus")
    private List<String> ekus;
    @JsonProperty(value="sans")
    private SubjectAlternativeNamesRequest subjectAlternativeNamesRequest;
    @JsonProperty(value="key_usage")
    private List<CertificateKeyUsage> keyUsage;
    @JsonProperty(value="validity_months")
    private Integer validityInMonths;

    public X509CertificateProperties(CertificatePolicy certificatePolicy) {
        this.subject = certificatePolicy.getSubject();
        this.ekus = certificatePolicy.getEnhancedKeyUsage();
        this.keyUsage = certificatePolicy.getKeyUsage();
        this.subjectAlternativeNamesRequest = new SubjectAlternativeNamesRequest(certificatePolicy.getSubjectAlternativeNames());
        this.validityInMonths = certificatePolicy.getValidityInMonths();
    }

    public String subject() {
        return this.subject;
    }

    public X509CertificateProperties subject(String subject) {
        this.subject = subject;
        return this;
    }

    public List<String> ekus() {
        return this.ekus;
    }

    public X509CertificateProperties ekus(List<String> ekus) {
        this.ekus = ekus;
        return this;
    }

    public SubjectAlternativeNamesRequest subjectAlternativeNames() {
        return this.subjectAlternativeNamesRequest;
    }

    public X509CertificateProperties subjectAlternativeNames(SubjectAlternativeNamesRequest subjectAlternativeNamesRequest) {
        this.subjectAlternativeNamesRequest = subjectAlternativeNamesRequest;
        return this;
    }

    public List<CertificateKeyUsage> keyUsage() {
        return this.keyUsage;
    }

    public X509CertificateProperties keyUsage(List<CertificateKeyUsage> keyUsage) {
        this.keyUsage = keyUsage;
        return this;
    }

    public Integer validityInMonths() {
        return this.validityInMonths;
    }

    public X509CertificateProperties validityInMonths(Integer validityInMonths) {
        this.validityInMonths = validityInMonths;
        return this;
    }
}

