// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator

package com.azure.security.keyvault.certificates.models;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The contact information for the vault certificates.
 */
public final class CertificateContact {
    /**
     * Email address.
     */
    @JsonProperty(value = "email")
    private String email;

    /**
     * Name.
     */
    @JsonProperty(value = "name")
    private String name;

    /**
     * Phone number.
     */
    @JsonProperty(value = "phone")
    private String phone;

    /**
     * Get the email address.
     *
     * @return the email address
     */
    public String getEmail() {
        return this.email;
    }

    /**
     * Get the name.
     *
     * @return the name
     */
    public String getName() {
        return this.name;
    }

    /**
     * Get the phone info.
     *
     * @return the phone info
     */
    public String getPhone() {
        return this.phone;
    }

    /**
     * Set the email of the contact.
     * @param email the email of the contact to set
     * @return the updated CertificateContact object itself.
     */
    public CertificateContact setEmail(String email) {
        this.email = email;
        return this;
    }

    /**
     * Set the name of the contact.
     * @param name the name of the contact to set
     * @return the updated CertificateContact object itself.
     */
    public CertificateContact setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Set the phone of the contact.
     * @param phone the phone of the contact to set
     * @return the updated CertificateContact object itself.
     */
    public CertificateContact setPhone(String phone) {
        this.phone = phone;
        return this;
    }
}
