/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.models;

import com.azure.core.util.Base64Url;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;

public class CertificateProperties {
    private static final ClientLogger LOGGER = new ClientLogger(CertificateProperties.class);
    private String vaultUrl;
    private Boolean enabled;
    private OffsetDateTime notBefore;
    String version;
    private OffsetDateTime expiresOn;
    private OffsetDateTime createdOn;
    private OffsetDateTime updatedOn;
    private String recoveryLevel;
    String name;
    @JsonProperty(value="id", access=JsonProperty.Access.WRITE_ONLY)
    private String id;
    @JsonProperty(value="tags")
    Map<String, String> tags;
    @JsonProperty(value="x5t", access=JsonProperty.Access.WRITE_ONLY)
    Base64Url x509Thumbprint;
    @JsonProperty(value="recoverableDays", access=JsonProperty.Access.WRITE_ONLY)
    private Integer recoverableDays;

    CertificateProperties(String name) {
        this.name = name;
    }

    CertificateProperties() {
    }

    public String getId() {
        return this.id;
    }

    public OffsetDateTime getNotBefore() {
        return this.notBefore;
    }

    public Integer getRecoverableDays() {
        return this.recoverableDays;
    }

    public OffsetDateTime getExpiresOn() {
        return this.expiresOn;
    }

    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    public OffsetDateTime getUpdatedOn() {
        return this.updatedOn;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    public CertificateProperties setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getRecoveryLevel() {
        return this.recoveryLevel;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public CertificateProperties setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public byte[] getX509Thumbprint() {
        if (this.x509Thumbprint != null) {
            return this.x509Thumbprint.decodedBytes();
        }
        return null;
    }

    @JsonProperty(value="attributes")
    void unpackBaseAttributes(Map<String, Object> attributes) {
        this.enabled = (Boolean)attributes.get("enabled");
        this.notBefore = this.epochToOffsetDateTime(attributes.get("nbf"));
        this.expiresOn = this.epochToOffsetDateTime(attributes.get("exp"));
        this.createdOn = this.epochToOffsetDateTime(attributes.get("created"));
        this.updatedOn = this.epochToOffsetDateTime(attributes.get("updated"));
        this.recoveryLevel = (String)attributes.get("recoveryLevel");
        this.tags = (Map)this.lazyValueSelection(attributes.get("tags"), this.tags);
        this.recoverableDays = (Integer)attributes.get("recoverableDays");
        this.unpackId((String)attributes.get("id"));
    }

    private OffsetDateTime epochToOffsetDateTime(Object epochValue) {
        if (epochValue != null) {
            Instant instant = Instant.ofEpochMilli(((Number)epochValue).longValue() * 1000L);
            return OffsetDateTime.ofInstant(instant, ZoneOffset.UTC);
        }
        return null;
    }

    @JsonProperty(value="id")
    void unpackId(String id) {
        if (id != null && id.length() > 0) {
            this.id = id;
            try {
                URL url = new URL(id);
                String[] tokens = url.getPath().split("/");
                this.vaultUrl = tokens.length >= 2 ? tokens[1] : null;
                this.name = tokens.length >= 3 ? tokens[2] : null;
                this.version = tokens.length >= 4 ? tokens[3] : null;
            }
            catch (MalformedURLException e) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("The Azure Key Vault endpoint url is malformed.", e));
            }
        }
    }

    private Object lazyValueSelection(Object input1, Object input2) {
        if (input1 == null) {
            return input2;
        }
        return input1;
    }
}

