/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation;

import com.azure.security.keyvault.certificates.models.CertificateKeyCurveName;
import com.azure.security.keyvault.certificates.models.CertificateKeyType;
import com.azure.security.keyvault.certificates.models.CertificatePolicy;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class KeyProperties {
    @JsonProperty(value="exportable")
    private Boolean exportable;
    @JsonProperty(value="kty")
    private CertificateKeyType keyType;
    @JsonProperty(value="key_size")
    private Integer keySize;
    @JsonProperty(value="reuse_key")
    private Boolean reuseKey;
    @JsonProperty(value="crv")
    private CertificateKeyCurveName curve;

    public KeyProperties(CertificatePolicy certificatePolicy) {
        this.curve = certificatePolicy.getKeyCurveName();
        this.exportable = certificatePolicy.isExportable();
        this.keySize = certificatePolicy.getKeySize();
        this.keyType = certificatePolicy.getKeyType();
        this.reuseKey = certificatePolicy.isKeyReusable();
    }

    public Boolean exportable() {
        return this.exportable;
    }

    public KeyProperties exportable(Boolean exportable) {
        this.exportable = exportable;
        return this;
    }

    public CertificateKeyType keyType() {
        return this.keyType;
    }

    public KeyProperties keyType(CertificateKeyType keyType) {
        this.keyType = keyType;
        return this;
    }

    public Integer keySize() {
        return this.keySize;
    }

    public KeyProperties keySize(Integer keySize) {
        this.keySize = keySize;
        return this;
    }

    public Boolean reuseKey() {
        return this.reuseKey;
    }

    public KeyProperties reuseKey(Boolean reuseKey) {
        this.reuseKey = reuseKey;
        return this;
    }

    public CertificateKeyCurveName curve() {
        return this.curve;
    }

    public KeyProperties curve(CertificateKeyCurveName curve) {
        this.curve = curve;
        return this;
    }
}

