/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnValueWireType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import com.azure.security.keyvault.certificates.CertificateAsyncClient;
import com.azure.security.keyvault.certificates.CertificateServiceVersion;
import com.azure.security.keyvault.certificates.implementation.CertificateBackup;
import com.azure.security.keyvault.certificates.implementation.CertificateImportParameters;
import com.azure.security.keyvault.certificates.implementation.CertificateIssuerSetParameters;
import com.azure.security.keyvault.certificates.implementation.CertificateIssuerUpdateParameters;
import com.azure.security.keyvault.certificates.implementation.CertificateMergeParameters;
import com.azure.security.keyvault.certificates.implementation.CertificateOperationUpdateParameter;
import com.azure.security.keyvault.certificates.implementation.CertificatePolicyRequest;
import com.azure.security.keyvault.certificates.implementation.CertificatePropertiesPage;
import com.azure.security.keyvault.certificates.implementation.CertificateRequestAttributes;
import com.azure.security.keyvault.certificates.implementation.CertificateRequestParameters;
import com.azure.security.keyvault.certificates.implementation.CertificateRestoreParameters;
import com.azure.security.keyvault.certificates.implementation.CertificateUpdateParameters;
import com.azure.security.keyvault.certificates.implementation.ContactPage;
import com.azure.security.keyvault.certificates.implementation.Contacts;
import com.azure.security.keyvault.certificates.implementation.DeletedCertificatePage;
import com.azure.security.keyvault.certificates.implementation.IssuerAttributes;
import com.azure.security.keyvault.certificates.implementation.IssuerCredentials;
import com.azure.security.keyvault.certificates.implementation.IssuerPropertiesPage;
import com.azure.security.keyvault.certificates.implementation.OrganizationDetails;
import com.azure.security.keyvault.certificates.models.CertificateContact;
import com.azure.security.keyvault.certificates.models.CertificateContentType;
import com.azure.security.keyvault.certificates.models.CertificateIssuer;
import com.azure.security.keyvault.certificates.models.CertificateOperation;
import com.azure.security.keyvault.certificates.models.CertificatePolicy;
import com.azure.security.keyvault.certificates.models.CertificateProperties;
import com.azure.security.keyvault.certificates.models.DeletedCertificate;
import com.azure.security.keyvault.certificates.models.ImportCertificateOptions;
import com.azure.security.keyvault.certificates.models.IssuerProperties;
import com.azure.security.keyvault.certificates.models.KeyVaultCertificate;
import com.azure.security.keyvault.certificates.models.KeyVaultCertificateWithPolicy;
import com.azure.security.keyvault.certificates.models.MergeCertificateOptions;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public class CertificateClientImpl {
    private static final ClientLogger LOGGER = new ClientLogger(CertificateAsyncClient.class);
    private static final Duration DEFAULT_POLLING_INTERVAL = Duration.ofSeconds(1L);
    private static final String HTTP_REST_PROXY_SYNC_PROXY_ENABLE = "com.azure.core.http.restproxy.syncproxy.enable";
    private final CertificateService service;
    private final HttpPipeline pipeline;
    private final String apiVersion;
    private final String vaultUrl;
    static final int DEFAULT_MAX_PAGE_RESULTS = 25;
    static final String ACCEPT_LANGUAGE = "en-US";
    static final String CONTENT_TYPE_HEADER_VALUE = "application/json";

    public CertificateClientImpl(String vaultUrl, HttpPipeline pipeline, CertificateServiceVersion version) {
        Objects.requireNonNull(vaultUrl, "Azure Key Vault endpoint url is required.");
        this.vaultUrl = vaultUrl;
        this.service = (CertificateService)RestProxy.create(CertificateService.class, (HttpPipeline)pipeline);
        this.pipeline = pipeline;
        this.apiVersion = version.getVersion();
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    public HttpPipeline getHttpPipeline() {
        return this.pipeline;
    }

    public Duration getDefaultPollingInterval() {
        return DEFAULT_POLLING_INTERVAL;
    }

    public PollerFlux<CertificateOperation, KeyVaultCertificateWithPolicy> beginCreateCertificate(String certificateName, CertificatePolicy policy, Boolean isEnabled, Map<String, String> tags) {
        return new PollerFlux(this.getDefaultPollingInterval(), this.activationOperation(certificateName, policy, isEnabled, tags), this.createPollOperation(certificateName), this.cancelOperation(certificateName), this.fetchResultOperation(certificateName));
    }

    private BiFunction<PollingContext<CertificateOperation>, PollResponse<CertificateOperation>, Mono<CertificateOperation>> cancelOperation(String certificateName) {
        return (pollingContext, firstResponse) -> FluxUtil.withContext(context -> this.cancelCertificateOperationWithResponseAsync(certificateName, (Context)context)).flatMap(FluxUtil::toMono);
    }

    private Function<PollingContext<CertificateOperation>, Mono<CertificateOperation>> activationOperation(String certificateName, CertificatePolicy policy, boolean enabled, Map<String, String> tags) {
        return pollingContext -> FluxUtil.withContext(context -> this.createCertificateWithResponseAsync(certificateName, policy, enabled, tags, (Context)context)).flatMap(certificateOperationResponse -> Mono.just((Object)((CertificateOperation)certificateOperationResponse.getValue())));
    }

    private Function<PollingContext<CertificateOperation>, Mono<KeyVaultCertificateWithPolicy>> fetchResultOperation(String certificateName) {
        return pollingContext -> FluxUtil.withContext(context -> this.getCertificateWithResponseAsync(certificateName, "", (Context)context)).flatMap(certificateResponse -> Mono.just((Object)((KeyVaultCertificateWithPolicy)certificateResponse.getValue())));
    }

    private Function<PollingContext<CertificateOperation>, Mono<PollResponse<CertificateOperation>>> createPollOperation(String certificateName) {
        return pollingContext -> {
            try {
                return FluxUtil.withContext(context -> this.service.getCertificateOperationAsync(this.vaultUrl, certificateName, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, (Context)context)).flatMap(this::processCertificateOperationResponse);
            }
            catch (HttpResponseException e) {
                LOGGER.logExceptionAsError((RuntimeException)((Object)e));
                return Mono.just((Object)new PollResponse(LongRunningOperationStatus.FAILED, null));
            }
        };
    }

    private Mono<PollResponse<CertificateOperation>> processCertificateOperationResponse(Response<CertificateOperation> certificateOperationResponse) {
        LongRunningOperationStatus status = null;
        switch (((CertificateOperation)certificateOperationResponse.getValue()).getStatus()) {
            case "inProgress": {
                status = LongRunningOperationStatus.IN_PROGRESS;
                break;
            }
            case "completed": {
                status = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                break;
            }
            case "failed": {
                status = LongRunningOperationStatus.FAILED;
                break;
            }
            default: {
                status = LongRunningOperationStatus.fromString((String)((CertificateOperation)certificateOperationResponse.getValue()).getStatus(), (boolean)true);
            }
        }
        return Mono.just((Object)new PollResponse(status, (Object)((CertificateOperation)certificateOperationResponse.getValue())));
    }

    public Mono<Response<CertificateOperation>> cancelCertificateOperationWithResponseAsync(String certificateName, Context context) {
        CertificateOperationUpdateParameter parameter = new CertificateOperationUpdateParameter().cancellationRequested(true);
        context = context == null ? Context.NONE : context;
        return this.service.updateCertificateOperationAsync(this.vaultUrl, certificateName, this.apiVersion, ACCEPT_LANGUAGE, parameter, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Cancelling certificate operation - {}", new Object[]{certificateName})).doOnSuccess(response -> LOGGER.verbose("Cancelled the certificate operation - {}", new Object[]{((CertificateOperation)response.getValue()).getStatus()})).doOnError(error -> LOGGER.warning("Failed to cancel the certificate operation - {}", new Object[]{certificateName, error}));
    }

    public Response<CertificateOperation> cancelCertificateOperationWithResponse(String certificateName, Context context) {
        CertificateOperationUpdateParameter parameter = new CertificateOperationUpdateParameter().cancellationRequested(true);
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.updateCertificateOperation(this.vaultUrl, certificateName, this.apiVersion, ACCEPT_LANGUAGE, parameter, CONTENT_TYPE_HEADER_VALUE, context);
    }

    private Mono<Response<CertificateOperation>> createCertificateWithResponseAsync(String certificateName, CertificatePolicy certificatePolicy, boolean enabled, Map<String, String> tags, Context context) {
        CertificateRequestParameters certificateRequestParameters = new CertificateRequestParameters().certificatePolicy(new CertificatePolicyRequest(certificatePolicy)).certificateAttributes(new CertificateRequestAttributes().enabled(enabled)).tags(tags);
        return this.service.createCertificateAsync(this.vaultUrl, certificateName, this.apiVersion, ACCEPT_LANGUAGE, certificateRequestParameters, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Starting creation of certificate - {}", new Object[]{certificateName})).doOnSuccess(response -> LOGGER.verbose("Started creation of certificate - {}", new Object[]{certificateName})).doOnError(error -> LOGGER.warning("Failed to create the certificate - {}", new Object[]{certificateName, error}));
    }

    public PollerFlux<CertificateOperation, KeyVaultCertificateWithPolicy> getCertificateOperation(String certificateName) {
        return new PollerFlux(this.getDefaultPollingInterval(), pollingContext -> Mono.empty(), this.createPollOperation(certificateName), this.cancelOperation(certificateName), this.fetchResultOperation(certificateName));
    }

    public Mono<Response<KeyVaultCertificateWithPolicy>> getCertificateWithResponseAsync(String certificateName, String version, Context context) {
        context = context == null ? Context.NONE : context;
        return this.service.getCertificateWithPolicyAsync(this.vaultUrl, certificateName, version, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Retrieving certificate - {}", new Object[]{certificateName})).doOnSuccess(response -> LOGGER.verbose("Retrieved the certificate - {}", new Object[]{((KeyVaultCertificateWithPolicy)response.getValue()).getProperties().getName()})).doOnError(error -> LOGGER.warning("Failed to Retrieve the certificate - {}", new Object[]{certificateName, error}));
    }

    public Response<KeyVaultCertificateWithPolicy> getCertificateWithResponse(String certificateName, String version, Context context) {
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.getCertificateWithPolicy(this.vaultUrl, certificateName, version, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context);
    }

    public Mono<Response<KeyVaultCertificate>> getCertificateVersionWithResponseAsync(String certificateName, String version, Context context) {
        context = context == null ? Context.NONE : context;
        return this.service.getCertificateAsync(this.vaultUrl, certificateName, version, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Retrieving certificate - {}", new Object[]{certificateName})).doOnSuccess(response -> LOGGER.verbose("Retrieved the certificate - {}", new Object[]{((KeyVaultCertificate)response.getValue()).getProperties().getName()})).doOnError(error -> LOGGER.warning("Failed to Retrieve the certificate - {}", new Object[]{certificateName, error}));
    }

    public Response<KeyVaultCertificate> getCertificateVersionWithResponse(String certificateName, String version, Context context) {
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.getCertificate(this.vaultUrl, certificateName, version, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context);
    }

    public Mono<Response<KeyVaultCertificate>> updateCertificatePropertiesWithResponseAsync(CertificateProperties properties, Context context) {
        Objects.requireNonNull(properties, "properties' cannot be null.");
        CertificateUpdateParameters parameters = new CertificateUpdateParameters().tags(properties.getTags()).certificateAttributes(new CertificateRequestAttributes(properties));
        context = context == null ? Context.NONE : context;
        return this.service.updateCertificateAsync(this.vaultUrl, properties.getName(), properties.getVersion(), this.apiVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Updating certificate - {}", new Object[]{properties.getName()})).doOnSuccess(response -> LOGGER.verbose("Updated the certificate - {}", new Object[]{properties.getName()})).doOnError(error -> LOGGER.warning("Failed to update the certificate - {}", new Object[]{properties.getName(), error}));
    }

    public Response<KeyVaultCertificate> updateCertificatePropertiesWithResponse(CertificateProperties properties, Context context) {
        Objects.requireNonNull(properties, "properties' cannot be null.");
        CertificateUpdateParameters parameters = new CertificateUpdateParameters().tags(properties.getTags()).certificateAttributes(new CertificateRequestAttributes(properties));
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.updateCertificate(this.vaultUrl, properties.getName(), properties.getVersion(), this.apiVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context);
    }

    public PollerFlux<DeletedCertificate, Void> beginDeleteCertificate(String certificateName) {
        return new PollerFlux(this.getDefaultPollingInterval(), this.activationOperation(certificateName), this.createDeletePollOperation(certificateName), (context, firstResponse) -> Mono.empty(), context -> Mono.empty());
    }

    private Function<PollingContext<DeletedCertificate>, Mono<DeletedCertificate>> activationOperation(String certificateName) {
        return pollingContext -> FluxUtil.withContext(context -> this.deleteCertificateWithResponseAsync(certificateName, (Context)context)).flatMap(deletedCertificateResponse -> Mono.just((Object)((DeletedCertificate)deletedCertificateResponse.getValue())));
    }

    private Function<PollingContext<DeletedCertificate>, Mono<PollResponse<DeletedCertificate>>> createDeletePollOperation(String keyName) {
        return pollingContext -> FluxUtil.withContext(context -> this.service.getDeletedCertificatePollerAsync(this.vaultUrl, keyName, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, (Context)context)).flatMap(deletedCertificateResponse -> {
            if (deletedCertificateResponse.getStatusCode() == 404) {
                return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((DeletedCertificate)pollingContext.getLatestResponse().getValue()))));
            }
            if (deletedCertificateResponse.getStatusCode() == 403) {
                return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedCertificate)pollingContext.getLatestResponse().getValue()))));
            }
            return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedCertificate)deletedCertificateResponse.getValue()))));
        }).onErrorReturn((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedCertificate)pollingContext.getLatestResponse().getValue())));
    }

    private Mono<Response<DeletedCertificate>> deleteCertificateWithResponseAsync(String certificateName, Context context) {
        return this.service.deleteCertificateAsync(this.vaultUrl, certificateName, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Deleting certificate - {}", new Object[]{certificateName})).doOnSuccess(response -> LOGGER.verbose("Deleted the certificate - {}", new Object[]{((DeletedCertificate)response.getValue()).getProperties().getName()})).doOnError(error -> LOGGER.warning("Failed to delete the certificate - {}", new Object[]{certificateName, error}));
    }

    public Mono<Response<DeletedCertificate>> getDeletedCertificateWithResponseAsync(String certificateName, Context context) {
        context = context == null ? Context.NONE : context;
        return this.service.getDeletedCertificateAsync(this.vaultUrl, certificateName, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Retrieving deleted certificate - {}", new Object[]{certificateName})).doOnSuccess(response -> LOGGER.verbose("Retrieved the deleted certificate - {}", new Object[]{((DeletedCertificate)response.getValue()).getProperties().getName()})).doOnError(error -> LOGGER.warning("Failed to Retrieve the deleted certificate - {}", new Object[]{certificateName, error}));
    }

    public Response<DeletedCertificate> getDeletedCertificateWithResponse(String certificateName, Context context) {
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.getDeletedCertificate(this.vaultUrl, certificateName, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context);
    }

    public Mono<Response<Void>> purgeDeletedCertificateWithResponseAsync(String certificateName, Context context) {
        context = context == null ? Context.NONE : context;
        return this.service.purgeDeletedCertificateAsync(this.vaultUrl, certificateName, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Purging certificate - {}", new Object[]{certificateName})).doOnSuccess(response -> LOGGER.verbose("Purged the certificate - {}", new Object[]{response.getStatusCode()})).doOnError(error -> LOGGER.warning("Failed to purge the certificate - {}", new Object[]{certificateName, error}));
    }

    public Response<Void> purgeDeletedCertificateWithResponse(String certificateName, Context context) {
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.purgeDeletedCertificate(this.vaultUrl, certificateName, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context);
    }

    public PollerFlux<KeyVaultCertificateWithPolicy, Void> beginRecoverDeletedCertificate(String certificateName) {
        return new PollerFlux(this.getDefaultPollingInterval(), this.recoverActivationOperation(certificateName), this.createRecoverPollOperation(certificateName), (context, firstResponse) -> Mono.empty(), context -> Mono.empty());
    }

    private Function<PollingContext<KeyVaultCertificateWithPolicy>, Mono<KeyVaultCertificateWithPolicy>> recoverActivationOperation(String certificateName) {
        return pollingContext -> FluxUtil.withContext(context -> this.recoverDeletedCertificateWithResponseAsync(certificateName, (Context)context)).flatMap(certificateResponse -> Mono.just((Object)((KeyVaultCertificateWithPolicy)certificateResponse.getValue())));
    }

    private Function<PollingContext<KeyVaultCertificateWithPolicy>, Mono<PollResponse<KeyVaultCertificateWithPolicy>>> createRecoverPollOperation(String keyName) {
        return pollingContext -> FluxUtil.withContext(context -> this.service.getCertificatePollerAsync(this.vaultUrl, keyName, "", this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, (Context)context)).flatMap(certificateResponse -> {
            if (certificateResponse.getStatusCode() == 404) {
                return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((KeyVaultCertificateWithPolicy)pollingContext.getLatestResponse().getValue()))));
            }
            if (certificateResponse.getStatusCode() == 403) {
                return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultCertificateWithPolicy)pollingContext.getLatestResponse().getValue()))));
            }
            return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultCertificateWithPolicy)certificateResponse.getValue()))));
        }).onErrorReturn((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultCertificateWithPolicy)pollingContext.getLatestResponse().getValue())));
    }

    private Mono<Response<KeyVaultCertificateWithPolicy>> recoverDeletedCertificateWithResponseAsync(String certificateName, Context context) {
        return this.service.recoverDeletedCertificateAsync(this.vaultUrl, certificateName, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Recovering deleted certificate - {}", new Object[]{certificateName})).doOnSuccess(response -> LOGGER.verbose("Recovered the deleted certificate - {}", new Object[]{((KeyVaultCertificateWithPolicy)response.getValue()).getProperties().getName()})).doOnError(error -> LOGGER.warning("Failed to recover the deleted certificate - {}", new Object[]{certificateName, error}));
    }

    public Mono<Response<byte[]>> backupCertificateWithResponseAsync(String certificateName, Context context) {
        context = context == null ? Context.NONE : context;
        return this.service.backupCertificateAsync(this.vaultUrl, certificateName, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Backing up certificate - {}", new Object[]{certificateName})).doOnSuccess(response -> LOGGER.verbose("Backed up the certificate - {}", new Object[]{response.getStatusCode()})).doOnError(error -> LOGGER.warning("Failed to back up the certificate - {}", new Object[]{certificateName, error})).flatMap(certificateBackupResponse -> Mono.just((Object)new SimpleResponse(certificateBackupResponse.getRequest(), certificateBackupResponse.getStatusCode(), certificateBackupResponse.getHeaders(), (Object)((CertificateBackup)certificateBackupResponse.getValue()).getValue())));
    }

    public Response<byte[]> backupCertificateWithResponse(String certificateName, Context context) {
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        Response<CertificateBackup> certificateBackupResponse = this.service.backupCertificate(this.vaultUrl, certificateName, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context);
        return new SimpleResponse(certificateBackupResponse.getRequest(), certificateBackupResponse.getStatusCode(), certificateBackupResponse.getHeaders(), (Object)((CertificateBackup)certificateBackupResponse.getValue()).getValue());
    }

    public Mono<Response<KeyVaultCertificateWithPolicy>> restoreCertificateBackupWithResponseAsync(byte[] backup, Context context) {
        CertificateRestoreParameters parameters = new CertificateRestoreParameters().certificateBundleBackup(backup);
        context = context == null ? Context.NONE : context;
        return this.service.restoreCertificateAsync(this.vaultUrl, this.apiVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Restoring the certificate")).doOnSuccess(response -> LOGGER.verbose("Restored the certificate - {}", new Object[]{((KeyVaultCertificateWithPolicy)response.getValue()).getProperties().getName()})).doOnError(error -> LOGGER.warning("Failed to restore the certificate - {}", new Object[]{error}));
    }

    public Response<KeyVaultCertificateWithPolicy> restoreCertificateBackupWithResponse(byte[] backup, Context context) {
        CertificateRestoreParameters parameters = new CertificateRestoreParameters().certificateBundleBackup(backup);
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.restoreCertificate(this.vaultUrl, this.apiVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context);
    }

    public PagedFlux<CertificateProperties> listPropertiesOfCertificates() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listCertificatesFirstPage(false, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listCertificatesNextPage((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex));
        }
    }

    public PagedFlux<CertificateProperties> listPropertiesOfCertificates(boolean includePending, Context context) {
        return new PagedFlux(() -> this.listCertificatesFirstPage(includePending, context), continuationToken -> this.listCertificatesNextPage((String)continuationToken, context));
    }

    public PagedFlux<CertificateProperties> listPropertiesOfCertificates(boolean includePending) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listCertificatesFirstPage(includePending, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listCertificatesNextPage((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex));
        }
    }

    private Mono<PagedResponse<CertificateProperties>> listCertificatesNextPage(String continuationToken, Context context) {
        try {
            return this.service.getCertificatesAsync(this.vaultUrl, continuationToken, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Listing next certificates page - Page {} ", new Object[]{continuationToken})).doOnSuccess(response -> LOGGER.verbose("Listed next certificates page - Page {} ", new Object[]{continuationToken})).doOnError(error -> LOGGER.warning("Failed to list next certificates page - Page {} ", new Object[]{continuationToken, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    private Mono<PagedResponse<CertificateProperties>> listCertificatesFirstPage(boolean includePending, Context context) {
        try {
            return this.service.getCertificatesAsync(this.vaultUrl, 25, includePending, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Listing certificates")).doOnSuccess(response -> LOGGER.verbose("Listed certificates")).doOnError(error -> LOGGER.warning("Failed to list certificates", new Object[]{error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    public PagedFlux<DeletedCertificate> listDeletedCertificates(boolean includePending) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listDeletedCertificatesFirstPage(includePending, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listDeletedCertificatesNextPage((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex));
        }
    }

    public PagedFlux<DeletedCertificate> listDeletedCertificates(Boolean includePending, Context context) {
        return new PagedFlux(() -> this.listDeletedCertificatesFirstPage(includePending, context), continuationToken -> this.listDeletedCertificatesNextPage((String)continuationToken, context));
    }

    private Mono<PagedResponse<DeletedCertificate>> listDeletedCertificatesNextPage(String continuationToken, Context context) {
        try {
            return this.service.getDeletedCertificatesAsync(this.vaultUrl, continuationToken, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Listing next deleted certificates page - Page {} ", new Object[]{continuationToken})).doOnSuccess(response -> LOGGER.verbose("Listed next deleted certificates page - Page {} ", new Object[]{continuationToken})).doOnError(error -> LOGGER.warning("Failed to list next deleted certificates page - Page {} ", new Object[]{continuationToken, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    private Mono<PagedResponse<DeletedCertificate>> listDeletedCertificatesFirstPage(boolean includePending, Context context) {
        try {
            return this.service.getDeletedCertificatesAsync(this.vaultUrl, 25, includePending, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Listing deleted certificates")).doOnSuccess(response -> LOGGER.verbose("Listed deleted certificates")).doOnError(error -> LOGGER.warning("Failed to list deleted certificates", new Object[]{error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    public PagedFlux<DeletedCertificate> listDeletedCertificates() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listDeletedCertificatesFirstPage(false, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listDeletedCertificatesNextPage((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex));
        }
    }

    public PagedFlux<CertificateProperties> listPropertiesOfCertificateVersions(String certificateName) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listCertificateVersionsFirstPage(certificateName, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listCertificateVersionsNextPage((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex));
        }
    }

    public PagedFlux<CertificateProperties> listPropertiesOfCertificateVersions(String certificateName, Context context) {
        return new PagedFlux(() -> this.listCertificateVersionsFirstPage(certificateName, context), continuationToken -> this.listCertificateVersionsNextPage((String)continuationToken, context));
    }

    private Mono<PagedResponse<CertificateProperties>> listCertificateVersionsFirstPage(String certificateName, Context context) {
        try {
            return this.service.getCertificateVersionsAsync(this.vaultUrl, certificateName, 25, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Listing certificate versions - {}", new Object[]{certificateName})).doOnSuccess(response -> LOGGER.verbose("Listed certificate versions - {}", new Object[]{certificateName})).doOnError(error -> LOGGER.warning("Failed to list certificate versions - {}", new Object[]{certificateName, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    private Mono<PagedResponse<CertificateProperties>> listCertificateVersionsNextPage(String continuationToken, Context context) {
        try {
            return this.service.getCertificatesAsync(this.vaultUrl, continuationToken, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Listing next certificate versions page - Page {} ", new Object[]{continuationToken})).doOnSuccess(response -> LOGGER.verbose("Listed next certificate versions page - Page {} ", new Object[]{continuationToken})).doOnError(error -> LOGGER.warning("Failed to list next certificate versions page - Page {} ", new Object[]{continuationToken, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    public Mono<Response<KeyVaultCertificateWithPolicy>> mergeCertificateWithResponseAsync(MergeCertificateOptions mergeCertificateOptions, Context context) {
        Objects.requireNonNull(mergeCertificateOptions, "'mergeCertificateOptions' cannot be null.");
        CertificateMergeParameters mergeParameters = new CertificateMergeParameters().x509Certificates(mergeCertificateOptions.getX509Certificates()).tags(mergeCertificateOptions.getTags()).certificateAttributes(new CertificateRequestAttributes().enabled(mergeCertificateOptions.isEnabled()));
        context = context == null ? Context.NONE : context;
        return this.service.mergeCertificateAsync(this.vaultUrl, mergeCertificateOptions.getName(), this.apiVersion, ACCEPT_LANGUAGE, mergeParameters, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Merging certificate - {}", new Object[]{mergeCertificateOptions.getName()})).doOnSuccess(response -> LOGGER.verbose("Merged certificate  - {}", new Object[]{((KeyVaultCertificateWithPolicy)response.getValue()).getProperties().getName()})).doOnError(error -> LOGGER.warning("Failed to merge certificate - {}", new Object[]{mergeCertificateOptions.getName(), error}));
    }

    public Response<KeyVaultCertificateWithPolicy> mergeCertificateWithResponse(MergeCertificateOptions mergeCertificateOptions, Context context) {
        Objects.requireNonNull(mergeCertificateOptions, "'mergeCertificateOptions' cannot be null.");
        CertificateMergeParameters mergeParameters = new CertificateMergeParameters().x509Certificates(mergeCertificateOptions.getX509Certificates()).tags(mergeCertificateOptions.getTags()).certificateAttributes(new CertificateRequestAttributes().enabled(mergeCertificateOptions.isEnabled()));
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.mergeCertificate(this.vaultUrl, mergeCertificateOptions.getName(), this.apiVersion, ACCEPT_LANGUAGE, mergeParameters, CONTENT_TYPE_HEADER_VALUE, context);
    }

    public Mono<Response<CertificatePolicy>> getCertificatePolicyWithResponseAsync(String certificateName, Context context) {
        context = context == null ? Context.NONE : context;
        return this.service.getCertificatePolicyAsync(this.vaultUrl, this.apiVersion, ACCEPT_LANGUAGE, certificateName, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Retrieving certificate policy - {}", new Object[]{certificateName})).doOnSuccess(response -> LOGGER.verbose("Retrieved certificate policy - {}", new Object[]{certificateName})).doOnError(error -> LOGGER.warning("Failed to retrieve certificate policy - {}", new Object[]{certificateName, error}));
    }

    public Response<CertificatePolicy> getCertificatePolicyWithResponse(String certificateName, Context context) {
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.getCertificatePolicy(this.vaultUrl, this.apiVersion, ACCEPT_LANGUAGE, certificateName, CONTENT_TYPE_HEADER_VALUE, context);
    }

    public Mono<Response<CertificatePolicy>> updateCertificatePolicyWithResponseAsync(String certificateName, CertificatePolicy policy, Context context) {
        CertificatePolicyRequest policyRequest = new CertificatePolicyRequest(policy);
        context = context == null ? Context.NONE : context;
        return this.service.updateCertificatePolicyAsync(this.vaultUrl, this.apiVersion, ACCEPT_LANGUAGE, certificateName, policyRequest, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Updating certificate policy - {}", new Object[]{certificateName})).doOnSuccess(response -> LOGGER.verbose("Updated the certificate policy - {}", new Object[]{((CertificatePolicy)response.getValue()).getUpdatedOn()})).doOnError(error -> LOGGER.warning("Failed to update the certificate policy - {}", new Object[]{certificateName, error}));
    }

    public Response<CertificatePolicy> updateCertificatePolicyWithResponse(String certificateName, CertificatePolicy policy, Context context) {
        CertificatePolicyRequest policyRequest = new CertificatePolicyRequest(policy);
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.updateCertificatePolicy(this.vaultUrl, this.apiVersion, ACCEPT_LANGUAGE, certificateName, policyRequest, CONTENT_TYPE_HEADER_VALUE, context);
    }

    public Mono<Response<CertificateIssuer>> createIssuerWithResponseAsync(CertificateIssuer issuer, Context context) {
        CertificateIssuerSetParameters parameters = new CertificateIssuerSetParameters().provider(issuer.getProvider()).organizationDetails(new OrganizationDetails().id(issuer.getOrganizationId()).adminDetails(issuer.getAdministratorContacts())).credentials(new IssuerCredentials().password(issuer.getPassword()).accountId(issuer.getAccountId())).attributes(new IssuerAttributes().enabled(issuer.isEnabled()));
        context = context == null ? Context.NONE : context;
        return this.service.setCertificateIssuerAsync(this.vaultUrl, this.apiVersion, ACCEPT_LANGUAGE, issuer.getName(), parameters, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Creating certificate issuer - {}", new Object[]{issuer.getName()})).doOnSuccess(response -> LOGGER.verbose("Created the certificate issuer - {}", new Object[]{((CertificateIssuer)response.getValue()).getName()})).doOnError(error -> LOGGER.warning("Failed to create the certificate issuer - {}", new Object[]{issuer.getName(), error}));
    }

    public Response<CertificateIssuer> createIssuerWithResponse(CertificateIssuer issuer, Context context) {
        CertificateIssuerSetParameters parameters = new CertificateIssuerSetParameters().provider(issuer.getProvider()).organizationDetails(new OrganizationDetails().id(issuer.getOrganizationId()).adminDetails(issuer.getAdministratorContacts())).credentials(new IssuerCredentials().password(issuer.getPassword()).accountId(issuer.getAccountId())).attributes(new IssuerAttributes().enabled(issuer.isEnabled()));
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.setCertificateIssuer(this.vaultUrl, this.apiVersion, ACCEPT_LANGUAGE, issuer.getName(), parameters, CONTENT_TYPE_HEADER_VALUE, context);
    }

    public Mono<Response<CertificateIssuer>> getIssuerWithResponseAsync(String issuerName, Context context) {
        context = context == null ? Context.NONE : context;
        return this.service.getCertificateIssuerAsync(this.vaultUrl, this.apiVersion, ACCEPT_LANGUAGE, issuerName, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Retrieving certificate issuer - {}", new Object[]{issuerName})).doOnSuccess(response -> LOGGER.verbose("Retrieved the certificate issuer - {}", new Object[]{((CertificateIssuer)response.getValue()).getName()})).doOnError(error -> LOGGER.warning("Failed to retreive the certificate issuer - {}", new Object[]{issuerName, error}));
    }

    public Response<CertificateIssuer> getIssuerWithResponse(String issuerName, Context context) {
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.getCertificateIssuer(this.vaultUrl, this.apiVersion, ACCEPT_LANGUAGE, issuerName, CONTENT_TYPE_HEADER_VALUE, context);
    }

    public Mono<Response<CertificateIssuer>> deleteIssuerWithResponseAsync(String issuerName, Context context) {
        context = context == null ? Context.NONE : context;
        return this.service.deleteCertificateIssuerAsync(this.vaultUrl, issuerName, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Deleting certificate issuer - {}", new Object[]{issuerName})).doOnSuccess(response -> LOGGER.verbose("Deleted the certificate issuer - {}", new Object[]{((CertificateIssuer)response.getValue()).getName()})).doOnError(error -> LOGGER.warning("Failed to delete the certificate issuer - {}", new Object[]{issuerName, error}));
    }

    public Response<CertificateIssuer> deleteIssuerWithResponse(String issuerName, Context context) {
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.deleteCertificateIssuer(this.vaultUrl, issuerName, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context);
    }

    public PagedFlux<IssuerProperties> listPropertiesOfIssuers() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(this::listPropertiesOfIssuersFirstPage), continuationToken -> FluxUtil.withContext(context -> this.listPropertiesOfIssuersNextPage((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex));
        }
    }

    public PagedFlux<IssuerProperties> listPropertiesOfIssuers(Context context) {
        return new PagedFlux(() -> this.listPropertiesOfIssuersFirstPage(context), continuationToken -> this.listPropertiesOfIssuersNextPage((String)continuationToken, context));
    }

    private Mono<PagedResponse<IssuerProperties>> listPropertiesOfIssuersFirstPage(Context context) {
        try {
            return this.service.getCertificateIssuersAsync(this.vaultUrl, 25, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Listing certificate issuers - {}")).doOnSuccess(response -> LOGGER.verbose("Listed certificate issuers - {}")).doOnError(error -> LOGGER.warning("Failed to list certificate issuers - {}", new Object[]{error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    private Mono<PagedResponse<IssuerProperties>> listPropertiesOfIssuersNextPage(String continuationToken, Context context) {
        try {
            return this.service.getCertificateIssuersAsync(this.vaultUrl, continuationToken, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Listing next certificate issuers page - Page {} ", new Object[]{continuationToken})).doOnSuccess(response -> LOGGER.verbose("Listed next certificate issuers page - Page {} ", new Object[]{continuationToken})).doOnError(error -> LOGGER.warning("Failed to list next certificate issuers page - Page {} ", new Object[]{continuationToken, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    public Mono<Response<CertificateIssuer>> updateIssuerWithResponseAsync(CertificateIssuer issuer, Context context) {
        CertificateIssuerUpdateParameters updateParameters = new CertificateIssuerUpdateParameters().provider(issuer.getProvider()).organizationDetails(new OrganizationDetails().id(issuer.getOrganizationId()).adminDetails(issuer.getAdministratorContacts())).credentials(new IssuerCredentials().password(issuer.getPassword()).accountId(issuer.getAccountId())).attributes(new IssuerAttributes().enabled(issuer.isEnabled()));
        context = context == null ? Context.NONE : context;
        return this.service.updateCertificateIssuerAsync(this.vaultUrl, issuer.getName(), this.apiVersion, ACCEPT_LANGUAGE, updateParameters, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Updating certificate issuer - {}", new Object[]{issuer.getName()})).doOnSuccess(response -> LOGGER.verbose("Updated up the certificate issuer - {}", new Object[]{((CertificateIssuer)response.getValue()).getName()})).doOnError(error -> LOGGER.warning("Failed to updated the certificate issuer - {}", new Object[]{issuer.getName(), error}));
    }

    public Response<CertificateIssuer> updateIssuerWithResponse(CertificateIssuer issuer, Context context) {
        CertificateIssuerUpdateParameters updateParameters = new CertificateIssuerUpdateParameters().provider(issuer.getProvider()).organizationDetails(new OrganizationDetails().id(issuer.getOrganizationId()).adminDetails(issuer.getAdministratorContacts())).credentials(new IssuerCredentials().password(issuer.getPassword()).accountId(issuer.getAccountId())).attributes(new IssuerAttributes().enabled(issuer.isEnabled()));
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.updateCertificateIssuer(this.vaultUrl, issuer.getName(), this.apiVersion, ACCEPT_LANGUAGE, updateParameters, CONTENT_TYPE_HEADER_VALUE, context);
    }

    public PagedFlux<CertificateContact> setContacts(List<CertificateContact> contacts) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.setCertificateContactsWithResponse(contacts, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex));
        }
    }

    public PagedFlux<CertificateContact> setContacts(List<CertificateContact> contacts, Context context) {
        return new PagedFlux(() -> this.setCertificateContactsWithResponse(contacts, context));
    }

    private Mono<PagedResponse<CertificateContact>> setCertificateContactsWithResponse(List<CertificateContact> contacts, Context context) {
        Contacts contactsParams = new Contacts().contactList(contacts);
        return this.service.setCertificateContactsAsync(this.vaultUrl, this.apiVersion, ACCEPT_LANGUAGE, contactsParams, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Listing certificate contacts - {}")).doOnSuccess(response -> LOGGER.verbose("Listed certificate contacts - {}")).doOnError(error -> LOGGER.warning("Failed to list certificate contacts - {}", new Object[]{error}));
    }

    public PagedFlux<CertificateContact> listContacts() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(this::listCertificateContactsFirstPage));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex));
        }
    }

    public PagedFlux<CertificateContact> listContacts(Context context) {
        return new PagedFlux(() -> this.listCertificateContactsFirstPage(context));
    }

    private Mono<PagedResponse<CertificateContact>> listCertificateContactsFirstPage(Context context) {
        try {
            return this.service.getCertificateContactsAsync(this.vaultUrl, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Listing certificate contacts - {}")).doOnSuccess(response -> LOGGER.verbose("Listed certificate contacts - {}")).doOnError(error -> LOGGER.warning("Failed to list certificate contacts - {}", new Object[]{error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    public PagedFlux<CertificateContact> deleteContacts() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(this::deleteCertificateContactsWithResponse));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex));
        }
    }

    public PagedFlux<CertificateContact> deleteContacts(Context context) {
        return new PagedFlux(() -> this.deleteCertificateContactsWithResponse(context));
    }

    private Mono<PagedResponse<CertificateContact>> deleteCertificateContactsWithResponse(Context context) {
        return this.service.deleteCertificateContactsAsync(this.vaultUrl, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Deleting certificate contacts - {}")).doOnSuccess(response -> LOGGER.verbose("Deleted certificate contacts - {}")).doOnError(error -> LOGGER.warning("Failed to delete certificate contacts - {}", new Object[]{error}));
    }

    public Mono<Response<CertificateOperation>> deleteCertificateOperationWithResponseAsync(String certificateName, Context context) {
        return this.service.deleteCertificateOperationAsync(this.vaultUrl, certificateName, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Deleting certificate operation - {}", new Object[]{certificateName})).doOnSuccess(response -> LOGGER.verbose("Deleted the certificate operation - {}", new Object[]{response.getStatusCode()})).doOnError(error -> LOGGER.warning("Failed to delete the certificate operation - {}", new Object[]{certificateName, error}));
    }

    public Response<CertificateOperation> deleteCertificateOperationWithResponse(String certificateName, Context context) {
        context = this.enableSyncRestProxy(context);
        return this.service.deleteCertificateOperation(this.vaultUrl, certificateName, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context);
    }

    public Mono<Response<KeyVaultCertificateWithPolicy>> importCertificateWithResponseAsync(ImportCertificateOptions importCertificateOptions, Context context) {
        CertificateImportParameters parameters = new CertificateImportParameters().base64EncodedCertificate(this.transformCertificateForImport(importCertificateOptions)).certificateAttributes(new CertificateRequestAttributes(importCertificateOptions)).password(importCertificateOptions.getPassword()).tags(importCertificateOptions.getTags());
        Context context2 = context = context == null ? Context.NONE : context;
        if (importCertificateOptions.getPolicy() != null) {
            parameters.certificatePolicy(new CertificatePolicyRequest(importCertificateOptions.getPolicy()));
        }
        return this.service.importCertificateAsync(this.vaultUrl, importCertificateOptions.getName(), this.apiVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context);
    }

    public Response<KeyVaultCertificateWithPolicy> importCertificateWithResponse(ImportCertificateOptions importCertificateOptions, Context context) {
        CertificateImportParameters parameters = new CertificateImportParameters().base64EncodedCertificate(this.transformCertificateForImport(importCertificateOptions)).certificateAttributes(new CertificateRequestAttributes(importCertificateOptions)).password(importCertificateOptions.getPassword()).tags(importCertificateOptions.getTags());
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        if (importCertificateOptions.getPolicy() != null) {
            parameters.certificatePolicy(new CertificatePolicyRequest(importCertificateOptions.getPolicy()));
        }
        return this.service.importCertificate(this.vaultUrl, importCertificateOptions.getName(), this.apiVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context);
    }

    private String transformCertificateForImport(ImportCertificateOptions options) {
        CertificateContentType contentType;
        CertificatePolicy policy = options.getPolicy();
        if (policy != null && (contentType = policy.getContentType()) != null && contentType.equals((Object)CertificateContentType.PEM)) {
            return new String(options.getCertificate(), StandardCharsets.US_ASCII);
        }
        return Base64.getEncoder().encodeToString(options.getCertificate());
    }

    private Context enableSyncRestProxy(Context context) {
        return context.addData((Object)HTTP_REST_PROXY_SYNC_PROXY_ENABLE, (Object)true);
    }

    @Host(value="{url}")
    @ServiceInterface(name="KeyVault")
    public static interface CertificateService {
        @Post(value="certificates/{certificate-name}/create")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<CertificateOperation>> createCertificateAsync(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @BodyParam(value="application/json") CertificateRequestParameters var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Get(value="certificates/{certificate-name}/pending")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<CertificateOperation>> getCertificateOperationAsync(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Patch(value="certificates/{certificate-name}/pending")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<CertificateOperation>> updateCertificateOperationAsync(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @BodyParam(value="application/json") CertificateOperationUpdateParameter var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Delete(value="certificates/{certificate-name}/pending")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<CertificateOperation>> deleteCertificateOperationAsync(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Get(value="certificates/{certificate-name}/{certificate-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(code={403}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<KeyVaultCertificate>> getCertificateAsync(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @PathParam(value="certificate-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Get(value="certificates/{certificate-name}/{certificate-version}")
        @ExpectedResponses(value={200, 404, 403})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<KeyVaultCertificateWithPolicy>> getCertificatePollerAsync(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @PathParam(value="certificate-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Get(value="certificates/{certificate-name}/{certificate-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(code={403}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<KeyVaultCertificateWithPolicy>> getCertificateWithPolicyAsync(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @PathParam(value="certificate-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Get(value="certificates")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=CertificatePropertiesPage.class)
        public Mono<PagedResponse<CertificateProperties>> getCertificatesAsync(@HostParam(value="url") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="includePending") Boolean var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Get(value="{nextUrl}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=CertificatePropertiesPage.class)
        public Mono<PagedResponse<CertificateProperties>> getCertificatesAsync(@HostParam(value="url") String var1, @PathParam(value="nextUrl", encoded=true) String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Content-Type") String var4, Context var5);

        @Delete(value="certificates/{certificate-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<DeletedCertificate>> deleteCertificateAsync(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Patch(value="certificates/{certificate-name}/{certificate-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={500}, value=HttpResponseException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<KeyVaultCertificate>> updateCertificateAsync(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @PathParam(value="certificate-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @BodyParam(value="application/json") CertificateUpdateParameters var6, @HeaderParam(value="Content-Type") String var7, Context var8);

        @Get(value="deletedcertificates/{certificate-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<DeletedCertificate>> getDeletedCertificateAsync(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Get(value="deletedcertificates/{certificate-name}")
        @ExpectedResponses(value={200, 403, 404})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<DeletedCertificate>> getDeletedCertificatePollerAsync(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Delete(value="deletedcertificates/{certificate-name}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> purgeDeletedCertificateAsync(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Post(value="deletedcertificates/{certificate-name}/recover")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<KeyVaultCertificateWithPolicy>> recoverDeletedCertificateAsync(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Post(value="certificates/{certificate-name}/backup")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<CertificateBackup>> backupCertificateAsync(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Post(value="certificates/restore")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<KeyVaultCertificateWithPolicy>> restoreCertificateAsync(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept-language") String var3, @BodyParam(value="application/json") CertificateRestoreParameters var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Get(value="deletedcertificates")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=DeletedCertificatePage.class)
        public Mono<PagedResponse<DeletedCertificate>> getDeletedCertificatesAsync(@HostParam(value="url") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="includePending") Boolean var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Get(value="{nextUrl}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=DeletedCertificatePage.class)
        public Mono<PagedResponse<DeletedCertificate>> getDeletedCertificatesAsync(@HostParam(value="url") String var1, @PathParam(value="nextUrl", encoded=true) String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Content-Type") String var4, Context var5);

        @Put(value="certificates/contacts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=ContactPage.class)
        public Mono<PagedResponse<CertificateContact>> setCertificateContactsAsync(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept-language") String var3, @BodyParam(value="application/json") Contacts var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Get(value="certificates/contacts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=ContactPage.class)
        public Mono<PagedResponse<CertificateContact>> getCertificateContactsAsync(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Content-Type") String var4, Context var5);

        @Delete(value="certificates/contacts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=ContactPage.class)
        public Mono<PagedResponse<CertificateContact>> deleteCertificateContactsAsync(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Content-Type") String var4, Context var5);

        @Put(value="certificates/issuers/{issuer-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<CertificateIssuer>> setCertificateIssuerAsync(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept-language") String var3, @PathParam(value="issuer-name") String var4, @BodyParam(value="application/json") CertificateIssuerSetParameters var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Get(value="certificates/issuers/{issuer-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<CertificateIssuer>> getCertificateIssuerAsync(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept-language") String var3, @PathParam(value="issuer-name") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Delete(value="certificates/issuers/{issuer-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<CertificateIssuer>> deleteCertificateIssuerAsync(@HostParam(value="url") String var1, @PathParam(value="issuer-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Patch(value="certificates/issuers/{issuer-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={500}, value=HttpResponseException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<CertificateIssuer>> updateCertificateIssuerAsync(@HostParam(value="url") String var1, @PathParam(value="issuer-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @BodyParam(value="application/json") CertificateIssuerUpdateParameters var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Get(value="certificates/Issuers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=IssuerPropertiesPage.class)
        public Mono<PagedResponse<IssuerProperties>> getCertificateIssuersAsync(@HostParam(value="url") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Get(value="{nextUrl}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=IssuerPropertiesPage.class)
        public Mono<PagedResponse<IssuerProperties>> getCertificateIssuersAsync(@HostParam(value="url") String var1, @PathParam(value="nextUrl", encoded=true) String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Content-Type") String var4, Context var5);

        @Get(value="certificates/{certificate-name}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=CertificatePropertiesPage.class)
        public Mono<PagedResponse<CertificateProperties>> getCertificateVersionsAsync(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="maxresults") Integer var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Post(value="certificates/{certificate-name}/import")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<KeyVaultCertificateWithPolicy>> importCertificateAsync(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @BodyParam(value="application/json") CertificateImportParameters var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Post(value="certificates/{certificate-name}/pending/merge")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<KeyVaultCertificateWithPolicy>> mergeCertificateAsync(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @BodyParam(value="application/json") CertificateMergeParameters var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Get(value="certificates/{certificate-name}/policy")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<CertificatePolicy>> getCertificatePolicyAsync(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept-language") String var3, @PathParam(value="certificate-name") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Patch(value="certificates/{certificate-name}/policy")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<CertificatePolicy>> updateCertificatePolicyAsync(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept-language") String var3, @PathParam(value="certificate-name") String var4, @BodyParam(value="application/json") CertificatePolicyRequest var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Post(value="certificates/{certificate-name}/create")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<CertificateOperation> createCertificate(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @BodyParam(value="application/json") CertificateRequestParameters var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Get(value="certificates/{certificate-name}/pending")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<CertificateOperation> getCertificateOperation(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Patch(value="certificates/{certificate-name}/pending")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<CertificateOperation> updateCertificateOperation(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @BodyParam(value="application/json") CertificateOperationUpdateParameter var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Delete(value="certificates/{certificate-name}/pending")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<CertificateOperation> deleteCertificateOperation(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Get(value="certificates/{certificate-name}/{certificate-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(code={403}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<KeyVaultCertificate> getCertificate(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @PathParam(value="certificate-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Get(value="certificates/{certificate-name}/{certificate-version}")
        @ExpectedResponses(value={200, 404, 403})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Response<KeyVaultCertificateWithPolicy> getCertificatePoller(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @PathParam(value="certificate-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Get(value="certificates/{certificate-name}/{certificate-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(code={403}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<KeyVaultCertificateWithPolicy> getCertificateWithPolicy(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @PathParam(value="certificate-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Get(value="certificates")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=CertificatePropertiesPage.class)
        public PagedResponse<CertificateProperties> getCertificates(@HostParam(value="url") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="includePending") Boolean var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Get(value="{nextUrl}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=CertificatePropertiesPage.class)
        public PagedResponse<CertificateProperties> getCertificates(@HostParam(value="url") String var1, @PathParam(value="nextUrl", encoded=true) String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Content-Type") String var4, Context var5);

        @Delete(value="certificates/{certificate-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<DeletedCertificate> deleteCertificate(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Patch(value="certificates/{certificate-name}/{certificate-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={500}, value=HttpResponseException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<KeyVaultCertificate> updateCertificate(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @PathParam(value="certificate-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @BodyParam(value="application/json") CertificateUpdateParameters var6, @HeaderParam(value="Content-Type") String var7, Context var8);

        @Get(value="deletedcertificates/{certificate-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<DeletedCertificate> getDeletedCertificate(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Get(value="deletedcertificates/{certificate-name}")
        @ExpectedResponses(value={200, 403, 404})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Response<DeletedCertificate> getDeletedCertificatePoller(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Delete(value="deletedcertificates/{certificate-name}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> purgeDeletedCertificate(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Post(value="deletedcertificates/{certificate-name}/recover")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<KeyVaultCertificateWithPolicy> recoverDeletedCertificate(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Post(value="certificates/{certificate-name}/backup")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<CertificateBackup> backupCertificate(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Post(value="certificates/restore")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<KeyVaultCertificateWithPolicy> restoreCertificate(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept-language") String var3, @BodyParam(value="application/json") CertificateRestoreParameters var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Get(value="deletedcertificates")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=DeletedCertificatePage.class)
        public PagedResponse<DeletedCertificate> getDeletedCertificates(@HostParam(value="url") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="includePending") Boolean var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Get(value="{nextUrl}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=DeletedCertificatePage.class)
        public PagedResponse<DeletedCertificate> getDeletedCertificates(@HostParam(value="url") String var1, @PathParam(value="nextUrl", encoded=true) String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Content-Type") String var4, Context var5);

        @Put(value="certificates/contacts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=ContactPage.class)
        public PagedResponse<CertificateContact> setCertificateContacts(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept-language") String var3, @BodyParam(value="application/json") Contacts var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Get(value="certificates/contacts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=ContactPage.class)
        public PagedResponse<CertificateContact> getCertificateContacts(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Content-Type") String var4, Context var5);

        @Delete(value="certificates/contacts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=ContactPage.class)
        public PagedResponse<CertificateContact> deleteCertificateContacts(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Content-Type") String var4, Context var5);

        @Put(value="certificates/issuers/{issuer-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Response<CertificateIssuer> setCertificateIssuer(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept-language") String var3, @PathParam(value="issuer-name") String var4, @BodyParam(value="application/json") CertificateIssuerSetParameters var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Get(value="certificates/issuers/{issuer-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Response<CertificateIssuer> getCertificateIssuer(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept-language") String var3, @PathParam(value="issuer-name") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Delete(value="certificates/issuers/{issuer-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<CertificateIssuer> deleteCertificateIssuer(@HostParam(value="url") String var1, @PathParam(value="issuer-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Patch(value="certificates/issuers/{issuer-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={500}, value=HttpResponseException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<CertificateIssuer> updateCertificateIssuer(@HostParam(value="url") String var1, @PathParam(value="issuer-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @BodyParam(value="application/json") CertificateIssuerUpdateParameters var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Get(value="certificates/Issuers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=IssuerPropertiesPage.class)
        public PagedResponse<IssuerProperties> getCertificateIssuers(@HostParam(value="url") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Get(value="{nextUrl}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=IssuerPropertiesPage.class)
        public PagedResponse<IssuerProperties> getCertificateIssuers(@HostParam(value="url") String var1, @PathParam(value="nextUrl", encoded=true) String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Content-Type") String var4, Context var5);

        @Get(value="certificates/{certificate-name}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=CertificatePropertiesPage.class)
        public PagedResponse<CertificateProperties> getCertificateVersions(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="maxresults") Integer var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Post(value="certificates/{certificate-name}/import")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Response<KeyVaultCertificateWithPolicy> importCertificate(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @BodyParam(value="application/json") CertificateImportParameters var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Post(value="certificates/{certificate-name}/pending/merge")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Response<KeyVaultCertificateWithPolicy> mergeCertificate(@HostParam(value="url") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @BodyParam(value="application/json") CertificateMergeParameters var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Get(value="certificates/{certificate-name}/policy")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<CertificatePolicy> getCertificatePolicy(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept-language") String var3, @PathParam(value="certificate-name") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Patch(value="certificates/{certificate-name}/policy")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<CertificatePolicy> updateCertificatePolicy(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept-language") String var3, @PathParam(value="certificate-name") String var4, @BodyParam(value="application/json") CertificatePolicyRequest var5, @HeaderParam(value="Content-Type") String var6, Context var7);
    }
}

