/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.models;

import com.azure.security.keyvault.certificates.models.AdministratorContact;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class CertificateIssuer {
    private String accountId;
    private String password;
    private String organizationId;
    private List<AdministratorContact> administratorContacts;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="provider")
    private String provider;
    @JsonProperty(value="name")
    String name;
    @JsonProperty(value="enabled")
    private Boolean enabled;
    private OffsetDateTime created;
    private OffsetDateTime updated;

    public CertificateIssuer(String name, String provider) {
        this.name = name;
        this.provider = provider;
    }

    public CertificateIssuer(String name) {
        this.name = name;
    }

    CertificateIssuer() {
    }

    public String getId() {
        return this.id;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getName() {
        return this.name;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public CertificateIssuer setAccountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public CertificateIssuer setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public CertificateIssuer setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
        return this;
    }

    public List<AdministratorContact> getAdministratorContacts() {
        return this.administratorContacts;
    }

    public CertificateIssuer setAdministratorContacts(List<AdministratorContact> administratorContacts) {
        this.administratorContacts = administratorContacts;
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public CertificateIssuer setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public OffsetDateTime getCreatedOn() {
        return this.created;
    }

    public OffsetDateTime getUpdatedOn() {
        return this.updated;
    }

    @JsonProperty(value="credentials")
    private void unpackCredentials(Map<String, Object> credentials) {
        this.accountId = (String)credentials.get("account_id");
        this.password = (String)credentials.get("pwd");
    }

    @JsonProperty(value="org_details")
    private void unpackOrganizationalDetails(Map<String, Object> orgDetails) {
        this.administratorContacts = orgDetails.containsKey("admin_details") ? this.parseAdministrators((List)orgDetails.get("admin_details")) : null;
        this.organizationId = (String)orgDetails.get("id");
    }

    private List<AdministratorContact> parseAdministrators(List<Object> admins) {
        ArrayList<AdministratorContact> output = new ArrayList<AdministratorContact>();
        for (Object admin : admins) {
            LinkedHashMap map = (LinkedHashMap)admin;
            String firstName = map.containsKey("first_name") ? (String)map.get("first_name") : "";
            String lastName = map.containsKey("last_name") ? (String)map.get("last_name") : "";
            String email = map.containsKey("email") ? (String)map.get("email") : "";
            String phone = map.containsKey("phone") ? (String)map.get("phone") : "";
            output.add(new AdministratorContact().setFirstName(firstName).setLastName(lastName).setEmail(email).setPhone(phone));
        }
        return output;
    }

    @JsonProperty(value="attributes")
    private void unpackBaseAttributes(Map<String, Object> attributes) {
        this.enabled = (Boolean)attributes.get("enabled");
        this.created = this.epochToOffsetDateTime(attributes.get("created"));
        this.updated = this.epochToOffsetDateTime(attributes.get("updated"));
    }

    private OffsetDateTime epochToOffsetDateTime(Object epochValue) {
        if (epochValue != null) {
            Instant instant = Instant.ofEpochMilli(((Number)epochValue).longValue() * 1000L);
            return OffsetDateTime.ofInstant(instant, ZoneOffset.UTC);
        }
        return null;
    }

    @JsonProperty(value="id")
    void unpackId(String id) {
        if (id != null && id.length() > 0) {
            this.id = id;
            try {
                URL url = new URL(id);
                String[] tokens = url.getPath().split("/");
                this.name = tokens.length >= 4 ? tokens[3] : null;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }
}

