/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.polling.SyncPoller;
import com.azure.security.keyvault.certificates.CertificateClientBuilder;
import com.azure.security.keyvault.certificates.implementation.CertificateClientImpl;
import com.azure.security.keyvault.certificates.models.CertificateContact;
import com.azure.security.keyvault.certificates.models.CertificateIssuer;
import com.azure.security.keyvault.certificates.models.CertificateOperation;
import com.azure.security.keyvault.certificates.models.CertificatePolicy;
import com.azure.security.keyvault.certificates.models.CertificateProperties;
import com.azure.security.keyvault.certificates.models.DeletedCertificate;
import com.azure.security.keyvault.certificates.models.ImportCertificateOptions;
import com.azure.security.keyvault.certificates.models.IssuerProperties;
import com.azure.security.keyvault.certificates.models.KeyVaultCertificate;
import com.azure.security.keyvault.certificates.models.KeyVaultCertificateWithPolicy;
import com.azure.security.keyvault.certificates.models.MergeCertificateOptions;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClient(builder=CertificateClientBuilder.class, serviceInterfaces={CertificateClientImpl.CertificateService.class})
public final class CertificateClient {
    private final CertificateClientImpl implClient;

    CertificateClient(CertificateClientImpl implClient) {
        this.implClient = implClient;
    }

    public String getVaultUrl() {
        return this.implClient.getVaultUrl();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<CertificateOperation, KeyVaultCertificateWithPolicy> beginCreateCertificate(String certificateName, CertificatePolicy policy, Boolean isEnabled, Map<String, String> tags) {
        return this.implClient.beginCreateCertificate(certificateName, policy, isEnabled, tags, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<CertificateOperation, KeyVaultCertificateWithPolicy> beginCreateCertificate(String certificateName, CertificatePolicy policy) {
        return this.implClient.beginCreateCertificate(certificateName, policy, true, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<CertificateOperation, KeyVaultCertificateWithPolicy> getCertificateOperation(String certificateName) {
        return this.implClient.getCertificateOperation(certificateName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultCertificateWithPolicy getCertificate(String certificateName) {
        return (KeyVaultCertificateWithPolicy)this.getCertificateWithResponse(certificateName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultCertificateWithPolicy> getCertificateWithResponse(String certificateName, Context context) {
        return this.implClient.getCertificateWithResponse(certificateName, "", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultCertificate> getCertificateVersionWithResponse(String certificateName, String version, Context context) {
        return this.implClient.getCertificateVersionWithResponse(certificateName, version, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultCertificate getCertificateVersion(String certificateName, String version) {
        return (KeyVaultCertificate)this.getCertificateVersionWithResponse(certificateName, version, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultCertificate updateCertificateProperties(CertificateProperties properties) {
        return (KeyVaultCertificate)this.updateCertificatePropertiesWithResponse(properties, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultCertificate> updateCertificatePropertiesWithResponse(CertificateProperties properties, Context context) {
        return this.implClient.updateCertificatePropertiesWithResponse(properties, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DeletedCertificate, Void> beginDeleteCertificate(String certificateName) {
        return this.implClient.beginDeleteCertificate(certificateName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeletedCertificate getDeletedCertificate(String certificateName) {
        return (DeletedCertificate)this.getDeletedCertificateWithResponse(certificateName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeletedCertificate> getDeletedCertificateWithResponse(String certificateName, Context context) {
        return this.implClient.getDeletedCertificateWithResponse(certificateName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void purgeDeletedCertificate(String certificateName) {
        this.purgeDeletedCertificateWithResponse(certificateName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> purgeDeletedCertificateWithResponse(String certificateName, Context context) {
        return this.implClient.purgeDeletedCertificateWithResponse(certificateName, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<KeyVaultCertificateWithPolicy, Void> beginRecoverDeletedCertificate(String certificateName) {
        return this.implClient.beginRecoverDeletedCertificate(certificateName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public byte[] backupCertificate(String certificateName) {
        return (byte[])this.backupCertificateWithResponse(certificateName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<byte[]> backupCertificateWithResponse(String certificateName, Context context) {
        return this.implClient.backupCertificateWithResponse(certificateName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultCertificateWithPolicy restoreCertificateBackup(byte[] backup) {
        return (KeyVaultCertificateWithPolicy)this.restoreCertificateBackupWithResponse(backup, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultCertificateWithPolicy> restoreCertificateBackupWithResponse(byte[] backup, Context context) {
        return this.implClient.restoreCertificateBackupWithResponse(backup, context);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateProperties> listPropertiesOfCertificates() {
        return this.implClient.listPropertiesOfCertificates(false, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateProperties> listPropertiesOfCertificates(boolean includePending, Context context) {
        return this.implClient.listPropertiesOfCertificates(includePending, context);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedCertificate> listDeletedCertificates() {
        return this.listDeletedCertificates(false, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedCertificate> listDeletedCertificates(boolean includePending, Context context) {
        return this.implClient.listDeletedCertificates(includePending, context);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateProperties> listPropertiesOfCertificateVersions(String certificateName) {
        return this.listPropertiesOfCertificateVersions(certificateName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateProperties> listPropertiesOfCertificateVersions(String certificateName, Context context) {
        return this.implClient.listPropertiesOfCertificateVersions(certificateName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificatePolicy getCertificatePolicy(String certificateName) {
        return (CertificatePolicy)this.getCertificatePolicyWithResponse(certificateName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificatePolicy> getCertificatePolicyWithResponse(String certificateName, Context context) {
        return this.implClient.getCertificatePolicyWithResponse(certificateName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificatePolicy updateCertificatePolicy(String certificateName, CertificatePolicy policy) {
        return (CertificatePolicy)this.updateCertificatePolicyWithResponse(certificateName, policy, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificatePolicy> updateCertificatePolicyWithResponse(String certificateName, CertificatePolicy policy, Context context) {
        return this.implClient.updateCertificatePolicyWithResponse(certificateName, policy, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateIssuer createIssuer(CertificateIssuer issuer) {
        return (CertificateIssuer)this.createIssuerWithResponse(issuer, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateIssuer> createIssuerWithResponse(CertificateIssuer issuer, Context context) {
        return this.implClient.createIssuerWithResponse(issuer, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateIssuer> getIssuerWithResponse(String issuerName, Context context) {
        return this.implClient.getIssuerWithResponse(issuerName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateIssuer getIssuer(String issuerName) {
        return (CertificateIssuer)this.getIssuerWithResponse(issuerName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateIssuer> deleteIssuerWithResponse(String issuerName, Context context) {
        return this.implClient.deleteIssuerWithResponse(issuerName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateIssuer deleteIssuer(String issuerName) {
        return (CertificateIssuer)this.deleteIssuerWithResponse(issuerName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<IssuerProperties> listPropertiesOfIssuers() {
        return this.listPropertiesOfIssuers(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<IssuerProperties> listPropertiesOfIssuers(Context context) {
        return this.implClient.listPropertiesOfIssuers(context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateIssuer updateIssuer(CertificateIssuer issuer) {
        return (CertificateIssuer)this.updateIssuerWithResponse(issuer, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateIssuer> updateIssuerWithResponse(CertificateIssuer issuer, Context context) {
        return this.implClient.updateIssuerWithResponse(issuer, context);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateContact> setContacts(List<CertificateContact> contacts) {
        return this.setContacts(contacts, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateContact> setContacts(List<CertificateContact> contacts, Context context) {
        return this.implClient.setContacts(contacts, context);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateContact> listContacts() {
        return this.listContacts(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateContact> listContacts(Context context) {
        return this.implClient.listContacts(context);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateContact> deleteContacts() {
        return this.deleteContacts(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateContact> deleteContacts(Context context) {
        return this.implClient.deleteContacts(context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateOperation deleteCertificateOperation(String certificateName) {
        return (CertificateOperation)this.deleteCertificateOperationWithResponse(certificateName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateOperation> deleteCertificateOperationWithResponse(String certificateName, Context context) {
        return this.implClient.deleteCertificateOperationWithResponse(certificateName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateOperation cancelCertificateOperation(String certificateName) {
        return (CertificateOperation)this.cancelCertificateOperationWithResponse(certificateName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateOperation> cancelCertificateOperationWithResponse(String certificateName, Context context) {
        return this.implClient.cancelCertificateOperationWithResponse(certificateName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultCertificateWithPolicy mergeCertificate(MergeCertificateOptions mergeCertificateOptions) {
        return (KeyVaultCertificateWithPolicy)this.mergeCertificateWithResponse(mergeCertificateOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultCertificateWithPolicy> mergeCertificateWithResponse(MergeCertificateOptions mergeCertificateOptions, Context context) {
        Objects.requireNonNull(mergeCertificateOptions, "'mergeCertificateOptions' cannot be null.");
        return this.implClient.mergeCertificateWithResponse(mergeCertificateOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultCertificateWithPolicy importCertificate(ImportCertificateOptions importCertificateOptions) {
        return (KeyVaultCertificateWithPolicy)this.importCertificateWithResponse(importCertificateOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultCertificateWithPolicy> importCertificateWithResponse(ImportCertificateOptions importCertificateOptions, Context context) {
        return this.implClient.importCertificateWithResponse(importCertificateOptions, context);
    }
}

