/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation;

import com.azure.security.keyvault.certificates.implementation.Action;
import com.azure.security.keyvault.certificates.implementation.Trigger;
import com.azure.security.keyvault.certificates.models.LifetimeAction;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class LifetimeActionRequest {
    @JsonProperty(value="trigger")
    private Trigger trigger;
    @JsonProperty(value="action")
    private Action action;

    public LifetimeActionRequest(LifetimeAction lifeTimeAction) {
        this.action = new Action().setActionType(lifeTimeAction.getAction());
        this.trigger = new Trigger().daysBeforeExpiry(lifeTimeAction.getDaysBeforeExpiry()).lifetimePercentage(lifeTimeAction.getLifetimePercentage());
    }

    public Trigger trigger() {
        return this.trigger;
    }

    public LifetimeActionRequest withTrigger(Trigger trigger) {
        this.trigger = trigger;
        return this;
    }

    public Action action() {
        return this.action;
    }

    public LifetimeActionRequest action(Action action) {
        this.action = action;
        return this;
    }
}

