// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

/** The certificate management attributes. */
@Fluent
public final class CertificateAttributes extends Attributes {
    /*
     * softDelete data retention days. Value should be >=7 and <=90 when softDelete enabled, otherwise 0.
     */
    private Integer recoverableDays;

    /*
     * Reflects the deletion recovery level currently in effect for certificates in the current vault. If it contains
     * 'Purgeable', the certificate can be permanently deleted by a privileged user; otherwise, only the system can
     * purge the certificate, at the end of the retention interval.
     */
    private DeletionRecoveryLevel recoveryLevel;

    /** Creates an instance of CertificateAttributes class. */
    public CertificateAttributes() {}

    /**
     * Get the recoverableDays property: softDelete data retention days. Value should be &gt;=7 and &lt;=90 when
     * softDelete enabled, otherwise 0.
     *
     * @return the recoverableDays value.
     */
    public Integer getRecoverableDays() {
        return this.recoverableDays;
    }

    /**
     * Get the recoveryLevel property: Reflects the deletion recovery level currently in effect for certificates in the
     * current vault. If it contains 'Purgeable', the certificate can be permanently deleted by a privileged user;
     * otherwise, only the system can purge the certificate, at the end of the retention interval.
     *
     * @return the recoveryLevel value.
     */
    public DeletionRecoveryLevel getRecoveryLevel() {
        return this.recoveryLevel;
    }

    /** {@inheritDoc} */
    @Override
    public CertificateAttributes setEnabled(Boolean enabled) {
        super.setEnabled(enabled);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public CertificateAttributes setNotBefore(OffsetDateTime notBefore) {
        super.setNotBefore(notBefore);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public CertificateAttributes setExpires(OffsetDateTime expires) {
        super.setExpires(expires);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", isEnabled());
        if (getNotBefore() != null) {
            jsonWriter.writeNumberField("nbf", getNotBefore().toEpochSecond());
        }
        if (getExpires() != null) {
            jsonWriter.writeNumberField("exp", getExpires().toEpochSecond());
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CertificateAttributes from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of CertificateAttributes if the JsonReader was pointing to an instance of it, or null if it
     *     was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CertificateAttributes.
     */
    public static CertificateAttributes fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    CertificateAttributes deserializedCertificateAttributes = new CertificateAttributes();
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();

                        if ("enabled".equals(fieldName)) {
                            deserializedCertificateAttributes.setEnabled(reader.getNullable(JsonReader::getBoolean));
                        } else if ("nbf".equals(fieldName)) {
                            Long notBefore = reader.getNullable(JsonReader::getLong);
                            if (notBefore != null) {
                                deserializedCertificateAttributes.setNotBefore(
                                        OffsetDateTime.ofInstant(Instant.ofEpochSecond(notBefore), ZoneOffset.UTC));
                            }
                        } else if ("exp".equals(fieldName)) {
                            Long expires = reader.getNullable(JsonReader::getLong);
                            if (expires != null) {
                                deserializedCertificateAttributes.setExpires(
                                        OffsetDateTime.ofInstant(Instant.ofEpochSecond(expires), ZoneOffset.UTC));
                            }
                        } else if ("created".equals(fieldName)) {
                            deserializedCertificateAttributes.setCreated(reader.getNullable(JsonReader::getLong));
                        } else if ("updated".equals(fieldName)) {
                            deserializedCertificateAttributes.setUpdated(reader.getNullable(JsonReader::getLong));
                        } else if ("recoverableDays".equals(fieldName)) {
                            deserializedCertificateAttributes.recoverableDays = reader.getNullable(JsonReader::getInt);
                        } else if ("recoveryLevel".equals(fieldName)) {
                            deserializedCertificateAttributes.recoveryLevel =
                                    DeletionRecoveryLevel.fromString(reader.getString());
                        } else {
                            reader.skipChildren();
                        }
                    }

                    return deserializedCertificateAttributes;
                });
    }
}
