// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.certificates.implementation.models;

/** The type of the action. */
public enum CertificatePolicyAction {
    /** Enum value EmailContacts. */
    EMAIL_CONTACTS("EmailContacts"),

    /** Enum value AutoRenew. */
    AUTO_RENEW("AutoRenew");

    /** The actual serialized value for a CertificatePolicyAction instance. */
    private final String value;

    CertificatePolicyAction(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a CertificatePolicyAction instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed CertificatePolicyAction object, or null if unable to parse.
     */
    public static CertificatePolicyAction fromString(String value) {
        if (value == null) {
            return null;
        }
        CertificatePolicyAction[] items = CertificatePolicyAction.values();
        for (CertificatePolicyAction item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /** {@inheritDoc} */
    @Override
    public String toString() {
        return this.value;
    }
}
