/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.models;

import com.azure.core.util.Base64Url;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.implementation.CertificatePropertiesHelper;
import com.azure.security.keyvault.certificates.implementation.CertificatesUtils;
import com.azure.security.keyvault.certificates.implementation.IdMetadata;
import com.azure.security.keyvault.certificates.implementation.models.CertificateAttributes;
import com.azure.security.keyvault.certificates.implementation.models.CertificateBundle;
import com.azure.security.keyvault.certificates.implementation.models.CertificateItem;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Objects;

public class CertificateProperties
implements JsonSerializable<CertificateProperties> {
    private static final ClientLogger LOGGER = new ClientLogger(CertificateProperties.class);
    private final String vaultUrl;
    private final String version;
    private String name;
    private Boolean enabled;
    private final OffsetDateTime notBefore;
    private final OffsetDateTime expiresOn;
    private final OffsetDateTime createdOn;
    private final OffsetDateTime updatedOn;
    private final String recoveryLevel;
    private final String id;
    private Map<String, String> tags;
    private final Base64Url x509Thumbprint;
    private final Integer recoverableDays;

    CertificateProperties() {
        this(null, new CertificateAttributes(), null, null, null);
    }

    CertificateProperties(CertificateItem item) {
        this(item.getId(), item.getAttributes(), item.getTags(), item.getX509Thumbprint(), item.getAttributes().getRecoverableDays());
    }

    CertificateProperties(CertificateBundle bundle) {
        this(bundle.getId(), bundle.getAttributes(), bundle.getTags(), bundle.getX509Thumbprint(), bundle.getAttributes().getRecoverableDays());
    }

    CertificateProperties(String id, CertificateAttributes attributes, Map<String, String> tags, byte[] wireThumbprint, Integer recoverableDays) {
        IdMetadata idMetadata = CertificatesUtils.getIdMetadata(id, 1, 2, 3, LOGGER);
        this.id = idMetadata.getId();
        this.vaultUrl = idMetadata.getVaultUrl();
        this.name = idMetadata.getName();
        this.version = idMetadata.getVersion();
        if (attributes != null) {
            this.enabled = attributes.isEnabled();
            this.notBefore = attributes.getNotBefore();
            this.expiresOn = attributes.getExpires();
            this.createdOn = attributes.getCreated();
            this.updatedOn = attributes.getUpdated();
            this.recoveryLevel = Objects.toString((Object)attributes.getRecoveryLevel(), null);
        } else {
            this.enabled = null;
            this.notBefore = null;
            this.expiresOn = null;
            this.createdOn = null;
            this.updatedOn = null;
            this.recoveryLevel = null;
        }
        this.tags = tags;
        this.x509Thumbprint = wireThumbprint == null || wireThumbprint.length == 0 ? null : Base64Url.encode((byte[])wireThumbprint);
        this.recoverableDays = recoverableDays;
    }

    void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public OffsetDateTime getNotBefore() {
        return this.notBefore;
    }

    public Integer getRecoverableDays() {
        return this.recoverableDays;
    }

    public OffsetDateTime getExpiresOn() {
        return this.expiresOn;
    }

    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    public OffsetDateTime getUpdatedOn() {
        return this.updatedOn;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    public CertificateProperties setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getRecoveryLevel() {
        return this.recoveryLevel;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public CertificateProperties setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public byte[] getX509Thumbprint() {
        if (this.x509Thumbprint != null) {
            return this.x509Thumbprint.decodedBytes();
        }
        return null;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeMapField("tags", this.tags, JsonWriter::writeString).writeEndObject();
    }

    public static CertificateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CertificateProperties)jsonReader.readObject(reader -> {
            String id = null;
            CertificateAttributes attributes = null;
            Map tags = null;
            byte[] wireThumbprint = null;
            Integer recoverableDays = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    attributes = CertificateAttributes.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readMap(JsonReader::getString);
                    continue;
                }
                if ("x5t".equals(fieldName)) {
                    wireThumbprint = reader.getBinary();
                    continue;
                }
                if ("recoverableDays".equals(fieldName)) {
                    recoverableDays = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return new CertificateProperties(id, attributes == null ? new CertificateAttributes() : attributes, tags, wireThumbprint, recoverableDays);
        });
    }

    static {
        CertificatePropertiesHelper.setAccessor(CertificateProperties::new);
    }
}

