/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.polling.SyncPoller;
import com.azure.security.keyvault.certificates.CertificateAsyncClient;
import com.azure.security.keyvault.certificates.CertificateClientBuilder;
import com.azure.security.keyvault.certificates.implementation.CertificateClientImpl;
import com.azure.security.keyvault.certificates.implementation.CertificateIssuerHelper;
import com.azure.security.keyvault.certificates.implementation.CertificateOperationHelper;
import com.azure.security.keyvault.certificates.implementation.CertificatePolicyHelper;
import com.azure.security.keyvault.certificates.implementation.DeletedCertificateHelper;
import com.azure.security.keyvault.certificates.implementation.KeyVaultCertificateWithPolicyHelper;
import com.azure.security.keyvault.certificates.implementation.models.BackupCertificateResult;
import com.azure.security.keyvault.certificates.implementation.models.CertificateAttributes;
import com.azure.security.keyvault.certificates.implementation.models.CertificateBundle;
import com.azure.security.keyvault.certificates.implementation.models.Contacts;
import com.azure.security.keyvault.certificates.implementation.models.IssuerBundle;
import com.azure.security.keyvault.certificates.implementation.models.KeyVaultErrorException;
import com.azure.security.keyvault.certificates.models.CertificateContact;
import com.azure.security.keyvault.certificates.models.CertificateIssuer;
import com.azure.security.keyvault.certificates.models.CertificateOperation;
import com.azure.security.keyvault.certificates.models.CertificatePolicy;
import com.azure.security.keyvault.certificates.models.CertificateProperties;
import com.azure.security.keyvault.certificates.models.DeletedCertificate;
import com.azure.security.keyvault.certificates.models.ImportCertificateOptions;
import com.azure.security.keyvault.certificates.models.IssuerProperties;
import com.azure.security.keyvault.certificates.models.KeyVaultCertificate;
import com.azure.security.keyvault.certificates.models.KeyVaultCertificateWithPolicy;
import com.azure.security.keyvault.certificates.models.MergeCertificateOptions;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

@ServiceClient(builder=CertificateClientBuilder.class, serviceInterfaces={CertificateClientImpl.CertificateClientService.class})
public final class CertificateClient {
    private static final ClientLogger LOGGER = new ClientLogger(CertificateClient.class);
    private final CertificateClientImpl implClient;
    private final String vaultUrl;

    CertificateClient(CertificateClientImpl implClient, String vaultUrl) {
        this.implClient = implClient;
        this.vaultUrl = vaultUrl;
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<CertificateOperation, KeyVaultCertificateWithPolicy> beginCreateCertificate(String certificateName, CertificatePolicy policy, Boolean isEnabled, Map<String, String> tags) {
        if (policy == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'policy' cannot be null."));
        }
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), ignored -> this.createCertificateActivation(certificateName, policy, isEnabled, tags), ignored -> this.certificatePollOperation(certificateName), (ignored1, ignored2) -> this.certificateCancellationOperation(certificateName), ignored -> this.fetchCertificateOperation(certificateName));
    }

    private PollResponse<CertificateOperation> createCertificateActivation(String certificateName, CertificatePolicy policy, Boolean isEnabled, Map<String, String> tags) {
        com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy implPolicy = CertificatePolicyHelper.getImplCertificatePolicy(policy);
        return new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)CertificateOperationHelper.createCertificateOperation(CertificateClient.callWithMappedException(() -> this.implClient.createCertificate(this.vaultUrl, certificateName, implPolicy, new CertificateAttributes().setEnabled(isEnabled), tags), CertificateAsyncClient::mapCreateCertificateException)));
    }

    private PollResponse<CertificateOperation> certificatePollOperation(String certificateName) {
        return CertificateAsyncClient.processCertificateOperationResponse(CertificateClient.callWithMappedException(() -> this.implClient.getCertificateOperation(this.vaultUrl, certificateName), CertificateAsyncClient::mapGetCertificateOperationException));
    }

    private CertificateOperation certificateCancellationOperation(String certificateName) {
        return CertificateOperationHelper.createCertificateOperation(CertificateClient.callWithMappedException(() -> this.implClient.updateCertificateOperation(this.vaultUrl, certificateName, true), CertificateAsyncClient::mapUpdateCertificateOperationException));
    }

    private KeyVaultCertificateWithPolicy fetchCertificateOperation(String certificateName) {
        return KeyVaultCertificateWithPolicyHelper.createCertificateWithPolicy(CertificateClient.callWithMappedException(() -> this.implClient.getCertificate(this.vaultUrl, certificateName, null), CertificateAsyncClient::mapGetCertificateException));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<CertificateOperation, KeyVaultCertificateWithPolicy> beginCreateCertificate(String certificateName, CertificatePolicy policy) {
        return this.beginCreateCertificate(certificateName, policy, true, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<CertificateOperation, KeyVaultCertificateWithPolicy> getCertificateOperation(String certificateName) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), ignored -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, null), ignored -> this.certificatePollOperation(certificateName), (ignored1, ignored2) -> this.certificateCancellationOperation(certificateName), ignored -> this.fetchCertificateOperation(certificateName));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultCertificateWithPolicy getCertificate(String certificateName) {
        return (KeyVaultCertificateWithPolicy)this.getCertificateWithResponse(certificateName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultCertificateWithPolicy> getCertificateWithResponse(String certificateName, Context context) {
        return CertificateClient.callWithMappedResponseAndException(() -> this.implClient.getCertificateWithResponse(this.vaultUrl, certificateName, null, context), KeyVaultCertificateWithPolicyHelper::createCertificateWithPolicy, CertificateAsyncClient::mapGetCertificateException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultCertificate> getCertificateVersionWithResponse(String certificateName, String version, Context context) {
        return CertificateClient.callWithMappedResponseAndException(() -> this.implClient.getCertificateWithResponse(this.vaultUrl, certificateName, version, context), KeyVaultCertificateWithPolicyHelper::createCertificateWithPolicy, CertificateAsyncClient::mapGetCertificateException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultCertificate getCertificateVersion(String certificateName, String version) {
        return (KeyVaultCertificate)this.getCertificateVersionWithResponse(certificateName, version, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultCertificate updateCertificateProperties(CertificateProperties properties) {
        return (KeyVaultCertificate)this.updateCertificatePropertiesWithResponse(properties, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultCertificate> updateCertificatePropertiesWithResponse(CertificateProperties properties, Context context) {
        if (properties == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'properties' cannot be null."));
        }
        CertificateAttributes certificateAttributes = new CertificateAttributes().setEnabled(properties.isEnabled()).setExpires(properties.getExpiresOn()).setNotBefore(properties.getNotBefore());
        Response<CertificateBundle> response = this.implClient.updateCertificateWithResponse(this.vaultUrl, properties.getName(), properties.getVersion(), null, certificateAttributes, properties.getTags(), context);
        return new SimpleResponse(response, (Object)KeyVaultCertificateWithPolicyHelper.createCertificateWithPolicy((CertificateBundle)response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DeletedCertificate, Void> beginDeleteCertificate(String certificateName) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), ignored -> this.deleteCertificateActivation(certificateName), pollingContext -> this.deleteCertificatePollOperation(certificateName, (PollingContext<DeletedCertificate>)pollingContext), (pollingContext, firstResponse) -> null, pollingContext -> null);
    }

    private PollResponse<DeletedCertificate> deleteCertificateActivation(String certificateName) {
        return new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)DeletedCertificateHelper.createDeletedCertificate(CertificateClient.callWithMappedException(() -> this.implClient.deleteCertificate(this.vaultUrl, certificateName), CertificateAsyncClient::mapDeleteCertificateException)));
    }

    private PollResponse<DeletedCertificate> deleteCertificatePollOperation(String certificateName, PollingContext<DeletedCertificate> pollingContext) {
        try {
            return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)DeletedCertificateHelper.createDeletedCertificate(this.implClient.getDeletedCertificate(this.vaultUrl, certificateName)));
        }
        catch (KeyVaultErrorException ex) {
            if (ex.getResponse().getStatusCode() == 404) {
                return new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((DeletedCertificate)pollingContext.getLatestResponse().getValue()));
            }
            return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedCertificate)pollingContext.getLatestResponse().getValue()));
        }
        catch (Exception ex) {
            return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedCertificate)pollingContext.getLatestResponse().getValue()));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeletedCertificate getDeletedCertificate(String certificateName) {
        return (DeletedCertificate)this.getDeletedCertificateWithResponse(certificateName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeletedCertificate> getDeletedCertificateWithResponse(String certificateName, Context context) {
        return CertificateClient.callWithMappedResponseAndException(() -> this.implClient.getDeletedCertificateWithResponse(this.vaultUrl, certificateName, context), DeletedCertificateHelper::createDeletedCertificate, CertificateAsyncClient::mapGetDeletedCertificateException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void purgeDeletedCertificate(String certificateName) {
        this.purgeDeletedCertificateWithResponse(certificateName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> purgeDeletedCertificateWithResponse(String certificateName, Context context) {
        return CertificateClient.callWithMappedResponseAndException(() -> this.implClient.purgeDeletedCertificateWithResponse(this.vaultUrl, certificateName, context), t -> t, CertificateAsyncClient::mapPurgeDeletedCertificateException);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<KeyVaultCertificateWithPolicy, Void> beginRecoverDeletedCertificate(String certificateName) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), ignored -> this.recoverDeletedCertificateActivation(certificateName), pollingContext -> this.recoverDeletedCertificatePollOperation(certificateName, (PollingContext<KeyVaultCertificateWithPolicy>)pollingContext), (pollingContext, firstResponse) -> null, pollingContext -> null);
    }

    private PollResponse<KeyVaultCertificateWithPolicy> recoverDeletedCertificateActivation(String certificateName) {
        return new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)KeyVaultCertificateWithPolicyHelper.createCertificateWithPolicy(CertificateClient.callWithMappedException(() -> this.implClient.recoverDeletedCertificate(this.vaultUrl, certificateName), CertificateAsyncClient::mapRecoverDeletedCertificateException)));
    }

    private PollResponse<KeyVaultCertificateWithPolicy> recoverDeletedCertificatePollOperation(String certificateName, PollingContext<KeyVaultCertificateWithPolicy> pollingContext) {
        try {
            return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)KeyVaultCertificateWithPolicyHelper.createCertificateWithPolicy(this.implClient.getCertificate(this.vaultUrl, certificateName, null)));
        }
        catch (KeyVaultErrorException ex) {
            if (ex.getResponse().getStatusCode() == 404) {
                return new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((KeyVaultCertificateWithPolicy)pollingContext.getLatestResponse().getValue()));
            }
            return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultCertificateWithPolicy)pollingContext.getLatestResponse().getValue()));
        }
        catch (Exception ex) {
            return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultCertificateWithPolicy)pollingContext.getLatestResponse().getValue()));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public byte[] backupCertificate(String certificateName) {
        return (byte[])this.backupCertificateWithResponse(certificateName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<byte[]> backupCertificateWithResponse(String certificateName, Context context) {
        return CertificateClient.callWithMappedResponseAndException(() -> this.implClient.backupCertificateWithResponse(this.vaultUrl, certificateName, context), BackupCertificateResult::getValue, CertificateAsyncClient::mapBackupCertificateException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultCertificateWithPolicy restoreCertificateBackup(byte[] backup) {
        return (KeyVaultCertificateWithPolicy)this.restoreCertificateBackupWithResponse(backup, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultCertificateWithPolicy> restoreCertificateBackupWithResponse(byte[] backup, Context context) {
        return CertificateClient.callWithMappedResponseAndException(() -> this.implClient.restoreCertificateWithResponse(this.vaultUrl, backup, context), KeyVaultCertificateWithPolicyHelper::createCertificateWithPolicy, CertificateAsyncClient::mapRestoreCertificateException);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateProperties> listPropertiesOfCertificates() {
        return this.listPropertiesOfCertificates(false, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateProperties> listPropertiesOfCertificates(boolean includePending, Context context) {
        return new PagedIterable(maxResults -> CertificateAsyncClient.mapCertificateItemPage(this.implClient.getCertificatesSinglePage(this.vaultUrl, (Integer)maxResults, includePending, context)), (continuationToken, maxResults) -> CertificateAsyncClient.mapCertificateItemPage(this.implClient.getCertificatesNextSinglePage((String)continuationToken, this.vaultUrl, context)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedCertificate> listDeletedCertificates() {
        return this.listDeletedCertificates(false, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedCertificate> listDeletedCertificates(boolean includePending, Context context) {
        return new PagedIterable(maxResults -> CertificateAsyncClient.mapDeletedCertificateItemPage(this.implClient.getDeletedCertificatesSinglePage(this.vaultUrl, (Integer)maxResults, includePending, context)), (continuationToken, maxResults) -> CertificateAsyncClient.mapDeletedCertificateItemPage(this.implClient.getDeletedCertificatesNextSinglePage((String)continuationToken, this.vaultUrl, context)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateProperties> listPropertiesOfCertificateVersions(String certificateName) {
        return this.listPropertiesOfCertificateVersions(certificateName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateProperties> listPropertiesOfCertificateVersions(String certificateName, Context context) {
        return new PagedIterable(maxResults -> CertificateAsyncClient.mapCertificateItemPage(this.implClient.getCertificateVersionsSinglePage(this.vaultUrl, certificateName, (Integer)maxResults, context)), (continuationToken, maxResults) -> CertificateAsyncClient.mapCertificateItemPage(this.implClient.getCertificateVersionsNextSinglePage((String)continuationToken, this.vaultUrl, context)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificatePolicy getCertificatePolicy(String certificateName) {
        return (CertificatePolicy)this.getCertificatePolicyWithResponse(certificateName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificatePolicy> getCertificatePolicyWithResponse(String certificateName, Context context) {
        return CertificateClient.callWithMappedResponseAndException(() -> this.implClient.getCertificatePolicyWithResponse(this.vaultUrl, certificateName, context), CertificatePolicyHelper::createCertificatePolicy, CertificateAsyncClient::mapGetCertificatePolicyException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificatePolicy updateCertificatePolicy(String certificateName, CertificatePolicy policy) {
        return (CertificatePolicy)this.updateCertificatePolicyWithResponse(certificateName, policy, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificatePolicy> updateCertificatePolicyWithResponse(String certificateName, CertificatePolicy policy, Context context) {
        if (policy == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'policy' cannot be null."));
        }
        return CertificateClient.callWithMappedResponseAndException(() -> this.implClient.updateCertificatePolicyWithResponse(this.vaultUrl, certificateName, CertificatePolicyHelper.getImplCertificatePolicy(policy), context), CertificatePolicyHelper::createCertificatePolicy, CertificateAsyncClient::mapUpdateCertificatePolicyException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateIssuer createIssuer(CertificateIssuer issuer) {
        return (CertificateIssuer)this.createIssuerWithResponse(issuer, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateIssuer> createIssuerWithResponse(CertificateIssuer issuer, Context context) {
        if (issuer == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'issuer' cannot be null."));
        }
        IssuerBundle issuerBundle = CertificateIssuerHelper.getIssuerBundle(issuer);
        return CertificateClient.callWithMappedResponseAndException(() -> this.implClient.setCertificateIssuerWithResponse(this.vaultUrl, issuer.getName(), issuer.getProvider(), issuerBundle.getCredentials(), issuerBundle.getOrganizationDetails(), issuerBundle.getAttributes(), context), CertificateIssuerHelper::createCertificateIssuer, ex -> ex);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateIssuer> getIssuerWithResponse(String issuerName, Context context) {
        return CertificateClient.callWithMappedResponseAndException(() -> this.implClient.getCertificateIssuerWithResponse(this.vaultUrl, issuerName, context), CertificateIssuerHelper::createCertificateIssuer, ex -> ex);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateIssuer getIssuer(String issuerName) {
        return (CertificateIssuer)this.getIssuerWithResponse(issuerName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateIssuer> deleteIssuerWithResponse(String issuerName, Context context) {
        return CertificateClient.callWithMappedResponseAndException(() -> this.implClient.deleteCertificateIssuerWithResponse(this.vaultUrl, issuerName, context), CertificateIssuerHelper::createCertificateIssuer, CertificateAsyncClient::mapDeleteCertificateIssuerException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateIssuer deleteIssuer(String issuerName) {
        return (CertificateIssuer)this.deleteIssuerWithResponse(issuerName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<IssuerProperties> listPropertiesOfIssuers() {
        return this.listPropertiesOfIssuers(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<IssuerProperties> listPropertiesOfIssuers(Context context) {
        return new PagedIterable(maxResults -> CertificateAsyncClient.mapIssuersPagedResponse(this.implClient.getCertificateIssuersSinglePage(this.vaultUrl, (Integer)maxResults, context)), (continuationToken, maxResults) -> CertificateAsyncClient.mapIssuersPagedResponse(this.implClient.getCertificateIssuersNextSinglePage((String)continuationToken, this.vaultUrl, context)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateIssuer updateIssuer(CertificateIssuer issuer) {
        return (CertificateIssuer)this.updateIssuerWithResponse(issuer, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateIssuer> updateIssuerWithResponse(CertificateIssuer issuer, Context context) {
        if (issuer == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'issuer' cannot be null."));
        }
        IssuerBundle issuerBundle = CertificateIssuerHelper.getIssuerBundle(issuer);
        return CertificateClient.callWithMappedResponseAndException(() -> this.implClient.updateCertificateIssuerWithResponse(this.vaultUrl, issuer.getName(), issuer.getProvider(), issuerBundle.getCredentials(), issuerBundle.getOrganizationDetails(), issuerBundle.getAttributes(), context), CertificateIssuerHelper::createCertificateIssuer, ex -> ex);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateContact> setContacts(List<CertificateContact> contacts) {
        return this.setContacts(contacts, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateContact> setContacts(List<CertificateContact> contacts, Context context) {
        return new PagedIterable(() -> CertificateAsyncClient.mapContactsToPagedResponse(this.implClient.setCertificateContactsWithResponse(this.vaultUrl, new Contacts().setContactList(contacts), context)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateContact> listContacts() {
        return this.listContacts(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateContact> listContacts(Context context) {
        return new PagedIterable(() -> CertificateAsyncClient.mapContactsToPagedResponse(this.implClient.getCertificateContactsWithResponse(this.vaultUrl, context)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateContact> deleteContacts() {
        return this.deleteContacts(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateContact> deleteContacts(Context context) {
        return new PagedIterable(() -> CertificateAsyncClient.mapContactsToPagedResponse(this.implClient.deleteCertificateContactsWithResponse(this.vaultUrl, context)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateOperation deleteCertificateOperation(String certificateName) {
        return (CertificateOperation)this.deleteCertificateOperationWithResponse(certificateName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateOperation> deleteCertificateOperationWithResponse(String certificateName, Context context) {
        return CertificateClient.callWithMappedResponseAndException(() -> this.implClient.deleteCertificateOperationWithResponse(this.vaultUrl, certificateName, context), CertificateOperationHelper::createCertificateOperation, CertificateAsyncClient::mapDeleteCertificateOperationException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateOperation cancelCertificateOperation(String certificateName) {
        return (CertificateOperation)this.cancelCertificateOperationWithResponse(certificateName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateOperation> cancelCertificateOperationWithResponse(String certificateName, Context context) {
        return CertificateClient.callWithMappedResponseAndException(() -> this.implClient.updateCertificateOperationWithResponse(this.vaultUrl, certificateName, true, context), CertificateOperationHelper::createCertificateOperation, CertificateAsyncClient::mapUpdateCertificateOperationException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultCertificateWithPolicy mergeCertificate(MergeCertificateOptions mergeCertificateOptions) {
        return (KeyVaultCertificateWithPolicy)this.mergeCertificateWithResponse(mergeCertificateOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultCertificateWithPolicy> mergeCertificateWithResponse(MergeCertificateOptions mergeCertificateOptions, Context context) {
        if (mergeCertificateOptions == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'mergeCertificateOptions' cannot be null."));
        }
        return CertificateClient.callWithMappedResponseAndException(() -> this.implClient.mergeCertificateWithResponse(this.vaultUrl, mergeCertificateOptions.getName(), mergeCertificateOptions.getX509Certificates(), new CertificateAttributes().setEnabled(mergeCertificateOptions.isEnabled()), mergeCertificateOptions.getTags(), context), KeyVaultCertificateWithPolicyHelper::createCertificateWithPolicy, ex -> ex);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultCertificateWithPolicy importCertificate(ImportCertificateOptions importCertificateOptions) {
        return (KeyVaultCertificateWithPolicy)this.importCertificateWithResponse(importCertificateOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultCertificateWithPolicy> importCertificateWithResponse(ImportCertificateOptions importCertificateOptions, Context context) {
        if (importCertificateOptions == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'importCertificateOptions' cannot be null."));
        }
        com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy implPolicy = CertificatePolicyHelper.getImplCertificatePolicy(importCertificateOptions.getPolicy());
        return CertificateClient.callWithMappedResponseAndException(() -> this.implClient.importCertificateWithResponse(this.vaultUrl, importCertificateOptions.getName(), CertificateAsyncClient.transformCertificateForImport(importCertificateOptions), importCertificateOptions.getPassword(), implPolicy, implPolicy == null ? null : implPolicy.getAttributes(), importCertificateOptions.getTags(), context), KeyVaultCertificateWithPolicyHelper::createCertificateWithPolicy, ex -> ex);
    }

    private static <T> T callWithMappedException(Supplier<T> apiCall, Function<KeyVaultErrorException, HttpResponseException> exceptionMapper) {
        try {
            return apiCall.get();
        }
        catch (KeyVaultErrorException ex) {
            throw exceptionMapper.apply(ex);
        }
    }

    private static <T, R> Response<R> callWithMappedResponseAndException(Supplier<Response<T>> apiCall, Function<T, R> responseValueMapper, Function<KeyVaultErrorException, HttpResponseException> exceptionMapper) {
        try {
            Response<T> responseInn = apiCall.get();
            return new SimpleResponse(responseInn, responseValueMapper.apply(responseInn.getValue()));
        }
        catch (KeyVaultErrorException ex) {
            throw exceptionMapper.apply(ex);
        }
    }
}

