/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.implementation.CertificateOperationHelper;
import com.azure.security.keyvault.certificates.implementation.CertificatesUtils;
import com.azure.security.keyvault.certificates.implementation.IdMetadata;
import com.azure.security.keyvault.certificates.models.CertificateOperationError;
import java.io.IOException;

public final class CertificateOperation
implements JsonSerializable<CertificateOperation> {
    private static final ClientLogger LOGGER = new ClientLogger(CertificateOperation.class);
    private final com.azure.security.keyvault.certificates.implementation.models.CertificateOperation impl;
    private final String vaultUrl;
    private final String name;

    public CertificateOperation() {
        this(new com.azure.security.keyvault.certificates.implementation.models.CertificateOperation());
    }

    private CertificateOperation(com.azure.security.keyvault.certificates.implementation.models.CertificateOperation impl) {
        this.impl = impl;
        IdMetadata idMetadata = CertificatesUtils.getIdMetadata(impl.getId(), 1, 2, -1, LOGGER);
        this.vaultUrl = idMetadata.getVaultUrl();
        this.name = idMetadata.getName();
    }

    public String getId() {
        return this.impl.getId();
    }

    public String getIssuerName() {
        return this.impl.getIssuerParameters() == null ? null : this.impl.getIssuerParameters().getName();
    }

    public String getCertificateType() {
        return this.impl.getIssuerParameters() == null ? null : this.impl.getIssuerParameters().getCertificateType();
    }

    public boolean isCertificateTransparent() {
        return this.impl.getIssuerParameters() != null && this.impl.getIssuerParameters().isCertificateTransparency() != false;
    }

    public byte[] getCsr() {
        return this.impl.getCsr();
    }

    public Boolean getCancellationRequested() {
        return this.impl.isCancellationRequested();
    }

    public String getStatus() {
        return this.impl.getStatus();
    }

    public String getStatusDetails() {
        return this.impl.getStatusDetails();
    }

    public CertificateOperationError getError() {
        return this.impl.getError();
    }

    public String getTarget() {
        return this.impl.getTarget();
    }

    public String getRequestId() {
        return this.impl.getRequestId();
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    public String getName() {
        return this.name;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return this.impl.toJson(jsonWriter);
    }

    public static CertificateOperation fromJson(JsonReader jsonReader) throws IOException {
        return new CertificateOperation(com.azure.security.keyvault.certificates.implementation.models.CertificateOperation.fromJson(jsonReader));
    }

    static {
        CertificateOperationHelper.setAccessor(CertificateOperation::new);
    }
}

