// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.security.keyvault.certificates.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/** Elliptic curve name. For valid values, see JsonWebKeyCurveName. */
public final class CertificateKeyCurveName extends ExpandableStringEnum<CertificateKeyCurveName> {

    /** The NIST P-256 elliptic curve, AKA SECG curve SECP256R1. */
    public static final CertificateKeyCurveName P_256 = fromString("P-256");

    /** The NIST P-384 elliptic curve, AKA SECG curve SECP384R1. */
    public static final CertificateKeyCurveName P_384 = fromString("P-384");

    /** The NIST P-521 elliptic curve, AKA SECG curve SECP521R1. */
    public static final CertificateKeyCurveName P_521 = fromString("P-521");

    /** The SECG SECP256K1 elliptic curve. */
    public static final CertificateKeyCurveName P_256K = fromString("P-256K");

    /**
     * Creates a new instance of CertificateKeyCurveName value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public CertificateKeyCurveName() {}

    /**
     * Creates or finds a CertificateKeyCurveName from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding CertificateKeyCurveName.
     */
    public static CertificateKeyCurveName fromString(String name) {
        return fromString(name, CertificateKeyCurveName.class);
    }

    /**
     * Gets known CertificateKeyCurveName values.
     *
     * @return known CertificateKeyCurveName values.
     */
    public static Collection<CertificateKeyCurveName> values() {
        return values(CertificateKeyCurveName.class);
    }
}
