// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.models.CertificateContact;
import java.io.IOException;
import java.util.List;

/** The contacts for the vault certificates. */
@Fluent
public final class Contacts implements JsonSerializable<Contacts> {
    /*
     * Identifier for the contacts collection.
     */
    private String id;

    /*
     * The contact list for the vault certificates.
     */
    private List<CertificateContact> contactList;

    /** Creates an instance of Contacts class. */
    public Contacts() {}

    /**
     * Get the id property: Identifier for the contacts collection.
     *
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Get the contactList property: The contact list for the vault certificates.
     *
     * @return the contactList value.
     */
    public List<CertificateContact> getContactList() {
        return this.contactList;
    }

    /**
     * Set the contactList property: The contact list for the vault certificates.
     *
     * @param contactList the contactList value to set.
     * @return the Contacts object itself.
     */
    public Contacts setContactList(List<CertificateContact> contactList) {
        this.contactList = contactList;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("contacts", this.contactList, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Contacts from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of Contacts if the JsonReader was pointing to an instance of it, or null if it was pointing
     *     to JSON null.
     * @throws IOException If an error occurs while reading the Contacts.
     */
    public static Contacts fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    Contacts deserializedContacts = new Contacts();
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();

                        if ("id".equals(fieldName)) {
                            deserializedContacts.id = reader.getString();
                        } else if ("contacts".equals(fieldName)) {
                            List<CertificateContact> contactList =
                                    reader.readArray(reader1 -> CertificateContact.fromJson(reader1));
                            deserializedContacts.contactList = contactList;
                        } else {
                            reader.skipChildren();
                        }
                    }

                    return deserializedContacts;
                });
    }
}
