// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.certificates.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/** Details of the organization administrator of the certificate issuer. */
@Fluent
public final class AdministratorContact implements JsonSerializable<AdministratorContact> {
    /*
     * First name.
     */
    private String firstName;

    /*
     * Last name.
     */
    private String lastName;

    /*
     * Email address.
     */
    private String email;

    /*
     * Phone number.
     */
    private String phone;

    /** Creates an instance of AdministratorContact class. */
    public AdministratorContact() {}

    /**
     * Get the firstName property: First name.
     *
     * @return the firstName value.
     */
    public String getFirstName() {
        return this.firstName;
    }

    /**
     * Set the firstName property: First name.
     *
     * @param firstName the firstName value to set.
     * @return the AdministratorContact object itself.
     */
    public AdministratorContact setFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    /**
     * Get the lastName property: Last name.
     *
     * @return the lastName value.
     */
    public String getLastName() {
        return this.lastName;
    }

    /**
     * Set the lastName property: Last name.
     *
     * @param lastName the lastName value to set.
     * @return the AdministratorContact object itself.
     */
    public AdministratorContact setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    /**
     * Get the email property: Email address.
     *
     * @return the email value.
     */
    public String getEmail() {
        return this.email;
    }

    /**
     * Set the email property: Email address.
     *
     * @param email the email value to set.
     * @return the AdministratorContact object itself.
     */
    public AdministratorContact setEmail(String email) {
        this.email = email;
        return this;
    }

    /**
     * Get the phone property: Phone number.
     *
     * @return the phone value.
     */
    public String getPhone() {
        return this.phone;
    }

    /**
     * Set the phone property: Phone number.
     *
     * @param phone the phone value to set.
     * @return the AdministratorContact object itself.
     */
    public AdministratorContact setPhone(String phone) {
        this.phone = phone;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("first_name", this.firstName);
        jsonWriter.writeStringField("last_name", this.lastName);
        jsonWriter.writeStringField("email", this.email);
        jsonWriter.writeStringField("phone", this.phone);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AdministratorContact from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AdministratorContact if the JsonReader was pointing to an instance of it, or null if it
     *     was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AdministratorContact.
     */
    public static AdministratorContact fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    AdministratorContact deserializedAdministratorContact = new AdministratorContact();
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();

                        if ("first_name".equals(fieldName)) {
                            deserializedAdministratorContact.firstName = reader.getString();
                        } else if ("last_name".equals(fieldName)) {
                            deserializedAdministratorContact.lastName = reader.getString();
                        } else if ("email".equals(fieldName)) {
                            deserializedAdministratorContact.email = reader.getString();
                        } else if ("phone".equals(fieldName)) {
                            deserializedAdministratorContact.phone = reader.getString();
                        } else {
                            reader.skipChildren();
                        }
                    }

                    return deserializedAdministratorContact;
                });
    }
}
