/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import com.azure.security.keyvault.certificates.CertificateClientBuilder;
import com.azure.security.keyvault.certificates.implementation.CertificateClientImpl;
import com.azure.security.keyvault.certificates.implementation.CertificateIssuerHelper;
import com.azure.security.keyvault.certificates.implementation.CertificateOperationHelper;
import com.azure.security.keyvault.certificates.implementation.CertificatePolicyHelper;
import com.azure.security.keyvault.certificates.implementation.CertificatePropertiesHelper;
import com.azure.security.keyvault.certificates.implementation.DeletedCertificateHelper;
import com.azure.security.keyvault.certificates.implementation.IssuerPropertiesHelper;
import com.azure.security.keyvault.certificates.implementation.KeyVaultCertificateWithPolicyHelper;
import com.azure.security.keyvault.certificates.implementation.models.BackupCertificateResult;
import com.azure.security.keyvault.certificates.implementation.models.CertificateAttributes;
import com.azure.security.keyvault.certificates.implementation.models.CertificateBundle;
import com.azure.security.keyvault.certificates.implementation.models.CertificateIssuerItem;
import com.azure.security.keyvault.certificates.implementation.models.CertificateItem;
import com.azure.security.keyvault.certificates.implementation.models.Contacts;
import com.azure.security.keyvault.certificates.implementation.models.DeletedCertificateBundle;
import com.azure.security.keyvault.certificates.implementation.models.DeletedCertificateItem;
import com.azure.security.keyvault.certificates.implementation.models.IssuerBundle;
import com.azure.security.keyvault.certificates.implementation.models.KeyVaultErrorException;
import com.azure.security.keyvault.certificates.models.CertificateContact;
import com.azure.security.keyvault.certificates.models.CertificateContentType;
import com.azure.security.keyvault.certificates.models.CertificateIssuer;
import com.azure.security.keyvault.certificates.models.CertificateOperation;
import com.azure.security.keyvault.certificates.models.CertificatePolicy;
import com.azure.security.keyvault.certificates.models.CertificateProperties;
import com.azure.security.keyvault.certificates.models.DeletedCertificate;
import com.azure.security.keyvault.certificates.models.ImportCertificateOptions;
import com.azure.security.keyvault.certificates.models.IssuerProperties;
import com.azure.security.keyvault.certificates.models.KeyVaultCertificate;
import com.azure.security.keyvault.certificates.models.KeyVaultCertificateWithPolicy;
import com.azure.security.keyvault.certificates.models.MergeCertificateOptions;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import reactor.core.publisher.Mono;

@ServiceClient(builder=CertificateClientBuilder.class, isAsync=true, serviceInterfaces={CertificateClientImpl.CertificateClientService.class})
public final class CertificateAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(CertificateAsyncClient.class);
    private final CertificateClientImpl implClient;
    private final String vaultUrl;

    CertificateAsyncClient(CertificateClientImpl implClient, String vaultUrl) {
        this.implClient = implClient;
        this.vaultUrl = vaultUrl;
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    HttpPipeline getHttpPipeline() {
        return this.implClient.getHttpPipeline();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<CertificateOperation, KeyVaultCertificateWithPolicy> beginCreateCertificate(String certificateName, CertificatePolicy policy, Boolean isEnabled, Map<String, String> tags) {
        if (policy == null) {
            return PollerFlux.error((Exception)LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'policy' cannot be null.")));
        }
        return new PollerFlux(Duration.ofSeconds(1L), ignored -> this.createCertificateActivation(certificateName, policy, isEnabled, tags), ignored -> this.certificatePollOperation(certificateName), (ignored1, ignored2) -> this.certificateCancellationOperation(certificateName), ignored -> this.fetchCertificateOperation(certificateName));
    }

    private Mono<CertificateOperation> createCertificateActivation(String certificateName, CertificatePolicy policy, Boolean isEnabled, Map<String, String> tags) {
        com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy implPolicy = CertificatePolicyHelper.getImplCertificatePolicy(policy);
        return this.implClient.createCertificateAsync(this.vaultUrl, certificateName, implPolicy, new CertificateAttributes().setEnabled(isEnabled), tags).onErrorMap(KeyVaultErrorException.class, CertificateAsyncClient::mapCreateCertificateException).map(CertificateOperationHelper::createCertificateOperation);
    }

    static HttpResponseException mapCreateCertificateException(KeyVaultErrorException ex) {
        return ex.getResponse().getStatusCode() == 400 ? new ResourceModifiedException(ex.getMessage(), ex.getResponse(), (Object)ex.getValue()) : ex;
    }

    private Mono<PollResponse<CertificateOperation>> certificatePollOperation(String certificateName) {
        return this.implClient.getCertificateOperationAsync(this.vaultUrl, certificateName).onErrorMap(KeyVaultErrorException.class, CertificateAsyncClient::mapGetCertificateOperationException).map(CertificateAsyncClient::processCertificateOperationResponse);
    }

    static HttpResponseException mapGetCertificateOperationException(KeyVaultErrorException ex) {
        if (ex.getResponse().getStatusCode() == 404) {
            return new ResourceNotFoundException(ex.getMessage(), ex.getResponse(), (Object)ex.getValue());
        }
        if (ex.getResponse().getStatusCode() == 400) {
            return new ResourceModifiedException(ex.getMessage(), ex.getResponse(), (Object)ex.getValue());
        }
        return ex;
    }

    static PollResponse<CertificateOperation> processCertificateOperationResponse(com.azure.security.keyvault.certificates.implementation.models.CertificateOperation impl) {
        return new PollResponse(CertificateAsyncClient.mapStatus(impl.getStatus()), (Object)CertificateOperationHelper.createCertificateOperation(impl));
    }

    private static LongRunningOperationStatus mapStatus(String status) {
        switch (status) {
            case "inProgress": {
                return LongRunningOperationStatus.IN_PROGRESS;
            }
            case "completed": {
                return LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
            }
            case "failed": {
                return LongRunningOperationStatus.FAILED;
            }
        }
        return LongRunningOperationStatus.fromString((String)status, (boolean)true);
    }

    private Mono<CertificateOperation> certificateCancellationOperation(String certificateName) {
        return this.implClient.updateCertificateOperationAsync(this.vaultUrl, certificateName, true).onErrorMap(KeyVaultErrorException.class, CertificateAsyncClient::mapUpdateCertificateOperationException).map(CertificateOperationHelper::createCertificateOperation);
    }

    static HttpResponseException mapUpdateCertificateOperationException(KeyVaultErrorException ex) {
        if (ex.getResponse().getStatusCode() == 404) {
            return new ResourceNotFoundException(ex.getMessage(), ex.getResponse(), (Object)ex.getValue());
        }
        if (ex.getResponse().getStatusCode() == 400) {
            return new ResourceModifiedException(ex.getMessage(), ex.getResponse(), (Object)ex.getValue());
        }
        return ex;
    }

    private Mono<KeyVaultCertificateWithPolicy> fetchCertificateOperation(String certificateName) {
        return this.implClient.getCertificateAsync(this.vaultUrl, certificateName, null).onErrorMap(KeyVaultErrorException.class, CertificateAsyncClient::mapGetCertificateException).map(KeyVaultCertificateWithPolicyHelper::createCertificateWithPolicy);
    }

    static HttpResponseException mapGetCertificateException(KeyVaultErrorException ex) {
        if (ex.getResponse().getStatusCode() == 404) {
            return new ResourceNotFoundException(ex.getMessage(), ex.getResponse(), (Object)ex.getValue());
        }
        if (ex.getResponse().getStatusCode() == 403) {
            return new ResourceModifiedException(ex.getMessage(), ex.getResponse(), (Object)ex.getValue());
        }
        return ex;
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<CertificateOperation, KeyVaultCertificateWithPolicy> beginCreateCertificate(String certificateName, CertificatePolicy policy) {
        return this.beginCreateCertificate(certificateName, policy, true, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<CertificateOperation, KeyVaultCertificateWithPolicy> getCertificateOperation(String certificateName) {
        return new PollerFlux(Duration.ofSeconds(1L), pollingContext -> Mono.empty(), ignored -> this.certificatePollOperation(certificateName), (ignored1, ignored2) -> this.certificateCancellationOperation(certificateName), ignored -> this.fetchCertificateOperation(certificateName));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultCertificateWithPolicy> getCertificate(String certificateName) {
        return this.getCertificateWithResponse(certificateName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultCertificateWithPolicy>> getCertificateWithResponse(String certificateName) {
        try {
            return this.implClient.getCertificateWithResponseAsync(this.vaultUrl, certificateName, null).onErrorMap(KeyVaultErrorException.class, CertificateAsyncClient::mapGetCertificateException).map(response -> new SimpleResponse(response, (Object)KeyVaultCertificateWithPolicyHelper.createCertificateWithPolicy((CertificateBundle)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultCertificate>> getCertificateVersionWithResponse(String certificateName, String version) {
        try {
            return this.implClient.getCertificateWithResponseAsync(this.vaultUrl, certificateName, version).onErrorMap(KeyVaultErrorException.class, CertificateAsyncClient::mapGetCertificateException).map(response -> new SimpleResponse(response, (Object)KeyVaultCertificateWithPolicyHelper.createCertificateWithPolicy((CertificateBundle)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultCertificate> getCertificateVersion(String certificateName, String version) {
        return this.getCertificateVersionWithResponse(certificateName, version).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultCertificate> updateCertificateProperties(CertificateProperties properties) {
        return this.updateCertificatePropertiesWithResponse(properties).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultCertificate>> updateCertificatePropertiesWithResponse(CertificateProperties properties) {
        if (properties == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'properties' cannot be null."));
        }
        try {
            CertificateAttributes certificateAttributes = new CertificateAttributes().setEnabled(properties.isEnabled()).setExpires(properties.getExpiresOn()).setNotBefore(properties.getNotBefore());
            return this.implClient.updateCertificateWithResponseAsync(this.vaultUrl, properties.getName(), properties.getVersion(), null, certificateAttributes, properties.getTags()).map(response -> new SimpleResponse(response, (Object)KeyVaultCertificateWithPolicyHelper.createCertificateWithPolicy((CertificateBundle)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DeletedCertificate, Void> beginDeleteCertificate(String certificateName) {
        return new PollerFlux(Duration.ofSeconds(1L), ignored -> this.deleteCertificateActivation(certificateName), pollingContext -> this.deleteCertificatePollOperation(certificateName, (PollingContext<DeletedCertificate>)pollingContext), (pollingContext, firstResponse) -> Mono.empty(), pollingContext -> Mono.empty());
    }

    private Mono<DeletedCertificate> deleteCertificateActivation(String certificateName) {
        return this.implClient.deleteCertificateAsync(this.vaultUrl, certificateName).onErrorMap(KeyVaultErrorException.class, CertificateAsyncClient::mapDeleteCertificateException).map(DeletedCertificateHelper::createDeletedCertificate);
    }

    static HttpResponseException mapDeleteCertificateException(KeyVaultErrorException ex) {
        return ex.getResponse().getStatusCode() == 404 ? new ResourceNotFoundException(ex.getMessage(), ex.getResponse(), (Object)ex.getValue()) : ex;
    }

    private Mono<PollResponse<DeletedCertificate>> deleteCertificatePollOperation(String certificateName, PollingContext<DeletedCertificate> pollingContext) {
        return this.implClient.getDeletedCertificateAsync(this.vaultUrl, certificateName).map(bundle -> new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)DeletedCertificateHelper.createDeletedCertificate(bundle))).onErrorResume(KeyVaultErrorException.class, ex -> {
            if (ex.getResponse().getStatusCode() == 404) {
                return Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((DeletedCertificate)pollingContext.getLatestResponse().getValue())));
            }
            return Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedCertificate)pollingContext.getLatestResponse().getValue())));
        }).onErrorReturn((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedCertificate)pollingContext.getLatestResponse().getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeletedCertificate> getDeletedCertificate(String certificateName) {
        return this.getDeletedCertificateWithResponse(certificateName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeletedCertificate>> getDeletedCertificateWithResponse(String certificateName) {
        try {
            return this.implClient.getDeletedCertificateWithResponseAsync(this.vaultUrl, certificateName).onErrorMap(KeyVaultErrorException.class, CertificateAsyncClient::mapGetDeletedCertificateException).map(response -> new SimpleResponse(response, (Object)DeletedCertificateHelper.createDeletedCertificate((DeletedCertificateBundle)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    static HttpResponseException mapGetDeletedCertificateException(KeyVaultErrorException ex) {
        return ex.getResponse().getStatusCode() == 404 ? new ResourceNotFoundException(ex.getMessage(), ex.getResponse(), (Object)ex.getValue()) : ex;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> purgeDeletedCertificate(String certificateName) {
        return this.purgeDeletedCertificateWithResponse(certificateName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> purgeDeletedCertificateWithResponse(String certificateName) {
        try {
            return this.implClient.purgeDeletedCertificateWithResponseAsync(this.vaultUrl, certificateName).onErrorMap(KeyVaultErrorException.class, CertificateAsyncClient::mapPurgeDeletedCertificateException);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    static HttpResponseException mapPurgeDeletedCertificateException(KeyVaultErrorException ex) {
        return ex.getResponse().getStatusCode() == 404 ? new ResourceNotFoundException(ex.getMessage(), ex.getResponse(), (Object)ex.getValue()) : ex;
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<KeyVaultCertificateWithPolicy, Void> beginRecoverDeletedCertificate(String certificateName) {
        return new PollerFlux(Duration.ofSeconds(1L), ignored -> this.recoverDeletedCertificateActivation(certificateName), pollingContext -> this.recoverDeletedCertificatePollOperation(certificateName, (PollingContext<KeyVaultCertificateWithPolicy>)pollingContext), (pollingContext, firstResponse) -> Mono.empty(), pollingContext -> Mono.empty());
    }

    private Mono<KeyVaultCertificateWithPolicy> recoverDeletedCertificateActivation(String certificateName) {
        return this.implClient.recoverDeletedCertificateAsync(this.vaultUrl, certificateName).onErrorMap(KeyVaultErrorException.class, CertificateAsyncClient::mapRecoverDeletedCertificateException).map(KeyVaultCertificateWithPolicyHelper::createCertificateWithPolicy);
    }

    static HttpResponseException mapRecoverDeletedCertificateException(KeyVaultErrorException ex) {
        return ex.getResponse().getStatusCode() == 404 ? new ResourceNotFoundException(ex.getMessage(), ex.getResponse(), (Object)ex.getValue()) : ex;
    }

    private Mono<PollResponse<KeyVaultCertificateWithPolicy>> recoverDeletedCertificatePollOperation(String certificateName, PollingContext<KeyVaultCertificateWithPolicy> pollingContext) {
        return this.implClient.getCertificateAsync(this.vaultUrl, certificateName, null).map(bundle -> new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)KeyVaultCertificateWithPolicyHelper.createCertificateWithPolicy(bundle))).onErrorResume(KeyVaultErrorException.class, ex -> {
            if (ex.getResponse().getStatusCode() == 404) {
                return Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((KeyVaultCertificateWithPolicy)pollingContext.getLatestResponse().getValue())));
            }
            return Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultCertificateWithPolicy)pollingContext.getLatestResponse().getValue())));
        }).onErrorReturn((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultCertificateWithPolicy)pollingContext.getLatestResponse().getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<byte[]> backupCertificate(String certificateName) {
        return this.backupCertificateWithResponse(certificateName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<byte[]>> backupCertificateWithResponse(String certificateName) {
        try {
            return this.implClient.backupCertificateWithResponseAsync(this.vaultUrl, certificateName).onErrorMap(KeyVaultErrorException.class, CertificateAsyncClient::mapBackupCertificateException).map(response -> new SimpleResponse(response, (Object)((BackupCertificateResult)response.getValue()).getValue()));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    static HttpResponseException mapBackupCertificateException(KeyVaultErrorException ex) {
        return ex.getResponse().getStatusCode() == 404 ? new ResourceNotFoundException(ex.getMessage(), ex.getResponse(), (Object)ex.getValue()) : ex;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultCertificateWithPolicy> restoreCertificateBackup(byte[] backup) {
        return this.restoreCertificateBackupWithResponse(backup).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultCertificateWithPolicy>> restoreCertificateBackupWithResponse(byte[] backup) {
        try {
            return this.implClient.restoreCertificateWithResponseAsync(this.vaultUrl, backup).onErrorMap(KeyVaultErrorException.class, CertificateAsyncClient::mapRestoreCertificateException).map(response -> new SimpleResponse(response, (Object)KeyVaultCertificateWithPolicyHelper.createCertificateWithPolicy((CertificateBundle)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    static HttpResponseException mapRestoreCertificateException(KeyVaultErrorException ex) {
        return ex.getResponse().getStatusCode() == 400 ? new ResourceModifiedException(ex.getMessage(), ex.getResponse(), (Object)ex.getValue()) : ex;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CertificateProperties> listPropertiesOfCertificates(boolean includePending) {
        return new PagedFlux(maxResults -> this.implClient.getCertificatesSinglePageAsync(this.vaultUrl, (Integer)maxResults, includePending).map(CertificateAsyncClient::mapCertificateItemPage), (continuationToken, maxResults) -> this.implClient.getCertificatesNextSinglePageAsync((String)continuationToken, this.vaultUrl).map(CertificateAsyncClient::mapCertificateItemPage));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CertificateProperties> listPropertiesOfCertificates() {
        return this.listPropertiesOfCertificates(false);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeletedCertificate> listDeletedCertificates() {
        return this.listDeletedCertificates(false);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeletedCertificate> listDeletedCertificates(boolean includePending) {
        return new PagedFlux(maxResults -> this.implClient.getDeletedCertificatesSinglePageAsync(this.vaultUrl, (Integer)maxResults, includePending).map(CertificateAsyncClient::mapDeletedCertificateItemPage), (continuationToken, maxResults) -> this.implClient.getDeletedCertificatesNextSinglePageAsync((String)continuationToken, this.vaultUrl).map(CertificateAsyncClient::mapDeletedCertificateItemPage));
    }

    static PagedResponse<DeletedCertificate> mapDeletedCertificateItemPage(PagedResponse<DeletedCertificateItem> page) {
        return CertificateAsyncClient.mapPagedResponse(page, DeletedCertificateHelper::createDeletedCertificate);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CertificateProperties> listPropertiesOfCertificateVersions(String certificateName) {
        return new PagedFlux(maxResults -> this.implClient.getCertificateVersionsSinglePageAsync(this.vaultUrl, certificateName, (Integer)maxResults).map(CertificateAsyncClient::mapCertificateItemPage), (continuationToken, maxResults) -> this.implClient.getCertificateVersionsNextSinglePageAsync((String)continuationToken, this.vaultUrl).map(CertificateAsyncClient::mapCertificateItemPage));
    }

    static PagedResponse<CertificateProperties> mapCertificateItemPage(PagedResponse<CertificateItem> page) {
        return CertificateAsyncClient.mapPagedResponse(page, CertificatePropertiesHelper::createCertificateProperties);
    }

    private static <T, R> PagedResponse<R> mapPagedResponse(PagedResponse<T> page, Function<T, R> itemMapper) {
        ArrayList<R> mappedValues = new ArrayList<R>(page.getValue().size());
        for (Object item : page.getValue()) {
            mappedValues.add(itemMapper.apply(item));
        }
        return new PagedResponseBase(page.getRequest(), page.getStatusCode(), page.getHeaders(), mappedValues, (String)page.getContinuationToken(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultCertificate> mergeCertificate(MergeCertificateOptions mergeCertificateOptions) {
        return this.mergeCertificateWithResponse(mergeCertificateOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultCertificateWithPolicy>> mergeCertificateWithResponse(MergeCertificateOptions mergeCertificateOptions) {
        if (mergeCertificateOptions == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'mergeCertificateOptions' cannot be null."));
        }
        try {
            return this.implClient.mergeCertificateWithResponseAsync(this.vaultUrl, mergeCertificateOptions.getName(), mergeCertificateOptions.getX509Certificates(), new CertificateAttributes().setEnabled(mergeCertificateOptions.isEnabled()), mergeCertificateOptions.getTags()).map(response -> new SimpleResponse(response, (Object)KeyVaultCertificateWithPolicyHelper.createCertificateWithPolicy((CertificateBundle)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificatePolicy> getCertificatePolicy(String certificateName) {
        return this.getCertificatePolicyWithResponse(certificateName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificatePolicy>> getCertificatePolicyWithResponse(String certificateName) {
        try {
            return this.implClient.getCertificatePolicyWithResponseAsync(this.vaultUrl, certificateName).onErrorMap(KeyVaultErrorException.class, CertificateAsyncClient::mapGetCertificatePolicyException).map(response -> new SimpleResponse(response, (Object)CertificatePolicyHelper.createCertificatePolicy((com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    static HttpResponseException mapGetCertificatePolicyException(KeyVaultErrorException ex) {
        if (ex.getResponse().getStatusCode() == 404) {
            return new ResourceNotFoundException(ex.getMessage(), ex.getResponse(), (Object)ex.getValue());
        }
        if (ex.getResponse().getStatusCode() == 403) {
            return new ResourceModifiedException(ex.getMessage(), ex.getResponse(), (Object)ex.getValue());
        }
        return ex;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificatePolicy> updateCertificatePolicy(String certificateName, CertificatePolicy policy) {
        return this.updateCertificatePolicyWithResponse(certificateName, policy).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificatePolicy>> updateCertificatePolicyWithResponse(String certificateName, CertificatePolicy policy) {
        if (policy == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'policy' cannot be null."));
        }
        try {
            return this.implClient.updateCertificatePolicyWithResponseAsync(this.vaultUrl, certificateName, CertificatePolicyHelper.getImplCertificatePolicy(policy)).onErrorMap(KeyVaultErrorException.class, CertificateAsyncClient::mapUpdateCertificatePolicyException).map(response -> new SimpleResponse(response, (Object)CertificatePolicyHelper.createCertificatePolicy((com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    static HttpResponseException mapUpdateCertificatePolicyException(KeyVaultErrorException ex) {
        return ex.getResponse().getStatusCode() == 404 ? new ResourceNotFoundException(ex.getMessage(), ex.getResponse(), (Object)ex.getValue()) : ex;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateIssuer> createIssuer(CertificateIssuer issuer) {
        return this.createIssuerWithResponse(issuer).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateIssuer>> createIssuerWithResponse(CertificateIssuer issuer) {
        if (issuer == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'issuer' cannot be null."));
        }
        try {
            IssuerBundle issuerBundle = CertificateIssuerHelper.getIssuerBundle(issuer);
            return this.implClient.setCertificateIssuerWithResponseAsync(this.vaultUrl, issuer.getName(), issuer.getProvider(), issuerBundle.getCredentials(), issuerBundle.getOrganizationDetails(), issuerBundle.getAttributes()).map(response -> new SimpleResponse(response, (Object)CertificateIssuerHelper.createCertificateIssuer((IssuerBundle)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateIssuer>> getIssuerWithResponse(String issuerName) {
        try {
            return this.implClient.getCertificateIssuerWithResponseAsync(this.vaultUrl, issuerName).map(response -> new SimpleResponse(response, (Object)CertificateIssuerHelper.createCertificateIssuer((IssuerBundle)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateIssuer> getIssuer(String issuerName) {
        return this.getIssuerWithResponse(issuerName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateIssuer>> deleteIssuerWithResponse(String issuerName) {
        try {
            return this.implClient.deleteCertificateIssuerWithResponseAsync(this.vaultUrl, issuerName).onErrorMap(KeyVaultErrorException.class, CertificateAsyncClient::mapDeleteCertificateIssuerException).map(response -> new SimpleResponse(response, (Object)CertificateIssuerHelper.createCertificateIssuer((IssuerBundle)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    static HttpResponseException mapDeleteCertificateIssuerException(KeyVaultErrorException ex) {
        return ex.getResponse().getStatusCode() == 404 ? new ResourceNotFoundException(ex.getMessage(), ex.getResponse(), (Object)ex.getValue()) : ex;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateIssuer> deleteIssuer(String issuerName) {
        return this.deleteIssuerWithResponse(issuerName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<IssuerProperties> listPropertiesOfIssuers() {
        return new PagedFlux(maxResults -> this.implClient.getCertificateIssuersSinglePageAsync(this.vaultUrl, (Integer)maxResults).map(CertificateAsyncClient::mapIssuersPagedResponse), (continuationToken, maxResults) -> this.implClient.getCertificateIssuersNextSinglePageAsync((String)continuationToken, this.vaultUrl).map(CertificateAsyncClient::mapIssuersPagedResponse));
    }

    static PagedResponse<IssuerProperties> mapIssuersPagedResponse(PagedResponse<CertificateIssuerItem> page) {
        return CertificateAsyncClient.mapPagedResponse(page, IssuerPropertiesHelper::createIssuerProperties);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateIssuer> updateIssuer(CertificateIssuer issuer) {
        return this.updateIssuerWithResponse(issuer).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateIssuer>> updateIssuerWithResponse(CertificateIssuer issuer) {
        if (issuer == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'issuer' cannot be null."));
        }
        try {
            IssuerBundle issuerBundle = CertificateIssuerHelper.getIssuerBundle(issuer);
            return this.implClient.updateCertificateIssuerWithResponseAsync(this.vaultUrl, issuer.getName(), issuer.getProvider(), issuerBundle.getCredentials(), issuerBundle.getOrganizationDetails(), issuerBundle.getAttributes()).map(response -> new SimpleResponse(response, (Object)CertificateIssuerHelper.createCertificateIssuer((IssuerBundle)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CertificateContact> setContacts(List<CertificateContact> contacts) {
        return new PagedFlux(() -> this.implClient.setCertificateContactsWithResponseAsync(this.vaultUrl, new Contacts().setContactList(contacts)).map(CertificateAsyncClient::mapContactsToPagedResponse));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CertificateContact> listContacts() {
        return new PagedFlux(() -> this.implClient.getCertificateContactsWithResponseAsync(this.vaultUrl).map(CertificateAsyncClient::mapContactsToPagedResponse));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CertificateContact> deleteContacts() {
        return new PagedFlux(() -> this.implClient.deleteCertificateContactsWithResponseAsync(this.vaultUrl).map(CertificateAsyncClient::mapContactsToPagedResponse));
    }

    static PagedResponse<CertificateContact> mapContactsToPagedResponse(Response<Contacts> response) {
        return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), ((Contacts)response.getValue()).getContactList(), null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateOperation> deleteCertificateOperation(String certificateName) {
        return this.deleteCertificateOperationWithResponse(certificateName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateOperation>> deleteCertificateOperationWithResponse(String certificateName) {
        try {
            return this.implClient.deleteCertificateOperationWithResponseAsync(this.vaultUrl, certificateName).onErrorMap(KeyVaultErrorException.class, CertificateAsyncClient::mapDeleteCertificateOperationException).map(response -> new SimpleResponse(response, (Object)CertificateOperationHelper.createCertificateOperation((com.azure.security.keyvault.certificates.implementation.models.CertificateOperation)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    static HttpResponseException mapDeleteCertificateOperationException(KeyVaultErrorException ex) {
        if (ex.getResponse().getStatusCode() == 400) {
            return new ResourceModifiedException(ex.getMessage(), ex.getResponse(), (Object)ex.getValue());
        }
        if (ex.getResponse().getStatusCode() == 404) {
            return new ResourceNotFoundException(ex.getMessage(), ex.getResponse(), (Object)ex.getValue());
        }
        return ex;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateOperation> cancelCertificateOperation(String certificateName) {
        return this.cancelCertificateOperationWithResponse(certificateName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateOperation>> cancelCertificateOperationWithResponse(String certificateName) {
        try {
            return this.implClient.updateCertificateOperationWithResponseAsync(this.vaultUrl, certificateName, true).onErrorMap(KeyVaultErrorException.class, CertificateAsyncClient::mapUpdateCertificateOperationException).map(response -> new SimpleResponse(response, (Object)CertificateOperationHelper.createCertificateOperation((com.azure.security.keyvault.certificates.implementation.models.CertificateOperation)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultCertificateWithPolicy> importCertificate(ImportCertificateOptions importCertificateOptions) {
        return this.importCertificateWithResponse(importCertificateOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultCertificateWithPolicy>> importCertificateWithResponse(ImportCertificateOptions importCertificateOptions) {
        if (importCertificateOptions == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'importCertificateOptions' cannot be null."));
        }
        try {
            com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy implPolicy = CertificatePolicyHelper.getImplCertificatePolicy(importCertificateOptions.getPolicy());
            return this.implClient.importCertificateWithResponseAsync(this.vaultUrl, importCertificateOptions.getName(), CertificateAsyncClient.transformCertificateForImport(importCertificateOptions), importCertificateOptions.getPassword(), implPolicy, implPolicy == null ? null : implPolicy.getAttributes(), importCertificateOptions.getTags()).map(response -> new SimpleResponse(response, (Object)KeyVaultCertificateWithPolicyHelper.createCertificateWithPolicy((CertificateBundle)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    static String transformCertificateForImport(ImportCertificateOptions options) {
        CertificatePolicy policy = options.getPolicy();
        return policy != null && CertificateContentType.PEM.equals((Object)policy.getContentType()) ? new String(options.getCertificate(), StandardCharsets.US_ASCII) : Base64.getEncoder().encodeToString(options.getCertificate());
    }
}

