/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.security.keyvault.certificates.implementation.models.BackupCertificateResult;
import com.azure.security.keyvault.certificates.implementation.models.CertificateAttributes;
import com.azure.security.keyvault.certificates.implementation.models.CertificateBundle;
import com.azure.security.keyvault.certificates.implementation.models.CertificateCreateParameters;
import com.azure.security.keyvault.certificates.implementation.models.CertificateImportParameters;
import com.azure.security.keyvault.certificates.implementation.models.CertificateIssuerItem;
import com.azure.security.keyvault.certificates.implementation.models.CertificateIssuerListResult;
import com.azure.security.keyvault.certificates.implementation.models.CertificateIssuerSetParameters;
import com.azure.security.keyvault.certificates.implementation.models.CertificateIssuerUpdateParameters;
import com.azure.security.keyvault.certificates.implementation.models.CertificateItem;
import com.azure.security.keyvault.certificates.implementation.models.CertificateListResult;
import com.azure.security.keyvault.certificates.implementation.models.CertificateMergeParameters;
import com.azure.security.keyvault.certificates.implementation.models.CertificateOperation;
import com.azure.security.keyvault.certificates.implementation.models.CertificateOperationUpdateParameter;
import com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy;
import com.azure.security.keyvault.certificates.implementation.models.CertificateRestoreParameters;
import com.azure.security.keyvault.certificates.implementation.models.CertificateUpdateParameters;
import com.azure.security.keyvault.certificates.implementation.models.Contacts;
import com.azure.security.keyvault.certificates.implementation.models.DeletedCertificateBundle;
import com.azure.security.keyvault.certificates.implementation.models.DeletedCertificateItem;
import com.azure.security.keyvault.certificates.implementation.models.DeletedCertificateListResult;
import com.azure.security.keyvault.certificates.implementation.models.IssuerAttributes;
import com.azure.security.keyvault.certificates.implementation.models.IssuerBundle;
import com.azure.security.keyvault.certificates.implementation.models.IssuerCredentials;
import com.azure.security.keyvault.certificates.implementation.models.KeyVaultErrorException;
import com.azure.security.keyvault.certificates.implementation.models.OrganizationDetails;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class CertificateClientImpl {
    private final CertificateClientService service;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public CertificateClientImpl(String apiVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), apiVersion);
    }

    public CertificateClientImpl(HttpPipeline httpPipeline, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), apiVersion);
    }

    public CertificateClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.apiVersion = apiVersion;
        this.service = (CertificateClientService)RestProxy.create(CertificateClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<CertificateItem>> getCertificatesSinglePageAsync(String vaultBaseUrl, Integer maxresults, Boolean includePending) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCertificates(vaultBaseUrl, maxresults, includePending, this.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CertificateListResult)res.getValue()).getValue(), ((CertificateListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<CertificateItem>> getCertificatesSinglePageAsync(String vaultBaseUrl, Integer maxresults, Boolean includePending, Context context) {
        String accept = "application/json";
        return this.service.getCertificates(vaultBaseUrl, maxresults, includePending, this.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CertificateListResult)res.getValue()).getValue(), ((CertificateListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CertificateItem> getCertificatesAsync(String vaultBaseUrl, Integer maxresults, Boolean includePending) {
        return new PagedFlux(() -> this.getCertificatesSinglePageAsync(vaultBaseUrl, maxresults, includePending), nextLink -> this.getCertificatesNextSinglePageAsync((String)nextLink, vaultBaseUrl));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CertificateItem> getCertificatesAsync(String vaultBaseUrl, Integer maxresults, Boolean includePending, Context context) {
        return new PagedFlux(() -> this.getCertificatesSinglePageAsync(vaultBaseUrl, maxresults, includePending, context), nextLink -> this.getCertificatesNextSinglePageAsync((String)nextLink, vaultBaseUrl, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<CertificateItem> getCertificatesSinglePage(String vaultBaseUrl, Integer maxresults, Boolean includePending) {
        String accept = "application/json";
        Response<CertificateListResult> res = this.service.getCertificatesSync(vaultBaseUrl, maxresults, includePending, this.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CertificateListResult)res.getValue()).getValue(), ((CertificateListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<CertificateItem> getCertificatesSinglePage(String vaultBaseUrl, Integer maxresults, Boolean includePending, Context context) {
        String accept = "application/json";
        Response<CertificateListResult> res = this.service.getCertificatesSync(vaultBaseUrl, maxresults, includePending, this.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CertificateListResult)res.getValue()).getValue(), ((CertificateListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateItem> getCertificates(String vaultBaseUrl, Integer maxresults, Boolean includePending) {
        return new PagedIterable(() -> this.getCertificatesSinglePage(vaultBaseUrl, maxresults, includePending, Context.NONE), nextLink -> this.getCertificatesNextSinglePage((String)nextLink, vaultBaseUrl));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateItem> getCertificates(String vaultBaseUrl, Integer maxresults, Boolean includePending, Context context) {
        return new PagedIterable(() -> this.getCertificatesSinglePage(vaultBaseUrl, maxresults, includePending, context), nextLink -> this.getCertificatesNextSinglePage((String)nextLink, vaultBaseUrl, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeletedCertificateBundle>> deleteCertificateWithResponseAsync(String vaultBaseUrl, String certificateName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteCertificate(vaultBaseUrl, certificateName, this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeletedCertificateBundle>> deleteCertificateWithResponseAsync(String vaultBaseUrl, String certificateName, Context context) {
        String accept = "application/json";
        return this.service.deleteCertificate(vaultBaseUrl, certificateName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeletedCertificateBundle> deleteCertificateAsync(String vaultBaseUrl, String certificateName) {
        return this.deleteCertificateWithResponseAsync(vaultBaseUrl, certificateName).flatMap(res -> Mono.justOrEmpty((Object)((DeletedCertificateBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeletedCertificateBundle> deleteCertificateAsync(String vaultBaseUrl, String certificateName, Context context) {
        return this.deleteCertificateWithResponseAsync(vaultBaseUrl, certificateName, context).flatMap(res -> Mono.justOrEmpty((Object)((DeletedCertificateBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeletedCertificateBundle> deleteCertificateWithResponse(String vaultBaseUrl, String certificateName, Context context) {
        String accept = "application/json";
        return this.service.deleteCertificateSync(vaultBaseUrl, certificateName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeletedCertificateBundle deleteCertificate(String vaultBaseUrl, String certificateName) {
        return (DeletedCertificateBundle)this.deleteCertificateWithResponse(vaultBaseUrl, certificateName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Contacts>> setCertificateContactsWithResponseAsync(String vaultBaseUrl, Contacts contacts) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.setCertificateContacts(vaultBaseUrl, this.getApiVersion(), contacts, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Contacts>> setCertificateContactsWithResponseAsync(String vaultBaseUrl, Contacts contacts, Context context) {
        String accept = "application/json";
        return this.service.setCertificateContacts(vaultBaseUrl, this.getApiVersion(), contacts, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Contacts> setCertificateContactsAsync(String vaultBaseUrl, Contacts contacts) {
        return this.setCertificateContactsWithResponseAsync(vaultBaseUrl, contacts).flatMap(res -> Mono.justOrEmpty((Object)((Contacts)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Contacts> setCertificateContactsAsync(String vaultBaseUrl, Contacts contacts, Context context) {
        return this.setCertificateContactsWithResponseAsync(vaultBaseUrl, contacts, context).flatMap(res -> Mono.justOrEmpty((Object)((Contacts)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Contacts> setCertificateContactsWithResponse(String vaultBaseUrl, Contacts contacts, Context context) {
        String accept = "application/json";
        return this.service.setCertificateContactsSync(vaultBaseUrl, this.getApiVersion(), contacts, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Contacts setCertificateContacts(String vaultBaseUrl, Contacts contacts) {
        return (Contacts)this.setCertificateContactsWithResponse(vaultBaseUrl, contacts, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Contacts>> getCertificateContactsWithResponseAsync(String vaultBaseUrl) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCertificateContacts(vaultBaseUrl, this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Contacts>> getCertificateContactsWithResponseAsync(String vaultBaseUrl, Context context) {
        String accept = "application/json";
        return this.service.getCertificateContacts(vaultBaseUrl, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Contacts> getCertificateContactsAsync(String vaultBaseUrl) {
        return this.getCertificateContactsWithResponseAsync(vaultBaseUrl).flatMap(res -> Mono.justOrEmpty((Object)((Contacts)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Contacts> getCertificateContactsAsync(String vaultBaseUrl, Context context) {
        return this.getCertificateContactsWithResponseAsync(vaultBaseUrl, context).flatMap(res -> Mono.justOrEmpty((Object)((Contacts)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Contacts> getCertificateContactsWithResponse(String vaultBaseUrl, Context context) {
        String accept = "application/json";
        return this.service.getCertificateContactsSync(vaultBaseUrl, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Contacts getCertificateContacts(String vaultBaseUrl) {
        return (Contacts)this.getCertificateContactsWithResponse(vaultBaseUrl, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Contacts>> deleteCertificateContactsWithResponseAsync(String vaultBaseUrl) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteCertificateContacts(vaultBaseUrl, this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Contacts>> deleteCertificateContactsWithResponseAsync(String vaultBaseUrl, Context context) {
        String accept = "application/json";
        return this.service.deleteCertificateContacts(vaultBaseUrl, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Contacts> deleteCertificateContactsAsync(String vaultBaseUrl) {
        return this.deleteCertificateContactsWithResponseAsync(vaultBaseUrl).flatMap(res -> Mono.justOrEmpty((Object)((Contacts)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Contacts> deleteCertificateContactsAsync(String vaultBaseUrl, Context context) {
        return this.deleteCertificateContactsWithResponseAsync(vaultBaseUrl, context).flatMap(res -> Mono.justOrEmpty((Object)((Contacts)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Contacts> deleteCertificateContactsWithResponse(String vaultBaseUrl, Context context) {
        String accept = "application/json";
        return this.service.deleteCertificateContactsSync(vaultBaseUrl, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Contacts deleteCertificateContacts(String vaultBaseUrl) {
        return (Contacts)this.deleteCertificateContactsWithResponse(vaultBaseUrl, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<CertificateIssuerItem>> getCertificateIssuersSinglePageAsync(String vaultBaseUrl, Integer maxresults) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCertificateIssuers(vaultBaseUrl, maxresults, this.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CertificateIssuerListResult)res.getValue()).getValue(), ((CertificateIssuerListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<CertificateIssuerItem>> getCertificateIssuersSinglePageAsync(String vaultBaseUrl, Integer maxresults, Context context) {
        String accept = "application/json";
        return this.service.getCertificateIssuers(vaultBaseUrl, maxresults, this.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CertificateIssuerListResult)res.getValue()).getValue(), ((CertificateIssuerListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CertificateIssuerItem> getCertificateIssuersAsync(String vaultBaseUrl, Integer maxresults) {
        return new PagedFlux(() -> this.getCertificateIssuersSinglePageAsync(vaultBaseUrl, maxresults), nextLink -> this.getCertificateIssuersNextSinglePageAsync((String)nextLink, vaultBaseUrl));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CertificateIssuerItem> getCertificateIssuersAsync(String vaultBaseUrl, Integer maxresults, Context context) {
        return new PagedFlux(() -> this.getCertificateIssuersSinglePageAsync(vaultBaseUrl, maxresults, context), nextLink -> this.getCertificateIssuersNextSinglePageAsync((String)nextLink, vaultBaseUrl, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<CertificateIssuerItem> getCertificateIssuersSinglePage(String vaultBaseUrl, Integer maxresults) {
        String accept = "application/json";
        Response<CertificateIssuerListResult> res = this.service.getCertificateIssuersSync(vaultBaseUrl, maxresults, this.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CertificateIssuerListResult)res.getValue()).getValue(), ((CertificateIssuerListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<CertificateIssuerItem> getCertificateIssuersSinglePage(String vaultBaseUrl, Integer maxresults, Context context) {
        String accept = "application/json";
        Response<CertificateIssuerListResult> res = this.service.getCertificateIssuersSync(vaultBaseUrl, maxresults, this.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CertificateIssuerListResult)res.getValue()).getValue(), ((CertificateIssuerListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateIssuerItem> getCertificateIssuers(String vaultBaseUrl, Integer maxresults) {
        return new PagedIterable(() -> this.getCertificateIssuersSinglePage(vaultBaseUrl, maxresults, Context.NONE), nextLink -> this.getCertificateIssuersNextSinglePage((String)nextLink, vaultBaseUrl));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateIssuerItem> getCertificateIssuers(String vaultBaseUrl, Integer maxresults, Context context) {
        return new PagedIterable(() -> this.getCertificateIssuersSinglePage(vaultBaseUrl, maxresults, context), nextLink -> this.getCertificateIssuersNextSinglePage((String)nextLink, vaultBaseUrl, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<IssuerBundle>> setCertificateIssuerWithResponseAsync(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes) {
        String accept = "application/json";
        CertificateIssuerSetParameters parameter = new CertificateIssuerSetParameters();
        parameter.setProvider(provider);
        parameter.setCredentials(credentials);
        parameter.setOrganizationDetails(organizationDetails);
        parameter.setAttributes(attributes);
        return FluxUtil.withContext(context -> this.service.setCertificateIssuer(vaultBaseUrl, issuerName, this.getApiVersion(), parameter, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<IssuerBundle>> setCertificateIssuerWithResponseAsync(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes, Context context) {
        String accept = "application/json";
        CertificateIssuerSetParameters parameter = new CertificateIssuerSetParameters();
        parameter.setProvider(provider);
        parameter.setCredentials(credentials);
        parameter.setOrganizationDetails(organizationDetails);
        parameter.setAttributes(attributes);
        return this.service.setCertificateIssuer(vaultBaseUrl, issuerName, this.getApiVersion(), parameter, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<IssuerBundle> setCertificateIssuerAsync(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes) {
        return this.setCertificateIssuerWithResponseAsync(vaultBaseUrl, issuerName, provider, credentials, organizationDetails, attributes).flatMap(res -> Mono.justOrEmpty((Object)((IssuerBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<IssuerBundle> setCertificateIssuerAsync(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes, Context context) {
        return this.setCertificateIssuerWithResponseAsync(vaultBaseUrl, issuerName, provider, credentials, organizationDetails, attributes, context).flatMap(res -> Mono.justOrEmpty((Object)((IssuerBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IssuerBundle> setCertificateIssuerWithResponse(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes, Context context) {
        String accept = "application/json";
        CertificateIssuerSetParameters parameter = new CertificateIssuerSetParameters();
        parameter.setProvider(provider);
        parameter.setCredentials(credentials);
        parameter.setOrganizationDetails(organizationDetails);
        parameter.setAttributes(attributes);
        return this.service.setCertificateIssuerSync(vaultBaseUrl, issuerName, this.getApiVersion(), parameter, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public IssuerBundle setCertificateIssuer(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes) {
        return (IssuerBundle)this.setCertificateIssuerWithResponse(vaultBaseUrl, issuerName, provider, credentials, organizationDetails, attributes, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<IssuerBundle>> updateCertificateIssuerWithResponseAsync(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes) {
        String accept = "application/json";
        CertificateIssuerUpdateParameters parameter = new CertificateIssuerUpdateParameters();
        parameter.setProvider(provider);
        parameter.setCredentials(credentials);
        parameter.setOrganizationDetails(organizationDetails);
        parameter.setAttributes(attributes);
        return FluxUtil.withContext(context -> this.service.updateCertificateIssuer(vaultBaseUrl, issuerName, this.getApiVersion(), parameter, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<IssuerBundle>> updateCertificateIssuerWithResponseAsync(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes, Context context) {
        String accept = "application/json";
        CertificateIssuerUpdateParameters parameter = new CertificateIssuerUpdateParameters();
        parameter.setProvider(provider);
        parameter.setCredentials(credentials);
        parameter.setOrganizationDetails(organizationDetails);
        parameter.setAttributes(attributes);
        return this.service.updateCertificateIssuer(vaultBaseUrl, issuerName, this.getApiVersion(), parameter, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<IssuerBundle> updateCertificateIssuerAsync(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes) {
        return this.updateCertificateIssuerWithResponseAsync(vaultBaseUrl, issuerName, provider, credentials, organizationDetails, attributes).flatMap(res -> Mono.justOrEmpty((Object)((IssuerBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<IssuerBundle> updateCertificateIssuerAsync(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes, Context context) {
        return this.updateCertificateIssuerWithResponseAsync(vaultBaseUrl, issuerName, provider, credentials, organizationDetails, attributes, context).flatMap(res -> Mono.justOrEmpty((Object)((IssuerBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IssuerBundle> updateCertificateIssuerWithResponse(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes, Context context) {
        String accept = "application/json";
        CertificateIssuerUpdateParameters parameter = new CertificateIssuerUpdateParameters();
        parameter.setProvider(provider);
        parameter.setCredentials(credentials);
        parameter.setOrganizationDetails(organizationDetails);
        parameter.setAttributes(attributes);
        return this.service.updateCertificateIssuerSync(vaultBaseUrl, issuerName, this.getApiVersion(), parameter, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public IssuerBundle updateCertificateIssuer(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes) {
        return (IssuerBundle)this.updateCertificateIssuerWithResponse(vaultBaseUrl, issuerName, provider, credentials, organizationDetails, attributes, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<IssuerBundle>> getCertificateIssuerWithResponseAsync(String vaultBaseUrl, String issuerName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCertificateIssuer(vaultBaseUrl, issuerName, this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<IssuerBundle>> getCertificateIssuerWithResponseAsync(String vaultBaseUrl, String issuerName, Context context) {
        String accept = "application/json";
        return this.service.getCertificateIssuer(vaultBaseUrl, issuerName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<IssuerBundle> getCertificateIssuerAsync(String vaultBaseUrl, String issuerName) {
        return this.getCertificateIssuerWithResponseAsync(vaultBaseUrl, issuerName).flatMap(res -> Mono.justOrEmpty((Object)((IssuerBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<IssuerBundle> getCertificateIssuerAsync(String vaultBaseUrl, String issuerName, Context context) {
        return this.getCertificateIssuerWithResponseAsync(vaultBaseUrl, issuerName, context).flatMap(res -> Mono.justOrEmpty((Object)((IssuerBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IssuerBundle> getCertificateIssuerWithResponse(String vaultBaseUrl, String issuerName, Context context) {
        String accept = "application/json";
        return this.service.getCertificateIssuerSync(vaultBaseUrl, issuerName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public IssuerBundle getCertificateIssuer(String vaultBaseUrl, String issuerName) {
        return (IssuerBundle)this.getCertificateIssuerWithResponse(vaultBaseUrl, issuerName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<IssuerBundle>> deleteCertificateIssuerWithResponseAsync(String vaultBaseUrl, String issuerName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteCertificateIssuer(vaultBaseUrl, issuerName, this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<IssuerBundle>> deleteCertificateIssuerWithResponseAsync(String vaultBaseUrl, String issuerName, Context context) {
        String accept = "application/json";
        return this.service.deleteCertificateIssuer(vaultBaseUrl, issuerName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<IssuerBundle> deleteCertificateIssuerAsync(String vaultBaseUrl, String issuerName) {
        return this.deleteCertificateIssuerWithResponseAsync(vaultBaseUrl, issuerName).flatMap(res -> Mono.justOrEmpty((Object)((IssuerBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<IssuerBundle> deleteCertificateIssuerAsync(String vaultBaseUrl, String issuerName, Context context) {
        return this.deleteCertificateIssuerWithResponseAsync(vaultBaseUrl, issuerName, context).flatMap(res -> Mono.justOrEmpty((Object)((IssuerBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IssuerBundle> deleteCertificateIssuerWithResponse(String vaultBaseUrl, String issuerName, Context context) {
        String accept = "application/json";
        return this.service.deleteCertificateIssuerSync(vaultBaseUrl, issuerName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public IssuerBundle deleteCertificateIssuer(String vaultBaseUrl, String issuerName) {
        return (IssuerBundle)this.deleteCertificateIssuerWithResponse(vaultBaseUrl, issuerName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateOperation>> createCertificateWithResponseAsync(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        String accept = "application/json";
        CertificateCreateParameters parameters = new CertificateCreateParameters();
        parameters.setCertificatePolicy(certificatePolicy);
        parameters.setCertificateAttributes(certificateAttributes);
        parameters.setTags(tags);
        return FluxUtil.withContext(context -> this.service.createCertificate(vaultBaseUrl, certificateName, this.getApiVersion(), parameters, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateOperation>> createCertificateWithResponseAsync(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags, Context context) {
        String accept = "application/json";
        CertificateCreateParameters parameters = new CertificateCreateParameters();
        parameters.setCertificatePolicy(certificatePolicy);
        parameters.setCertificateAttributes(certificateAttributes);
        parameters.setTags(tags);
        return this.service.createCertificate(vaultBaseUrl, certificateName, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateOperation> createCertificateAsync(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        return this.createCertificateWithResponseAsync(vaultBaseUrl, certificateName, certificatePolicy, certificateAttributes, tags).flatMap(res -> Mono.justOrEmpty((Object)((CertificateOperation)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateOperation> createCertificateAsync(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags, Context context) {
        return this.createCertificateWithResponseAsync(vaultBaseUrl, certificateName, certificatePolicy, certificateAttributes, tags, context).flatMap(res -> Mono.justOrEmpty((Object)((CertificateOperation)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateOperation> createCertificateWithResponse(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags, Context context) {
        String accept = "application/json";
        CertificateCreateParameters parameters = new CertificateCreateParameters();
        parameters.setCertificatePolicy(certificatePolicy);
        parameters.setCertificateAttributes(certificateAttributes);
        parameters.setTags(tags);
        return this.service.createCertificateSync(vaultBaseUrl, certificateName, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateOperation createCertificate(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        return (CertificateOperation)this.createCertificateWithResponse(vaultBaseUrl, certificateName, certificatePolicy, certificateAttributes, tags, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateBundle>> importCertificateWithResponseAsync(String vaultBaseUrl, String certificateName, String base64EncodedCertificate, String password, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        String accept = "application/json";
        CertificateImportParameters parameters = new CertificateImportParameters();
        parameters.setBase64EncodedCertificate(base64EncodedCertificate);
        parameters.setPassword(password);
        parameters.setCertificatePolicy(certificatePolicy);
        parameters.setCertificateAttributes(certificateAttributes);
        parameters.setTags(tags);
        return FluxUtil.withContext(context -> this.service.importCertificate(vaultBaseUrl, certificateName, this.getApiVersion(), parameters, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateBundle>> importCertificateWithResponseAsync(String vaultBaseUrl, String certificateName, String base64EncodedCertificate, String password, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags, Context context) {
        String accept = "application/json";
        CertificateImportParameters parameters = new CertificateImportParameters();
        parameters.setBase64EncodedCertificate(base64EncodedCertificate);
        parameters.setPassword(password);
        parameters.setCertificatePolicy(certificatePolicy);
        parameters.setCertificateAttributes(certificateAttributes);
        parameters.setTags(tags);
        return this.service.importCertificate(vaultBaseUrl, certificateName, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateBundle> importCertificateAsync(String vaultBaseUrl, String certificateName, String base64EncodedCertificate, String password, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        return this.importCertificateWithResponseAsync(vaultBaseUrl, certificateName, base64EncodedCertificate, password, certificatePolicy, certificateAttributes, tags).flatMap(res -> Mono.justOrEmpty((Object)((CertificateBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateBundle> importCertificateAsync(String vaultBaseUrl, String certificateName, String base64EncodedCertificate, String password, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags, Context context) {
        return this.importCertificateWithResponseAsync(vaultBaseUrl, certificateName, base64EncodedCertificate, password, certificatePolicy, certificateAttributes, tags, context).flatMap(res -> Mono.justOrEmpty((Object)((CertificateBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateBundle> importCertificateWithResponse(String vaultBaseUrl, String certificateName, String base64EncodedCertificate, String password, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags, Context context) {
        String accept = "application/json";
        CertificateImportParameters parameters = new CertificateImportParameters();
        parameters.setBase64EncodedCertificate(base64EncodedCertificate);
        parameters.setPassword(password);
        parameters.setCertificatePolicy(certificatePolicy);
        parameters.setCertificateAttributes(certificateAttributes);
        parameters.setTags(tags);
        return this.service.importCertificateSync(vaultBaseUrl, certificateName, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateBundle importCertificate(String vaultBaseUrl, String certificateName, String base64EncodedCertificate, String password, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        return (CertificateBundle)this.importCertificateWithResponse(vaultBaseUrl, certificateName, base64EncodedCertificate, password, certificatePolicy, certificateAttributes, tags, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<CertificateItem>> getCertificateVersionsSinglePageAsync(String vaultBaseUrl, String certificateName, Integer maxresults) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCertificateVersions(vaultBaseUrl, certificateName, maxresults, this.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CertificateListResult)res.getValue()).getValue(), ((CertificateListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<CertificateItem>> getCertificateVersionsSinglePageAsync(String vaultBaseUrl, String certificateName, Integer maxresults, Context context) {
        String accept = "application/json";
        return this.service.getCertificateVersions(vaultBaseUrl, certificateName, maxresults, this.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CertificateListResult)res.getValue()).getValue(), ((CertificateListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CertificateItem> getCertificateVersionsAsync(String vaultBaseUrl, String certificateName, Integer maxresults) {
        return new PagedFlux(() -> this.getCertificateVersionsSinglePageAsync(vaultBaseUrl, certificateName, maxresults), nextLink -> this.getCertificateVersionsNextSinglePageAsync((String)nextLink, vaultBaseUrl));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CertificateItem> getCertificateVersionsAsync(String vaultBaseUrl, String certificateName, Integer maxresults, Context context) {
        return new PagedFlux(() -> this.getCertificateVersionsSinglePageAsync(vaultBaseUrl, certificateName, maxresults, context), nextLink -> this.getCertificateVersionsNextSinglePageAsync((String)nextLink, vaultBaseUrl, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<CertificateItem> getCertificateVersionsSinglePage(String vaultBaseUrl, String certificateName, Integer maxresults) {
        String accept = "application/json";
        Response<CertificateListResult> res = this.service.getCertificateVersionsSync(vaultBaseUrl, certificateName, maxresults, this.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CertificateListResult)res.getValue()).getValue(), ((CertificateListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<CertificateItem> getCertificateVersionsSinglePage(String vaultBaseUrl, String certificateName, Integer maxresults, Context context) {
        String accept = "application/json";
        Response<CertificateListResult> res = this.service.getCertificateVersionsSync(vaultBaseUrl, certificateName, maxresults, this.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CertificateListResult)res.getValue()).getValue(), ((CertificateListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateItem> getCertificateVersions(String vaultBaseUrl, String certificateName, Integer maxresults) {
        return new PagedIterable(() -> this.getCertificateVersionsSinglePage(vaultBaseUrl, certificateName, maxresults, Context.NONE), nextLink -> this.getCertificateVersionsNextSinglePage((String)nextLink, vaultBaseUrl));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateItem> getCertificateVersions(String vaultBaseUrl, String certificateName, Integer maxresults, Context context) {
        return new PagedIterable(() -> this.getCertificateVersionsSinglePage(vaultBaseUrl, certificateName, maxresults, context), nextLink -> this.getCertificateVersionsNextSinglePage((String)nextLink, vaultBaseUrl, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificatePolicy>> getCertificatePolicyWithResponseAsync(String vaultBaseUrl, String certificateName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCertificatePolicy(vaultBaseUrl, certificateName, this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificatePolicy>> getCertificatePolicyWithResponseAsync(String vaultBaseUrl, String certificateName, Context context) {
        String accept = "application/json";
        return this.service.getCertificatePolicy(vaultBaseUrl, certificateName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificatePolicy> getCertificatePolicyAsync(String vaultBaseUrl, String certificateName) {
        return this.getCertificatePolicyWithResponseAsync(vaultBaseUrl, certificateName).flatMap(res -> Mono.justOrEmpty((Object)((CertificatePolicy)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificatePolicy> getCertificatePolicyAsync(String vaultBaseUrl, String certificateName, Context context) {
        return this.getCertificatePolicyWithResponseAsync(vaultBaseUrl, certificateName, context).flatMap(res -> Mono.justOrEmpty((Object)((CertificatePolicy)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificatePolicy> getCertificatePolicyWithResponse(String vaultBaseUrl, String certificateName, Context context) {
        String accept = "application/json";
        return this.service.getCertificatePolicySync(vaultBaseUrl, certificateName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificatePolicy getCertificatePolicy(String vaultBaseUrl, String certificateName) {
        return (CertificatePolicy)this.getCertificatePolicyWithResponse(vaultBaseUrl, certificateName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificatePolicy>> updateCertificatePolicyWithResponseAsync(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateCertificatePolicy(vaultBaseUrl, certificateName, this.getApiVersion(), certificatePolicy, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificatePolicy>> updateCertificatePolicyWithResponseAsync(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy, Context context) {
        String accept = "application/json";
        return this.service.updateCertificatePolicy(vaultBaseUrl, certificateName, this.getApiVersion(), certificatePolicy, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificatePolicy> updateCertificatePolicyAsync(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy) {
        return this.updateCertificatePolicyWithResponseAsync(vaultBaseUrl, certificateName, certificatePolicy).flatMap(res -> Mono.justOrEmpty((Object)((CertificatePolicy)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificatePolicy> updateCertificatePolicyAsync(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy, Context context) {
        return this.updateCertificatePolicyWithResponseAsync(vaultBaseUrl, certificateName, certificatePolicy, context).flatMap(res -> Mono.justOrEmpty((Object)((CertificatePolicy)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificatePolicy> updateCertificatePolicyWithResponse(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy, Context context) {
        String accept = "application/json";
        return this.service.updateCertificatePolicySync(vaultBaseUrl, certificateName, this.getApiVersion(), certificatePolicy, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificatePolicy updateCertificatePolicy(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy) {
        return (CertificatePolicy)this.updateCertificatePolicyWithResponse(vaultBaseUrl, certificateName, certificatePolicy, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateBundle>> updateCertificateWithResponseAsync(String vaultBaseUrl, String certificateName, String certificateVersion, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        String accept = "application/json";
        CertificateUpdateParameters parameters = new CertificateUpdateParameters();
        parameters.setCertificatePolicy(certificatePolicy);
        parameters.setCertificateAttributes(certificateAttributes);
        parameters.setTags(tags);
        return FluxUtil.withContext(context -> this.service.updateCertificate(vaultBaseUrl, certificateName, certificateVersion, this.getApiVersion(), parameters, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateBundle>> updateCertificateWithResponseAsync(String vaultBaseUrl, String certificateName, String certificateVersion, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags, Context context) {
        String accept = "application/json";
        CertificateUpdateParameters parameters = new CertificateUpdateParameters();
        parameters.setCertificatePolicy(certificatePolicy);
        parameters.setCertificateAttributes(certificateAttributes);
        parameters.setTags(tags);
        return this.service.updateCertificate(vaultBaseUrl, certificateName, certificateVersion, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateBundle> updateCertificateAsync(String vaultBaseUrl, String certificateName, String certificateVersion, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        return this.updateCertificateWithResponseAsync(vaultBaseUrl, certificateName, certificateVersion, certificatePolicy, certificateAttributes, tags).flatMap(res -> Mono.justOrEmpty((Object)((CertificateBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateBundle> updateCertificateAsync(String vaultBaseUrl, String certificateName, String certificateVersion, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags, Context context) {
        return this.updateCertificateWithResponseAsync(vaultBaseUrl, certificateName, certificateVersion, certificatePolicy, certificateAttributes, tags, context).flatMap(res -> Mono.justOrEmpty((Object)((CertificateBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateBundle> updateCertificateWithResponse(String vaultBaseUrl, String certificateName, String certificateVersion, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags, Context context) {
        String accept = "application/json";
        CertificateUpdateParameters parameters = new CertificateUpdateParameters();
        parameters.setCertificatePolicy(certificatePolicy);
        parameters.setCertificateAttributes(certificateAttributes);
        parameters.setTags(tags);
        return this.service.updateCertificateSync(vaultBaseUrl, certificateName, certificateVersion, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateBundle updateCertificate(String vaultBaseUrl, String certificateName, String certificateVersion, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        return (CertificateBundle)this.updateCertificateWithResponse(vaultBaseUrl, certificateName, certificateVersion, certificatePolicy, certificateAttributes, tags, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateBundle>> getCertificateWithResponseAsync(String vaultBaseUrl, String certificateName, String certificateVersion) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCertificate(vaultBaseUrl, certificateName, certificateVersion, this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateBundle>> getCertificateWithResponseAsync(String vaultBaseUrl, String certificateName, String certificateVersion, Context context) {
        String accept = "application/json";
        return this.service.getCertificate(vaultBaseUrl, certificateName, certificateVersion, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateBundle> getCertificateAsync(String vaultBaseUrl, String certificateName, String certificateVersion) {
        return this.getCertificateWithResponseAsync(vaultBaseUrl, certificateName, certificateVersion).flatMap(res -> Mono.justOrEmpty((Object)((CertificateBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateBundle> getCertificateAsync(String vaultBaseUrl, String certificateName, String certificateVersion, Context context) {
        return this.getCertificateWithResponseAsync(vaultBaseUrl, certificateName, certificateVersion, context).flatMap(res -> Mono.justOrEmpty((Object)((CertificateBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateBundle> getCertificateWithResponse(String vaultBaseUrl, String certificateName, String certificateVersion, Context context) {
        String accept = "application/json";
        return this.service.getCertificateSync(vaultBaseUrl, certificateName, certificateVersion, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateBundle getCertificate(String vaultBaseUrl, String certificateName, String certificateVersion) {
        return (CertificateBundle)this.getCertificateWithResponse(vaultBaseUrl, certificateName, certificateVersion, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateOperation>> updateCertificateOperationWithResponseAsync(String vaultBaseUrl, String certificateName, boolean cancellationRequested) {
        String accept = "application/json";
        CertificateOperationUpdateParameter certificateOperation = new CertificateOperationUpdateParameter();
        certificateOperation.setCancellationRequested(cancellationRequested);
        return FluxUtil.withContext(context -> this.service.updateCertificateOperation(vaultBaseUrl, certificateName, this.getApiVersion(), certificateOperation, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateOperation>> updateCertificateOperationWithResponseAsync(String vaultBaseUrl, String certificateName, boolean cancellationRequested, Context context) {
        String accept = "application/json";
        CertificateOperationUpdateParameter certificateOperation = new CertificateOperationUpdateParameter();
        certificateOperation.setCancellationRequested(cancellationRequested);
        return this.service.updateCertificateOperation(vaultBaseUrl, certificateName, this.getApiVersion(), certificateOperation, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateOperation> updateCertificateOperationAsync(String vaultBaseUrl, String certificateName, boolean cancellationRequested) {
        return this.updateCertificateOperationWithResponseAsync(vaultBaseUrl, certificateName, cancellationRequested).flatMap(res -> Mono.justOrEmpty((Object)((CertificateOperation)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateOperation> updateCertificateOperationAsync(String vaultBaseUrl, String certificateName, boolean cancellationRequested, Context context) {
        return this.updateCertificateOperationWithResponseAsync(vaultBaseUrl, certificateName, cancellationRequested, context).flatMap(res -> Mono.justOrEmpty((Object)((CertificateOperation)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateOperation> updateCertificateOperationWithResponse(String vaultBaseUrl, String certificateName, boolean cancellationRequested, Context context) {
        String accept = "application/json";
        CertificateOperationUpdateParameter certificateOperation = new CertificateOperationUpdateParameter();
        certificateOperation.setCancellationRequested(cancellationRequested);
        return this.service.updateCertificateOperationSync(vaultBaseUrl, certificateName, this.getApiVersion(), certificateOperation, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateOperation updateCertificateOperation(String vaultBaseUrl, String certificateName, boolean cancellationRequested) {
        return (CertificateOperation)this.updateCertificateOperationWithResponse(vaultBaseUrl, certificateName, cancellationRequested, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateOperation>> getCertificateOperationWithResponseAsync(String vaultBaseUrl, String certificateName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCertificateOperation(vaultBaseUrl, certificateName, this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateOperation>> getCertificateOperationWithResponseAsync(String vaultBaseUrl, String certificateName, Context context) {
        String accept = "application/json";
        return this.service.getCertificateOperation(vaultBaseUrl, certificateName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateOperation> getCertificateOperationAsync(String vaultBaseUrl, String certificateName) {
        return this.getCertificateOperationWithResponseAsync(vaultBaseUrl, certificateName).flatMap(res -> Mono.justOrEmpty((Object)((CertificateOperation)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateOperation> getCertificateOperationAsync(String vaultBaseUrl, String certificateName, Context context) {
        return this.getCertificateOperationWithResponseAsync(vaultBaseUrl, certificateName, context).flatMap(res -> Mono.justOrEmpty((Object)((CertificateOperation)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateOperation> getCertificateOperationWithResponse(String vaultBaseUrl, String certificateName, Context context) {
        String accept = "application/json";
        return this.service.getCertificateOperationSync(vaultBaseUrl, certificateName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateOperation getCertificateOperation(String vaultBaseUrl, String certificateName) {
        return (CertificateOperation)this.getCertificateOperationWithResponse(vaultBaseUrl, certificateName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateOperation>> deleteCertificateOperationWithResponseAsync(String vaultBaseUrl, String certificateName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteCertificateOperation(vaultBaseUrl, certificateName, this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateOperation>> deleteCertificateOperationWithResponseAsync(String vaultBaseUrl, String certificateName, Context context) {
        String accept = "application/json";
        return this.service.deleteCertificateOperation(vaultBaseUrl, certificateName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateOperation> deleteCertificateOperationAsync(String vaultBaseUrl, String certificateName) {
        return this.deleteCertificateOperationWithResponseAsync(vaultBaseUrl, certificateName).flatMap(res -> Mono.justOrEmpty((Object)((CertificateOperation)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateOperation> deleteCertificateOperationAsync(String vaultBaseUrl, String certificateName, Context context) {
        return this.deleteCertificateOperationWithResponseAsync(vaultBaseUrl, certificateName, context).flatMap(res -> Mono.justOrEmpty((Object)((CertificateOperation)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateOperation> deleteCertificateOperationWithResponse(String vaultBaseUrl, String certificateName, Context context) {
        String accept = "application/json";
        return this.service.deleteCertificateOperationSync(vaultBaseUrl, certificateName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateOperation deleteCertificateOperation(String vaultBaseUrl, String certificateName) {
        return (CertificateOperation)this.deleteCertificateOperationWithResponse(vaultBaseUrl, certificateName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateBundle>> mergeCertificateWithResponseAsync(String vaultBaseUrl, String certificateName, List<byte[]> x509Certificates, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        String accept = "application/json";
        CertificateMergeParameters parameters = new CertificateMergeParameters();
        parameters.setX509Certificates(x509Certificates);
        parameters.setCertificateAttributes(certificateAttributes);
        parameters.setTags(tags);
        return FluxUtil.withContext(context -> this.service.mergeCertificate(vaultBaseUrl, certificateName, this.getApiVersion(), parameters, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateBundle>> mergeCertificateWithResponseAsync(String vaultBaseUrl, String certificateName, List<byte[]> x509Certificates, CertificateAttributes certificateAttributes, Map<String, String> tags, Context context) {
        String accept = "application/json";
        CertificateMergeParameters parameters = new CertificateMergeParameters();
        parameters.setX509Certificates(x509Certificates);
        parameters.setCertificateAttributes(certificateAttributes);
        parameters.setTags(tags);
        return this.service.mergeCertificate(vaultBaseUrl, certificateName, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateBundle> mergeCertificateAsync(String vaultBaseUrl, String certificateName, List<byte[]> x509Certificates, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        return this.mergeCertificateWithResponseAsync(vaultBaseUrl, certificateName, x509Certificates, certificateAttributes, tags).flatMap(res -> Mono.justOrEmpty((Object)((CertificateBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateBundle> mergeCertificateAsync(String vaultBaseUrl, String certificateName, List<byte[]> x509Certificates, CertificateAttributes certificateAttributes, Map<String, String> tags, Context context) {
        return this.mergeCertificateWithResponseAsync(vaultBaseUrl, certificateName, x509Certificates, certificateAttributes, tags, context).flatMap(res -> Mono.justOrEmpty((Object)((CertificateBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateBundle> mergeCertificateWithResponse(String vaultBaseUrl, String certificateName, List<byte[]> x509Certificates, CertificateAttributes certificateAttributes, Map<String, String> tags, Context context) {
        String accept = "application/json";
        CertificateMergeParameters parameters = new CertificateMergeParameters();
        parameters.setX509Certificates(x509Certificates);
        parameters.setCertificateAttributes(certificateAttributes);
        parameters.setTags(tags);
        return this.service.mergeCertificateSync(vaultBaseUrl, certificateName, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateBundle mergeCertificate(String vaultBaseUrl, String certificateName, List<byte[]> x509Certificates, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        return (CertificateBundle)this.mergeCertificateWithResponse(vaultBaseUrl, certificateName, x509Certificates, certificateAttributes, tags, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BackupCertificateResult>> backupCertificateWithResponseAsync(String vaultBaseUrl, String certificateName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.backupCertificate(vaultBaseUrl, certificateName, this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BackupCertificateResult>> backupCertificateWithResponseAsync(String vaultBaseUrl, String certificateName, Context context) {
        String accept = "application/json";
        return this.service.backupCertificate(vaultBaseUrl, certificateName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BackupCertificateResult> backupCertificateAsync(String vaultBaseUrl, String certificateName) {
        return this.backupCertificateWithResponseAsync(vaultBaseUrl, certificateName).flatMap(res -> Mono.justOrEmpty((Object)((BackupCertificateResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BackupCertificateResult> backupCertificateAsync(String vaultBaseUrl, String certificateName, Context context) {
        return this.backupCertificateWithResponseAsync(vaultBaseUrl, certificateName, context).flatMap(res -> Mono.justOrEmpty((Object)((BackupCertificateResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BackupCertificateResult> backupCertificateWithResponse(String vaultBaseUrl, String certificateName, Context context) {
        String accept = "application/json";
        return this.service.backupCertificateSync(vaultBaseUrl, certificateName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BackupCertificateResult backupCertificate(String vaultBaseUrl, String certificateName) {
        return (BackupCertificateResult)this.backupCertificateWithResponse(vaultBaseUrl, certificateName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateBundle>> restoreCertificateWithResponseAsync(String vaultBaseUrl, byte[] certificateBundleBackup) {
        String accept = "application/json";
        CertificateRestoreParameters parameters = new CertificateRestoreParameters();
        parameters.setCertificateBundleBackup(certificateBundleBackup);
        return FluxUtil.withContext(context -> this.service.restoreCertificate(vaultBaseUrl, this.getApiVersion(), parameters, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateBundle>> restoreCertificateWithResponseAsync(String vaultBaseUrl, byte[] certificateBundleBackup, Context context) {
        String accept = "application/json";
        CertificateRestoreParameters parameters = new CertificateRestoreParameters();
        parameters.setCertificateBundleBackup(certificateBundleBackup);
        return this.service.restoreCertificate(vaultBaseUrl, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateBundle> restoreCertificateAsync(String vaultBaseUrl, byte[] certificateBundleBackup) {
        return this.restoreCertificateWithResponseAsync(vaultBaseUrl, certificateBundleBackup).flatMap(res -> Mono.justOrEmpty((Object)((CertificateBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateBundle> restoreCertificateAsync(String vaultBaseUrl, byte[] certificateBundleBackup, Context context) {
        return this.restoreCertificateWithResponseAsync(vaultBaseUrl, certificateBundleBackup, context).flatMap(res -> Mono.justOrEmpty((Object)((CertificateBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateBundle> restoreCertificateWithResponse(String vaultBaseUrl, byte[] certificateBundleBackup, Context context) {
        String accept = "application/json";
        CertificateRestoreParameters parameters = new CertificateRestoreParameters();
        parameters.setCertificateBundleBackup(certificateBundleBackup);
        return this.service.restoreCertificateSync(vaultBaseUrl, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateBundle restoreCertificate(String vaultBaseUrl, byte[] certificateBundleBackup) {
        return (CertificateBundle)this.restoreCertificateWithResponse(vaultBaseUrl, certificateBundleBackup, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DeletedCertificateItem>> getDeletedCertificatesSinglePageAsync(String vaultBaseUrl, Integer maxresults, Boolean includePending) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDeletedCertificates(vaultBaseUrl, maxresults, includePending, this.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedCertificateListResult)res.getValue()).getValue(), ((DeletedCertificateListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DeletedCertificateItem>> getDeletedCertificatesSinglePageAsync(String vaultBaseUrl, Integer maxresults, Boolean includePending, Context context) {
        String accept = "application/json";
        return this.service.getDeletedCertificates(vaultBaseUrl, maxresults, includePending, this.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedCertificateListResult)res.getValue()).getValue(), ((DeletedCertificateListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeletedCertificateItem> getDeletedCertificatesAsync(String vaultBaseUrl, Integer maxresults, Boolean includePending) {
        return new PagedFlux(() -> this.getDeletedCertificatesSinglePageAsync(vaultBaseUrl, maxresults, includePending), nextLink -> this.getDeletedCertificatesNextSinglePageAsync((String)nextLink, vaultBaseUrl));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeletedCertificateItem> getDeletedCertificatesAsync(String vaultBaseUrl, Integer maxresults, Boolean includePending, Context context) {
        return new PagedFlux(() -> this.getDeletedCertificatesSinglePageAsync(vaultBaseUrl, maxresults, includePending, context), nextLink -> this.getDeletedCertificatesNextSinglePageAsync((String)nextLink, vaultBaseUrl, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DeletedCertificateItem> getDeletedCertificatesSinglePage(String vaultBaseUrl, Integer maxresults, Boolean includePending) {
        String accept = "application/json";
        Response<DeletedCertificateListResult> res = this.service.getDeletedCertificatesSync(vaultBaseUrl, maxresults, includePending, this.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedCertificateListResult)res.getValue()).getValue(), ((DeletedCertificateListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DeletedCertificateItem> getDeletedCertificatesSinglePage(String vaultBaseUrl, Integer maxresults, Boolean includePending, Context context) {
        String accept = "application/json";
        Response<DeletedCertificateListResult> res = this.service.getDeletedCertificatesSync(vaultBaseUrl, maxresults, includePending, this.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedCertificateListResult)res.getValue()).getValue(), ((DeletedCertificateListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedCertificateItem> getDeletedCertificates(String vaultBaseUrl, Integer maxresults, Boolean includePending) {
        return new PagedIterable(() -> this.getDeletedCertificatesSinglePage(vaultBaseUrl, maxresults, includePending, Context.NONE), nextLink -> this.getDeletedCertificatesNextSinglePage((String)nextLink, vaultBaseUrl));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedCertificateItem> getDeletedCertificates(String vaultBaseUrl, Integer maxresults, Boolean includePending, Context context) {
        return new PagedIterable(() -> this.getDeletedCertificatesSinglePage(vaultBaseUrl, maxresults, includePending, context), nextLink -> this.getDeletedCertificatesNextSinglePage((String)nextLink, vaultBaseUrl, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeletedCertificateBundle>> getDeletedCertificateWithResponseAsync(String vaultBaseUrl, String certificateName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDeletedCertificate(vaultBaseUrl, certificateName, this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeletedCertificateBundle>> getDeletedCertificateWithResponseAsync(String vaultBaseUrl, String certificateName, Context context) {
        String accept = "application/json";
        return this.service.getDeletedCertificate(vaultBaseUrl, certificateName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeletedCertificateBundle> getDeletedCertificateAsync(String vaultBaseUrl, String certificateName) {
        return this.getDeletedCertificateWithResponseAsync(vaultBaseUrl, certificateName).flatMap(res -> Mono.justOrEmpty((Object)((DeletedCertificateBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeletedCertificateBundle> getDeletedCertificateAsync(String vaultBaseUrl, String certificateName, Context context) {
        return this.getDeletedCertificateWithResponseAsync(vaultBaseUrl, certificateName, context).flatMap(res -> Mono.justOrEmpty((Object)((DeletedCertificateBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeletedCertificateBundle> getDeletedCertificateWithResponse(String vaultBaseUrl, String certificateName, Context context) {
        String accept = "application/json";
        return this.service.getDeletedCertificateSync(vaultBaseUrl, certificateName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeletedCertificateBundle getDeletedCertificate(String vaultBaseUrl, String certificateName) {
        return (DeletedCertificateBundle)this.getDeletedCertificateWithResponse(vaultBaseUrl, certificateName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> purgeDeletedCertificateWithResponseAsync(String vaultBaseUrl, String certificateName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.purgeDeletedCertificate(vaultBaseUrl, certificateName, this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> purgeDeletedCertificateWithResponseAsync(String vaultBaseUrl, String certificateName, Context context) {
        String accept = "application/json";
        return this.service.purgeDeletedCertificate(vaultBaseUrl, certificateName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> purgeDeletedCertificateAsync(String vaultBaseUrl, String certificateName) {
        return this.purgeDeletedCertificateWithResponseAsync(vaultBaseUrl, certificateName).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> purgeDeletedCertificateAsync(String vaultBaseUrl, String certificateName, Context context) {
        return this.purgeDeletedCertificateWithResponseAsync(vaultBaseUrl, certificateName, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> purgeDeletedCertificateWithResponse(String vaultBaseUrl, String certificateName, Context context) {
        String accept = "application/json";
        return this.service.purgeDeletedCertificateSync(vaultBaseUrl, certificateName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void purgeDeletedCertificate(String vaultBaseUrl, String certificateName) {
        this.purgeDeletedCertificateWithResponse(vaultBaseUrl, certificateName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateBundle>> recoverDeletedCertificateWithResponseAsync(String vaultBaseUrl, String certificateName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.recoverDeletedCertificate(vaultBaseUrl, certificateName, this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateBundle>> recoverDeletedCertificateWithResponseAsync(String vaultBaseUrl, String certificateName, Context context) {
        String accept = "application/json";
        return this.service.recoverDeletedCertificate(vaultBaseUrl, certificateName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateBundle> recoverDeletedCertificateAsync(String vaultBaseUrl, String certificateName) {
        return this.recoverDeletedCertificateWithResponseAsync(vaultBaseUrl, certificateName).flatMap(res -> Mono.justOrEmpty((Object)((CertificateBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateBundle> recoverDeletedCertificateAsync(String vaultBaseUrl, String certificateName, Context context) {
        return this.recoverDeletedCertificateWithResponseAsync(vaultBaseUrl, certificateName, context).flatMap(res -> Mono.justOrEmpty((Object)((CertificateBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateBundle> recoverDeletedCertificateWithResponse(String vaultBaseUrl, String certificateName, Context context) {
        String accept = "application/json";
        return this.service.recoverDeletedCertificateSync(vaultBaseUrl, certificateName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateBundle recoverDeletedCertificate(String vaultBaseUrl, String certificateName) {
        return (CertificateBundle)this.recoverDeletedCertificateWithResponse(vaultBaseUrl, certificateName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<CertificateItem>> getCertificatesNextSinglePageAsync(String nextLink, String vaultBaseUrl) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCertificatesNext(nextLink, vaultBaseUrl, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CertificateListResult)res.getValue()).getValue(), ((CertificateListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<CertificateItem>> getCertificatesNextSinglePageAsync(String nextLink, String vaultBaseUrl, Context context) {
        String accept = "application/json";
        return this.service.getCertificatesNext(nextLink, vaultBaseUrl, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CertificateListResult)res.getValue()).getValue(), ((CertificateListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<CertificateItem> getCertificatesNextSinglePage(String nextLink, String vaultBaseUrl) {
        String accept = "application/json";
        Response<CertificateListResult> res = this.service.getCertificatesNextSync(nextLink, vaultBaseUrl, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CertificateListResult)res.getValue()).getValue(), ((CertificateListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<CertificateItem> getCertificatesNextSinglePage(String nextLink, String vaultBaseUrl, Context context) {
        String accept = "application/json";
        Response<CertificateListResult> res = this.service.getCertificatesNextSync(nextLink, vaultBaseUrl, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CertificateListResult)res.getValue()).getValue(), ((CertificateListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<CertificateIssuerItem>> getCertificateIssuersNextSinglePageAsync(String nextLink, String vaultBaseUrl) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCertificateIssuersNext(nextLink, vaultBaseUrl, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CertificateIssuerListResult)res.getValue()).getValue(), ((CertificateIssuerListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<CertificateIssuerItem>> getCertificateIssuersNextSinglePageAsync(String nextLink, String vaultBaseUrl, Context context) {
        String accept = "application/json";
        return this.service.getCertificateIssuersNext(nextLink, vaultBaseUrl, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CertificateIssuerListResult)res.getValue()).getValue(), ((CertificateIssuerListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<CertificateIssuerItem> getCertificateIssuersNextSinglePage(String nextLink, String vaultBaseUrl) {
        String accept = "application/json";
        Response<CertificateIssuerListResult> res = this.service.getCertificateIssuersNextSync(nextLink, vaultBaseUrl, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CertificateIssuerListResult)res.getValue()).getValue(), ((CertificateIssuerListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<CertificateIssuerItem> getCertificateIssuersNextSinglePage(String nextLink, String vaultBaseUrl, Context context) {
        String accept = "application/json";
        Response<CertificateIssuerListResult> res = this.service.getCertificateIssuersNextSync(nextLink, vaultBaseUrl, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CertificateIssuerListResult)res.getValue()).getValue(), ((CertificateIssuerListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<CertificateItem>> getCertificateVersionsNextSinglePageAsync(String nextLink, String vaultBaseUrl) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCertificateVersionsNext(nextLink, vaultBaseUrl, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CertificateListResult)res.getValue()).getValue(), ((CertificateListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<CertificateItem>> getCertificateVersionsNextSinglePageAsync(String nextLink, String vaultBaseUrl, Context context) {
        String accept = "application/json";
        return this.service.getCertificateVersionsNext(nextLink, vaultBaseUrl, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CertificateListResult)res.getValue()).getValue(), ((CertificateListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<CertificateItem> getCertificateVersionsNextSinglePage(String nextLink, String vaultBaseUrl) {
        String accept = "application/json";
        Response<CertificateListResult> res = this.service.getCertificateVersionsNextSync(nextLink, vaultBaseUrl, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CertificateListResult)res.getValue()).getValue(), ((CertificateListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<CertificateItem> getCertificateVersionsNextSinglePage(String nextLink, String vaultBaseUrl, Context context) {
        String accept = "application/json";
        Response<CertificateListResult> res = this.service.getCertificateVersionsNextSync(nextLink, vaultBaseUrl, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CertificateListResult)res.getValue()).getValue(), ((CertificateListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DeletedCertificateItem>> getDeletedCertificatesNextSinglePageAsync(String nextLink, String vaultBaseUrl) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDeletedCertificatesNext(nextLink, vaultBaseUrl, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedCertificateListResult)res.getValue()).getValue(), ((DeletedCertificateListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DeletedCertificateItem>> getDeletedCertificatesNextSinglePageAsync(String nextLink, String vaultBaseUrl, Context context) {
        String accept = "application/json";
        return this.service.getDeletedCertificatesNext(nextLink, vaultBaseUrl, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedCertificateListResult)res.getValue()).getValue(), ((DeletedCertificateListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DeletedCertificateItem> getDeletedCertificatesNextSinglePage(String nextLink, String vaultBaseUrl) {
        String accept = "application/json";
        Response<DeletedCertificateListResult> res = this.service.getDeletedCertificatesNextSync(nextLink, vaultBaseUrl, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedCertificateListResult)res.getValue()).getValue(), ((DeletedCertificateListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DeletedCertificateItem> getDeletedCertificatesNextSinglePage(String nextLink, String vaultBaseUrl, Context context) {
        String accept = "application/json";
        Response<DeletedCertificateListResult> res = this.service.getDeletedCertificatesNextSync(nextLink, vaultBaseUrl, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedCertificateListResult)res.getValue()).getValue(), ((DeletedCertificateListResult)res.getValue()).getNextLink(), null);
    }

    @Host(value="{vaultBaseUrl}")
    @ServiceInterface(name="CertificateClient")
    public static interface CertificateClientService {
        @Get(value="/certificates")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<CertificateListResult>> getCertificates(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="includePending") Boolean var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/certificates")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<CertificateListResult> getCertificatesSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="includePending") Boolean var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Delete(value="/certificates/{certificate-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<DeletedCertificateBundle>> deleteCertificate(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/certificates/{certificate-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<DeletedCertificateBundle> deleteCertificateSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Put(value="/certificates/contacts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<Contacts>> setCertificateContacts(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") Contacts var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Put(value="/certificates/contacts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<Contacts> setCertificateContactsSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") Contacts var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/certificates/contacts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<Contacts>> getCertificateContacts(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/certificates/contacts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<Contacts> getCertificateContactsSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Delete(value="/certificates/contacts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<Contacts>> deleteCertificateContacts(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Delete(value="/certificates/contacts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<Contacts> deleteCertificateContactsSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/certificates/issuers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<CertificateIssuerListResult>> getCertificateIssuers(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/certificates/issuers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<CertificateIssuerListResult> getCertificateIssuersSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Put(value="/certificates/issuers/{issuer-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<IssuerBundle>> setCertificateIssuer(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="issuer-name") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CertificateIssuerSetParameters var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Put(value="/certificates/issuers/{issuer-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<IssuerBundle> setCertificateIssuerSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="issuer-name") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CertificateIssuerSetParameters var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Patch(value="/certificates/issuers/{issuer-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<IssuerBundle>> updateCertificateIssuer(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="issuer-name") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CertificateIssuerUpdateParameters var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Patch(value="/certificates/issuers/{issuer-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<IssuerBundle> updateCertificateIssuerSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="issuer-name") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CertificateIssuerUpdateParameters var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/certificates/issuers/{issuer-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<IssuerBundle>> getCertificateIssuer(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="issuer-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/certificates/issuers/{issuer-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<IssuerBundle> getCertificateIssuerSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="issuer-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/certificates/issuers/{issuer-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<IssuerBundle>> deleteCertificateIssuer(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="issuer-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/certificates/issuers/{issuer-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<IssuerBundle> deleteCertificateIssuerSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="issuer-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/certificates/{certificate-name}/create")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<CertificateOperation>> createCertificate(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CertificateCreateParameters var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/certificates/{certificate-name}/create")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<CertificateOperation> createCertificateSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CertificateCreateParameters var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/certificates/{certificate-name}/import")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<CertificateBundle>> importCertificate(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CertificateImportParameters var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/certificates/{certificate-name}/import")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<CertificateBundle> importCertificateSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CertificateImportParameters var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/certificates/{certificate-name}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<CertificateListResult>> getCertificateVersions(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="maxresults") Integer var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/certificates/{certificate-name}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<CertificateListResult> getCertificateVersionsSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="maxresults") Integer var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/certificates/{certificate-name}/policy")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<CertificatePolicy>> getCertificatePolicy(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/certificates/{certificate-name}/policy")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<CertificatePolicy> getCertificatePolicySync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Patch(value="/certificates/{certificate-name}/policy")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<CertificatePolicy>> updateCertificatePolicy(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CertificatePolicy var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Patch(value="/certificates/{certificate-name}/policy")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<CertificatePolicy> updateCertificatePolicySync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CertificatePolicy var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Patch(value="/certificates/{certificate-name}/{certificate-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<CertificateBundle>> updateCertificate(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @PathParam(value="certificate-version") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") CertificateUpdateParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Patch(value="/certificates/{certificate-name}/{certificate-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<CertificateBundle> updateCertificateSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @PathParam(value="certificate-version") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") CertificateUpdateParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/certificates/{certificate-name}/{certificate-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<CertificateBundle>> getCertificate(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @PathParam(value="certificate-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/certificates/{certificate-name}/{certificate-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<CertificateBundle> getCertificateSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @PathParam(value="certificate-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Patch(value="/certificates/{certificate-name}/pending")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<CertificateOperation>> updateCertificateOperation(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CertificateOperationUpdateParameter var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Patch(value="/certificates/{certificate-name}/pending")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<CertificateOperation> updateCertificateOperationSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CertificateOperationUpdateParameter var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/certificates/{certificate-name}/pending")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<CertificateOperation>> getCertificateOperation(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/certificates/{certificate-name}/pending")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<CertificateOperation> getCertificateOperationSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/certificates/{certificate-name}/pending")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<CertificateOperation>> deleteCertificateOperation(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/certificates/{certificate-name}/pending")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<CertificateOperation> deleteCertificateOperationSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/certificates/{certificate-name}/pending/merge")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<CertificateBundle>> mergeCertificate(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CertificateMergeParameters var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/certificates/{certificate-name}/pending/merge")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<CertificateBundle> mergeCertificateSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CertificateMergeParameters var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/certificates/{certificate-name}/backup")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<BackupCertificateResult>> backupCertificate(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/certificates/{certificate-name}/backup")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<BackupCertificateResult> backupCertificateSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/certificates/restore")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<CertificateBundle>> restoreCertificate(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") CertificateRestoreParameters var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/certificates/restore")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<CertificateBundle> restoreCertificateSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") CertificateRestoreParameters var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/deletedcertificates")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<DeletedCertificateListResult>> getDeletedCertificates(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="includePending") Boolean var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/deletedcertificates")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<DeletedCertificateListResult> getDeletedCertificatesSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="includePending") Boolean var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/deletedcertificates/{certificate-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<DeletedCertificateBundle>> getDeletedCertificate(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/deletedcertificates/{certificate-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<DeletedCertificateBundle> getDeletedCertificateSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/deletedcertificates/{certificate-name}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<Void>> purgeDeletedCertificate(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/deletedcertificates/{certificate-name}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<Void> purgeDeletedCertificateSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/deletedcertificates/{certificate-name}/recover")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<CertificateBundle>> recoverDeletedCertificate(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/deletedcertificates/{certificate-name}/recover")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<CertificateBundle> recoverDeletedCertificateSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="certificate-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<CertificateListResult>> getCertificatesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<CertificateListResult> getCertificatesNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<CertificateIssuerListResult>> getCertificateIssuersNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<CertificateIssuerListResult> getCertificateIssuersNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<CertificateListResult>> getCertificateVersionsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<CertificateListResult> getCertificateVersionsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<DeletedCertificateListResult>> getDeletedCertificatesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<DeletedCertificateListResult> getDeletedCertificatesNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

