/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.core.util.Base64Url;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.implementation.models.CertificateAttributes;
import com.azure.security.keyvault.certificates.implementation.models.CertificateItem;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.Objects;

public final class DeletedCertificateItem
extends CertificateItem {
    private String recoveryId;
    private Long scheduledPurgeDate;
    private Long deletedDate;

    public String getRecoveryId() {
        return this.recoveryId;
    }

    public DeletedCertificateItem setRecoveryId(String recoveryId) {
        this.recoveryId = recoveryId;
        return this;
    }

    public OffsetDateTime getScheduledPurgeDate() {
        if (this.scheduledPurgeDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.scheduledPurgeDate), ZoneOffset.UTC);
    }

    public OffsetDateTime getDeletedDate() {
        if (this.deletedDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.deletedDate), ZoneOffset.UTC);
    }

    @Override
    public DeletedCertificateItem setId(String id) {
        super.setId(id);
        return this;
    }

    @Override
    public DeletedCertificateItem setAttributes(CertificateAttributes attributes) {
        super.setAttributes(attributes);
        return this;
    }

    @Override
    public DeletedCertificateItem setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    @Override
    public DeletedCertificateItem setX509Thumbprint(byte[] x509Thumbprint) {
        super.setX509Thumbprint(x509Thumbprint);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.getAttributes());
        jsonWriter.writeMapField("tags", this.getTags(), (writer, element) -> writer.writeString(element));
        if (this.getX509Thumbprint() != null) {
            jsonWriter.writeStringField("x5t", Objects.toString(Base64Url.encode((byte[])this.getX509Thumbprint()), null));
        }
        jsonWriter.writeStringField("recoveryId", this.recoveryId);
        return jsonWriter.writeEndObject();
    }

    public static DeletedCertificateItem fromJson(JsonReader jsonReader) throws IOException {
        return (DeletedCertificateItem)jsonReader.readObject(reader -> {
            DeletedCertificateItem deserializedDeletedCertificateItem = new DeletedCertificateItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDeletedCertificateItem.setId(reader.getString());
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedDeletedCertificateItem.setAttributes(CertificateAttributes.fromJson(reader));
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDeletedCertificateItem.setTags(tags);
                    continue;
                }
                if ("x5t".equals(fieldName)) {
                    Base64Url x509Thumbprint = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    if (x509Thumbprint == null) continue;
                    deserializedDeletedCertificateItem.setX509Thumbprint(x509Thumbprint.decodedBytes());
                    continue;
                }
                if ("recoveryId".equals(fieldName)) {
                    deserializedDeletedCertificateItem.recoveryId = reader.getString();
                    continue;
                }
                if ("scheduledPurgeDate".equals(fieldName)) {
                    deserializedDeletedCertificateItem.scheduledPurgeDate = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("deletedDate".equals(fieldName)) {
                    deserializedDeletedCertificateItem.deletedDate = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeletedCertificateItem;
        });
    }
}

